/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.value.impl;

import java.util.List;
import java.util.UUID;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jsp.ValuePrinter;
import uk.ac.nesc.rapid.value.Value;
import uk.ac.nesc.rapid.value.impl.BaseValue;
import uk.ac.nesc.rapid.value.impl.SingleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@DiscriminatorValue(value="JOBIDVALUE")
@Table(name="JOBIDVALUE")
public class JobIDValue
extends BaseValue
implements PersistenceCapable {
    private UUID uuid = UUID.randomUUID();
    private static char divider = (char)45;
    private static int pcInheritedFieldCount = BaseValue.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Luk$ac$nesc$rapid$value$impl$BaseValue;
    static /* synthetic */ Class class$Ljava$util$UUID;
    static /* synthetic */ Class class$Luk$ac$nesc$rapid$value$impl$JobIDValue;

    public JobIDValue() {
    }

    public JobIDValue(int numberOfSubJobs) {
    }

    public String getJobID() {
        return JobIDValue.pcGetuuid(this).toString();
    }

    public void setJobID(String jobID) {
        JobIDValue.pcSetuuid(this, UUID.fromString(jobID));
    }

    public String getSubJobID(int index) {
        return JobIDValue.pcGetuuid(this).toString() + divider + index;
    }

    public static String getJobID(String subJobID) throws RapidException {
        try {
            return subJobID.substring(0, 36);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new RapidException("Invalid jobID! '" + subJobID + "'");
        }
    }

    public static int getSubJobIndex(Value jobID) throws RapidException {
        return JobIDValue.getSubJobIndex(jobID.get());
    }

    public static int getSubJobIndex(String subJobID) throws RapidException {
        try {
            if (subJobID.length() == 36) {
                return 0;
            }
            return Integer.parseInt(subJobID.substring(37, subJobID.length()));
        }
        catch (NumberFormatException ex) {
            throw new RapidException("Invalid subjobID!");
        }
        catch (IndexOutOfBoundsException ex) {
            throw new RapidException("Invalid jobID! '" + subJobID + "'");
        }
    }

    @Override
    public String get() {
        return this.get(0);
    }

    @Override
    public String get(int index) {
        return this.getSubJobID(index);
    }

    @Override
    public void put(String value) {
        this.setJobID(value);
    }

    @Override
    public void put(String[] values) {
    }

    @Override
    public void put(List<String> values) {
    }

    @Override
    public String print(ValuePrinter output) throws RapidException {
        return output.print(new SingleValue(this.getJobID()));
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Value copy() {
        JobIDValue result = new JobIDValue();
        result.setJobID(this.getJobID());
        return result;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 53 * super.hashCode();
        hash = 67 * hash + (JobIDValue.pcGetuuid(this) != null ? JobIDValue.pcGetuuid(this).hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobIDValue other = (JobIDValue)obj;
        if (!super.equals(other)) {
            return false;
        }
        return JobIDValue.pcGetuuid(this) == JobIDValue.pcGetuuid(other) || JobIDValue.pcGetuuid(this) != null && JobIDValue.pcGetuuid(this).equals(JobIDValue.pcGetuuid(other));
    }

    @Override
    public String resolve(JobData data, int subJob) throws RapidException {
        return this.getSubJobID(subJob);
    }

    @Override
    public int resolveSize(JobData data) throws RapidException {
        return 1;
    }

    public String toString() {
        return this.getJobID();
    }

    static {
        Class clazz = class$Luk$ac$nesc$rapid$value$impl$BaseValue != null ? class$Luk$ac$nesc$rapid$value$impl$BaseValue : (class$Luk$ac$nesc$rapid$value$impl$BaseValue = JobIDValue.class$("uk.ac.nesc.rapid.value.impl.BaseValue"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"uuid"};
        Class[] classArray = new Class[1];
        Class clazz2 = class$Ljava$util$UUID != null ? class$Ljava$util$UUID : (class$Ljava$util$UUID = JobIDValue.class$("java.util.UUID"));
        classArray[0] = clazz2;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26};
        Class clazz3 = class$Luk$ac$nesc$rapid$value$impl$JobIDValue != null ? class$Luk$ac$nesc$rapid$value$impl$JobIDValue : (class$Luk$ac$nesc$rapid$value$impl$JobIDValue = JobIDValue.class$("uk.ac.nesc.rapid.value.impl.JobIDValue"));
        PCRegistry.register((Class)clazz3, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JobIDValue", (PersistenceCapable)new JobIDValue());
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.uuid = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JobIDValue jobIDValue = new JobIDValue();
        if (bl) {
            jobIDValue.pcClearFields();
        }
        jobIDValue.pcStateManager = stateManager;
        jobIDValue.pcCopyKeyFieldsFromObjectId(object);
        return jobIDValue;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JobIDValue jobIDValue = new JobIDValue();
        if (bl) {
            jobIDValue.pcClearFields();
        }
        jobIDValue.pcStateManager = stateManager;
        return jobIDValue;
    }

    protected static int pcGetManagedFieldCount() {
        return 1 + BaseValue.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.uuid = (UUID)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.uuid);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JobIDValue jobIDValue, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jobIDValue, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.uuid = jobIDValue.uuid;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JobIDValue jobIDValue = (JobIDValue)object;
        if (jobIDValue.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jobIDValue, nArray[n]);
            ++n;
        }
    }

    private static final UUID pcGetuuid(JobIDValue jobIDValue) {
        if (jobIDValue.pcStateManager == null) {
            return jobIDValue.uuid;
        }
        int n = pcInheritedFieldCount + 0;
        jobIDValue.pcStateManager.accessingField(n);
        return jobIDValue.uuid;
    }

    private static final void pcSetuuid(JobIDValue jobIDValue, UUID uUID) {
        if (jobIDValue.pcStateManager == null) {
            jobIDValue.uuid = uUID;
            return;
        }
        jobIDValue.pcStateManager.settingObjectField((PersistenceCapable)jobIDValue, pcInheritedFieldCount + 0, (Object)jobIDValue.uuid, (Object)uUID, 0);
    }
}

