/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.value.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobdata.VariableAnalysis;
import uk.ac.nesc.rapid.jsp.ValuePrinter;
import uk.ac.nesc.rapid.value.Value;
import uk.ac.nesc.rapid.value.impl.BaseValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@DiscriminatorValue(value="ARRAYVALUE")
@Table(name="ARRAYVALUE")
public class ArrayValue
extends BaseValue
implements Serializable,
PersistenceCapable {
    private static final long serialVersionUID = -4203895043454121742L;
    @Basic
    @Lob
    private List<String> valueList = new Vector<String>();
    @Basic
    @Column(name="MINVALUE")
    private Double min = null;
    @Basic
    @Column(name="MAXVALUE")
    private Double max = null;
    @Basic
    @Column(name="REGULAREXP")
    private String regExp = null;
    private static int pcInheritedFieldCount = BaseValue.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Luk$ac$nesc$rapid$value$impl$BaseValue;
    static /* synthetic */ Class class$Ljava$lang$Double;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Luk$ac$nesc$rapid$value$impl$ArrayValue;

    public ArrayValue() {
    }

    public ArrayValue(String[] values) {
        this.put(values);
    }

    public ArrayValue(List<String> values) {
        this.valueList = values;
    }

    public boolean exists(String value) {
        return ArrayValue.pcGetvalueList(this).contains(value);
    }

    @Override
    public String get() {
        return ArrayValue.pcGetvalueList(this).size() > 0 ? (String)ArrayValue.pcGetvalueList(this).get(0) : "";
    }

    @Override
    public String get(int index) {
        if (ArrayValue.pcGetvalueList(this).size() == 0) {
            return "";
        }
        return index < ArrayValue.pcGetvalueList(this).size() ? (String)ArrayValue.pcGetvalueList(this).get(index) : (String)ArrayValue.pcGetvalueList(this).get(ArrayValue.pcGetvalueList(this).size() - 1);
    }

    @Override
    public void put(String value) {
        if (value != null) {
            ArrayValue.pcGetvalueList(this).add(value);
        }
    }

    @Override
    public void put(int index, String value) {
        if (index >= 0 && index < ArrayValue.pcGetvalueList(this).size()) {
            ArrayValue.pcGetvalueList(this).set(index, value);
        }
    }

    @Override
    public void put(String[] values) {
        if (values != null) {
            ArrayValue.pcSetvalueList(this, Arrays.asList(values));
        } else {
            ArrayValue.pcGetvalueList(this).clear();
        }
    }

    @Override
    public void put(List<String> values) {
        if (values == null) {
            ArrayValue.pcGetvalueList(this).clear();
        } else {
            ArrayValue.pcGetvalueList(this).clear();
            for (String value : values) {
                ArrayValue.pcGetvalueList(this).add(value);
            }
        }
    }

    @Override
    public int size() {
        return ArrayValue.pcGetvalueList(this).size();
    }

    @Override
    public String print(ValuePrinter printer) throws RapidException {
        return printer.print(this);
    }

    @Override
    public Value copy() {
        ArrayValue copy = new ArrayValue();
        copy.put(ArrayValue.pcGetvalueList(this));
        copy.setMax(ArrayValue.pcGetmax(this));
        copy.setMin(ArrayValue.pcGetmin(this));
        copy.setRegExp(ArrayValue.pcGetregExp(this));
        copy.setErrorMessage(this.getErrorMessage());
        return copy;
    }

    @Override
    public boolean validate() {
        for (String value : ArrayValue.pcGetvalueList(this)) {
            Double doubleValue;
            if (value == null) {
                return true;
            }
            if (this.getRegExp() != null) {
                try {
                    if (!value.matches(ArrayValue.pcGetregExp(this))) {
                        return false;
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
            }
            if (this.getMin() == null && this.getMax() == null) continue;
            try {
                doubleValue = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            boolean result = true;
            result &= this.getMax() == null ? true : this.getMax() >= doubleValue;
            if (result &= this.getMin() == null ? true : this.getMin() <= doubleValue) continue;
            return result;
        }
        return true;
    }

    public void setMin(Double min) {
        ArrayValue.pcSetmin(this, min);
    }

    public void setMax(Double max) {
        ArrayValue.pcSetmax(this, max);
    }

    public void setMin(double min) {
        ArrayValue.pcSetmin(this, min);
    }

    public void setMax(double max) {
        ArrayValue.pcSetmax(this, max);
    }

    public void setRegExp(String regExp) {
        ArrayValue.pcSetregExp(this, regExp);
    }

    public Double getMin() {
        return ArrayValue.pcGetmin(this);
    }

    public Double getMax() {
        return ArrayValue.pcGetmax(this);
    }

    public String getRegExp() {
        return ArrayValue.pcGetregExp(this);
    }

    @Override
    public String resolve(JobData table, int subJob) throws RapidException {
        VariableAnalysis analysis = new VariableAnalysis(table);
        analysis.setInput(this.get(subJob));
        return analysis.getOutput(subJob);
    }

    @Override
    public int resolveSize(JobData table) throws RapidException {
        if (ArrayValue.pcGetvalueList(this).size() > 1 || ArrayValue.pcGetvalueList(this).size() == 0) {
            return ArrayValue.pcGetvalueList(this).size();
        }
        VariableAnalysis analysis = new VariableAnalysis(table);
        analysis.setInput((String)ArrayValue.pcGetvalueList(this).get(0));
        List<Value> variables = analysis.getVariables();
        int maxValue = 1;
        for (Value var : variables) {
            if (var.size() <= maxValue) continue;
            maxValue = var.size();
        }
        return maxValue;
    }

    public String toString() {
        String result = "";
        result = result + "ArrayValue\n";
        result = result + "regexp: " + this.getRegExp() + "\n";
        result = result + "min " + this.getMin() + "\n";
        result = result + "max " + this.getMax() + "\n";
        result = result + "Contents: \n";
        for (String s : ArrayValue.pcGetvalueList(this)) {
            result = result + s + "\n";
        }
        return result;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 53 * super.hashCode();
        hash = 53 * hash + (ArrayValue.pcGetvalueList(this) != null ? ((Object)ArrayValue.pcGetvalueList(this)).hashCode() : 0);
        hash = 53 * hash + (ArrayValue.pcGetmin(this) != null ? ArrayValue.pcGetmin(this).hashCode() : 0);
        hash = 53 * hash + (ArrayValue.pcGetmax(this) != null ? ArrayValue.pcGetmax(this).hashCode() : 0);
        hash = 53 * hash + (ArrayValue.pcGetregExp(this) != null ? ArrayValue.pcGetregExp(this).hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayValue other = (ArrayValue)obj;
        if (!super.equals(other)) {
            return false;
        }
        if (!(ArrayValue.pcGetvalueList(this) == ArrayValue.pcGetvalueList(other) || ArrayValue.pcGetvalueList(this) != null && ((Object)ArrayValue.pcGetvalueList(this)).equals(ArrayValue.pcGetvalueList(other)))) {
            return false;
        }
        if (!(ArrayValue.pcGetmin(this) == ArrayValue.pcGetmin(other) || ArrayValue.pcGetmin(this) != null && ArrayValue.pcGetmin(this).equals(ArrayValue.pcGetmin(other)))) {
            return false;
        }
        if (!(ArrayValue.pcGetmax(this) == ArrayValue.pcGetmax(other) || ArrayValue.pcGetmax(this) != null && ArrayValue.pcGetmax(this).equals(ArrayValue.pcGetmax(other)))) {
            return false;
        }
        return ArrayValue.pcGetregExp(this) == ArrayValue.pcGetregExp(other) || ArrayValue.pcGetregExp(this) != null && ArrayValue.pcGetregExp(this).equals(ArrayValue.pcGetregExp(other));
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        Class clazz = class$Luk$ac$nesc$rapid$value$impl$BaseValue != null ? class$Luk$ac$nesc$rapid$value$impl$BaseValue : (class$Luk$ac$nesc$rapid$value$impl$BaseValue = ArrayValue.class$("uk.ac.nesc.rapid.value.impl.BaseValue"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"max", "min", "regExp", "valueList"};
        Class[] classArray = new Class[4];
        Class clazz2 = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = ArrayValue.class$("java.lang.Double"));
        classArray[0] = clazz2;
        classArray[1] = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = ArrayValue.class$("java.lang.Double"));
        Class clazz3 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ArrayValue.class$("java.lang.String"));
        classArray[2] = clazz3;
        Class clazz4 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = ArrayValue.class$("java.util.List"));
        classArray[3] = clazz4;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 10};
        Class clazz5 = class$Luk$ac$nesc$rapid$value$impl$ArrayValue != null ? class$Luk$ac$nesc$rapid$value$impl$ArrayValue : (class$Luk$ac$nesc$rapid$value$impl$ArrayValue = ArrayValue.class$("uk.ac.nesc.rapid.value.impl.ArrayValue"));
        PCRegistry.register((Class)clazz5, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"ArrayValue", (PersistenceCapable)new ArrayValue());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.max = null;
        this.min = null;
        this.regExp = null;
        this.valueList = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        ArrayValue arrayValue = new ArrayValue();
        if (bl) {
            arrayValue.pcClearFields();
        }
        arrayValue.pcStateManager = stateManager;
        arrayValue.pcCopyKeyFieldsFromObjectId(object);
        return arrayValue;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        ArrayValue arrayValue = new ArrayValue();
        if (bl) {
            arrayValue.pcClearFields();
        }
        arrayValue.pcStateManager = stateManager;
        return arrayValue;
    }

    protected static int pcGetManagedFieldCount() {
        return 4 + BaseValue.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.max = (Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.min = (Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.regExp = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.valueList = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.max);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.min);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.regExp);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.valueList);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(ArrayValue arrayValue, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(arrayValue, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.max = arrayValue.max;
                return;
            }
            case 1: {
                this.min = arrayValue.min;
                return;
            }
            case 2: {
                this.regExp = arrayValue.regExp;
                return;
            }
            case 3: {
                this.valueList = arrayValue.valueList;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        ArrayValue arrayValue = (ArrayValue)object;
        if (arrayValue.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(arrayValue, nArray[n]);
            ++n;
        }
    }

    private static final Double pcGetmax(ArrayValue arrayValue) {
        if (arrayValue.pcStateManager == null) {
            return arrayValue.max;
        }
        int n = pcInheritedFieldCount + 0;
        arrayValue.pcStateManager.accessingField(n);
        return arrayValue.max;
    }

    private static final void pcSetmax(ArrayValue arrayValue, Double d) {
        if (arrayValue.pcStateManager == null) {
            arrayValue.max = d;
            return;
        }
        arrayValue.pcStateManager.settingObjectField((PersistenceCapable)arrayValue, pcInheritedFieldCount + 0, (Object)arrayValue.max, (Object)d, 0);
    }

    private static final Double pcGetmin(ArrayValue arrayValue) {
        if (arrayValue.pcStateManager == null) {
            return arrayValue.min;
        }
        int n = pcInheritedFieldCount + 1;
        arrayValue.pcStateManager.accessingField(n);
        return arrayValue.min;
    }

    private static final void pcSetmin(ArrayValue arrayValue, Double d) {
        if (arrayValue.pcStateManager == null) {
            arrayValue.min = d;
            return;
        }
        arrayValue.pcStateManager.settingObjectField((PersistenceCapable)arrayValue, pcInheritedFieldCount + 1, (Object)arrayValue.min, (Object)d, 0);
    }

    private static final String pcGetregExp(ArrayValue arrayValue) {
        if (arrayValue.pcStateManager == null) {
            return arrayValue.regExp;
        }
        int n = pcInheritedFieldCount + 2;
        arrayValue.pcStateManager.accessingField(n);
        return arrayValue.regExp;
    }

    private static final void pcSetregExp(ArrayValue arrayValue, String string) {
        if (arrayValue.pcStateManager == null) {
            arrayValue.regExp = string;
            return;
        }
        arrayValue.pcStateManager.settingStringField((PersistenceCapable)arrayValue, pcInheritedFieldCount + 2, arrayValue.regExp, string, 0);
    }

    private static final List pcGetvalueList(ArrayValue arrayValue) {
        if (arrayValue.pcStateManager == null) {
            return arrayValue.valueList;
        }
        int n = pcInheritedFieldCount + 3;
        arrayValue.pcStateManager.accessingField(n);
        return arrayValue.valueList;
    }

    private static final void pcSetvalueList(ArrayValue arrayValue, List list) {
        if (arrayValue.pcStateManager == null) {
            arrayValue.valueList = list;
            return;
        }
        arrayValue.pcStateManager.settingObjectField((PersistenceCapable)arrayValue, pcInheritedFieldCount + 3, arrayValue.valueList, (Object)list, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

