/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.symbol.impl;

import java.util.List;
import org.apache.commons.fileupload.FileItem;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.symbol.Symbol;
import uk.ac.nesc.rapid.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolImpl
implements Symbol {
    private String variableName = "";
    private String symbolName = "";
    private String page = "";
    private boolean readonly = true;
    private int subJob = -1;

    public void setVariableName(String name) {
        this.variableName = name;
    }

    public String getVariableName() {
        return this.variableName;
    }

    @Override
    public Value get(JobData table) throws RapidException {
        return table.getVariable(this.variableName);
    }

    @Override
    public void put(JobData table, Value value) throws RapidException {
        if (!this.isReadOnly()) {
            table.setVariable(this.variableName, value);
        }
    }

    @Override
    public void put(JobData table, FileItem item) throws RapidException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void put(JobData table, List<String> values) throws RapidException {
        if (!this.isReadOnly()) {
            Value value = this.get(table);
            if (this.getSubJob() > -1 && values.size() > 0) {
                value.put(this.getSubJob(), values.get(0));
            } else {
                value.put(values);
            }
        }
    }

    @Override
    public String getPage() {
        return this.page;
    }

    @Override
    public void setPage(String page) {
        this.page = page;
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public void setReadOnly(boolean readonly) {
        this.readonly = readonly;
    }

    @Override
    public int getSubJob() {
        return this.subJob;
    }

    @Override
    public void setSubJob(int subJob) {
        this.subJob = subJob;
    }

    @Override
    public String getSymbolName() {
        return this.symbolName;
    }

    @Override
    public void setSymbolName(String name) {
        this.symbolName = name;
    }

    public String toString() {
        String result = "\nxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\n";
        result = result + "Symbol " + this.symbolName + "\n";
        result = result + "variable " + this.variableName + "\n";
        result = result + "page " + this.page + "\n";
        result = result + "subjob " + this.subJob + "\n";
        result = result + "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        return result;
    }
}

