/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.jobmanager.bes;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.JobState;
import uk.ac.nesc.rapid.value.Value;
import uk.ac.nesc.rapid.value.impl.ArrayValue;
import uk.ac.nesc.rapid.value.impl.SingleValue;

@Entity
@Table(name="BESSTATE")
public class BESState
extends JobState
implements PersistenceCapable {
    @Transient
    public static final int START = 0;
    @Transient
    public static final int SOURCE = 1;
    @Transient
    public static final int EXECUTE = 2;
    @Transient
    public static final int MONITOR = 3;
    @Transient
    public static final int TARGET = 4;
    @Transient
    public static final int CLEAN = 5;
    @Transient
    public static final int FINISHED = 6;
    @Transient
    public static final int ERROR = 7;
    @Transient
    public static final int PLUGIN_INITIALISING = 0;
    @Transient
    public static final int PLUGIN_SUBMITTED = 1;
    @Transient
    public static final int PLUGIN_SUSPENDED = 2;
    @Transient
    public static final int PLUGIN_RUNNING = 3;
    @Transient
    public static final int PLUGIN_FINISHED = 4;
    @Transient
    public static final int PLUGIN_ERROR = 5;
    @Transient
    private static final String[] standardMessageList = new String[]{"The job is starting", "Copying files into execution host", "Submitting the job", "Submitting the job", "Copying result files out of execution host", "Cleaning up files", "The job has completed successfully", "An error has occurred!", "Job Submission Failed1"};
    @Transient
    private static final String[] standardPluginMessageList = new String[]{"The job is initialising", "The job has been submitted", "The job has been suspended", "The job is running", "The job has finished executing on the execution host.", "An error has occurred!"};
    @Basic
    @Lob
    private String[] remoteJobID = null;
    @Basic
    private boolean pluginActive = false;
    @Basic
    @Lob
    private List<Integer> pluginStateList = new Vector<Integer>();
    @Basic
    @Lob
    private List<String> pluginMessageList = new Vector<String>();
    @Basic
    private int state = 0;
    @Basic
    private String message = standardPluginMessageList[0];
    private static int pcInheritedFieldCount = JobState.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Luk$ac$nesc$rapid$jobsubmission$jobmanager$JobState;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$L$Ljava$lang$String$;
    static /* synthetic */ Class class$Luk$ac$nesc$rapid$jobsubmission$jobmanager$bes$BESState;

    public boolean isPluginActive() {
        return BESState.pcGetpluginActive(this);
    }

    public void setPluginActive(boolean pluginActive) {
        BESState.pcSetpluginActive(this, pluginActive);
    }

    public String[] getRemoteJobID() {
        return BESState.pcGetremoteJobID(this);
    }

    public void setRemoteJobID(String[] remoteJobID) {
        BESState.pcSetremoteJobID(this, remoteJobID);
    }

    public int getState() {
        return BESState.pcGetstate(this);
    }

    public void setState(int state) {
        this.setState(state, standardMessageList[state]);
    }

    public void setState(int state, String message) {
        BESState.pcSetstate(this, state);
        BESState.pcSetmessage(this, message);
    }

    public boolean pluginDone() {
        if (BESState.pcGetpluginStateList(this).size() == 0) {
            return false;
        }
        boolean done = true;
        Iterator i$ = BESState.pcGetpluginStateList(this).iterator();
        while (i$.hasNext()) {
            int plgnState = (Integer)i$.next();
            done = done && (plgnState == 5 || plgnState == 4);
        }
        return done;
    }

    public boolean pluginError() {
        if (BESState.pcGetpluginStateList(this).size() == 0) {
            return false;
        }
        boolean error = false;
        Iterator i$ = BESState.pcGetpluginStateList(this).iterator();
        while (i$.hasNext()) {
            int plgnState = (Integer)i$.next();
            error &= plgnState != 5;
        }
        return error;
    }

    public int getPluginState(int subJob) {
        return subJob < 0 || subJob >= BESState.pcGetpluginStateList(this).size() ? 7 : (Integer)BESState.pcGetpluginStateList(this).get(subJob);
    }

    public void setPluginState(int subJob, int state) {
        this.setPluginState(subJob, state, standardPluginMessageList[state]);
    }

    public void setPluginState(int subJob, int state, String message) {
        while (subJob >= BESState.pcGetpluginStateList(this).size()) {
            BESState.pcGetpluginStateList(this).add(0);
        }
        while (subJob >= BESState.pcGetpluginMessageList(this).size()) {
            BESState.pcGetpluginMessageList(this).add("");
        }
        BESState.pcGetpluginStateList(this).set(subJob, state);
        BESState.pcGetpluginMessageList(this).set(subJob, message);
    }

    public int getNumberOfSubJobs() {
        return BESState.pcGetpluginStateList(this).size();
    }

    public Value getMessage() {
        return this.isPluginActive() ? new ArrayValue(BESState.pcGetpluginMessageList(this)) : new SingleValue(BESState.pcGetmessage(this));
    }

    public String toString() {
        String result = "";
        result = result + "BES state\n";
        result = result + "Remote IDS ";
        if (BESState.pcGetremoteJobID(this) != null) {
            for (String rmtJobID : BESState.pcGetremoteJobID(this)) {
                result = result + " : " + rmtJobID;
            }
        }
        result = result + "\n";
        result = result + "Plugin " + (BESState.pcGetpluginActive(this) ? "IS" : "is NOT") + " active\n";
        result = result + "State " + BESState.pcGetstate(this) + "\n";
        result = result + "Message " + BESState.pcGetmessage(this) + "\n";
        result = result + "Plugin States ";
        Iterator i$ = BESState.pcGetpluginStateList(this).iterator();
        while (i$.hasNext()) {
            int plgnState = (Integer)i$.next();
            result = result + " : " + plgnState;
        }
        result = result + "\nPlugin Messages";
        for (String plgnMessage : BESState.pcGetpluginMessageList(this)) {
            result = result + " : " + plgnMessage;
        }
        result = result + "\n";
        result = result + super.toString();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BESState other = (BESState)obj;
        if (!super.equals(other)) {
            return false;
        }
        if (!(BESState.pcGetremoteJobID(this) == BESState.pcGetremoteJobID(other) || BESState.pcGetremoteJobID(this) != null && Arrays.equals(BESState.pcGetremoteJobID(this), BESState.pcGetremoteJobID(other)))) {
            return false;
        }
        if (BESState.pcGetpluginActive(this) != BESState.pcGetpluginActive(other)) {
            return false;
        }
        if (!(BESState.pcGetpluginStateList(this) == BESState.pcGetpluginStateList(other) || BESState.pcGetpluginStateList(this) != null && ((Object)BESState.pcGetpluginStateList(this)).equals(BESState.pcGetpluginStateList(other)))) {
            return false;
        }
        if (!(BESState.pcGetpluginMessageList(this) == BESState.pcGetpluginMessageList(other) || BESState.pcGetpluginMessageList(this) != null && ((Object)BESState.pcGetpluginMessageList(this)).equals(BESState.pcGetpluginMessageList(other)))) {
            return false;
        }
        if (BESState.pcGetstate(this) != BESState.pcGetstate(other)) {
            return false;
        }
        return BESState.pcGetmessage(this) == BESState.pcGetmessage(other) || BESState.pcGetmessage(this) != null && BESState.pcGetmessage(this).equals(BESState.pcGetmessage(other));
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 53 * hash + (BESState.pcGetremoteJobID(this) != null ? Arrays.hashCode(BESState.pcGetremoteJobID(this)) : 0);
        hash = 53 * hash + (BESState.pcGetpluginActive(this) ? 1 : 0);
        hash = 53 * hash + (BESState.pcGetpluginStateList(this) != null ? ((Object)BESState.pcGetpluginStateList(this)).hashCode() : 0);
        hash = 53 * hash + (BESState.pcGetpluginMessageList(this) != null ? ((Object)BESState.pcGetpluginMessageList(this)).hashCode() : 0);
        hash = 53 * hash + BESState.pcGetstate(this);
        hash = 53 * hash + (BESState.pcGetmessage(this) != null ? BESState.pcGetmessage(this).hashCode() : 0);
        return hash;
    }

    static {
        Class clazz = class$Luk$ac$nesc$rapid$jobsubmission$jobmanager$JobState != null ? class$Luk$ac$nesc$rapid$jobsubmission$jobmanager$JobState : (class$Luk$ac$nesc$rapid$jobsubmission$jobmanager$JobState = BESState.class$("uk.ac.nesc.rapid.jobsubmission.jobmanager.JobState"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"message", "pluginActive", "pluginMessageList", "pluginStateList", "remoteJobID", "state"};
        Class[] classArray = new Class[6];
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = BESState.class$("java.lang.String"));
        classArray[0] = clazz2;
        classArray[1] = Boolean.TYPE;
        Class clazz3 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = BESState.class$("java.util.List"));
        classArray[2] = clazz3;
        classArray[3] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = BESState.class$("java.util.List"));
        Class clazz4 = class$L$Ljava$lang$String$ != null ? class$L$Ljava$lang$String$ : (class$L$Ljava$lang$String$ = BESState.class$("[Ljava.lang.String;"));
        classArray[4] = clazz4;
        classArray[5] = Integer.TYPE;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 10, 10, 26, 26};
        Class clazz5 = class$Luk$ac$nesc$rapid$jobsubmission$jobmanager$bes$BESState != null ? class$Luk$ac$nesc$rapid$jobsubmission$jobmanager$bes$BESState : (class$Luk$ac$nesc$rapid$jobsubmission$jobmanager$bes$BESState = BESState.class$("uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.BESState"));
        PCRegistry.register((Class)clazz5, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"BESState", (PersistenceCapable)new BESState());
    }

    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        super.pcClearFields();
        this.message = null;
        this.pluginActive = false;
        this.pluginMessageList = null;
        this.pluginStateList = null;
        this.remoteJobID = null;
        this.state = 0;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        BESState bESState = new BESState();
        if (bl) {
            bESState.pcClearFields();
        }
        bESState.pcStateManager = stateManager;
        bESState.pcCopyKeyFieldsFromObjectId(object);
        return bESState;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        BESState bESState = new BESState();
        if (bl) {
            bESState.pcClearFields();
        }
        bESState.pcStateManager = stateManager;
        return bESState;
    }

    protected static int pcGetManagedFieldCount() {
        return 6 + JobState.pcGetManagedFieldCount();
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.message = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.pluginActive = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.pluginMessageList = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.pluginStateList = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.remoteJobID = (String[])this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.state = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.message);
                return;
            }
            case 1: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.pluginActive);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.pluginMessageList);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.pluginStateList);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.remoteJobID);
                return;
            }
            case 5: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.state);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(BESState bESState, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(bESState, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.message = bESState.message;
                return;
            }
            case 1: {
                this.pluginActive = bESState.pluginActive;
                return;
            }
            case 2: {
                this.pluginMessageList = bESState.pluginMessageList;
                return;
            }
            case 3: {
                this.pluginStateList = bESState.pluginStateList;
                return;
            }
            case 4: {
                this.remoteJobID = bESState.remoteJobID;
                return;
            }
            case 5: {
                this.state = bESState.state;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        BESState bESState = (BESState)object;
        if (bESState.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(bESState, nArray[n]);
            ++n;
        }
    }

    private static final String pcGetmessage(BESState bESState) {
        if (bESState.pcStateManager == null) {
            return bESState.message;
        }
        int n = pcInheritedFieldCount + 0;
        bESState.pcStateManager.accessingField(n);
        return bESState.message;
    }

    private static final void pcSetmessage(BESState bESState, String string) {
        if (bESState.pcStateManager == null) {
            bESState.message = string;
            return;
        }
        bESState.pcStateManager.settingStringField((PersistenceCapable)bESState, pcInheritedFieldCount + 0, bESState.message, string, 0);
    }

    private static final boolean pcGetpluginActive(BESState bESState) {
        if (bESState.pcStateManager == null) {
            return bESState.pluginActive;
        }
        int n = pcInheritedFieldCount + 1;
        bESState.pcStateManager.accessingField(n);
        return bESState.pluginActive;
    }

    private static final void pcSetpluginActive(BESState bESState, boolean bl) {
        if (bESState.pcStateManager == null) {
            bESState.pluginActive = bl;
            return;
        }
        bESState.pcStateManager.settingBooleanField((PersistenceCapable)bESState, pcInheritedFieldCount + 1, bESState.pluginActive, bl, 0);
    }

    private static final List pcGetpluginMessageList(BESState bESState) {
        if (bESState.pcStateManager == null) {
            return bESState.pluginMessageList;
        }
        int n = pcInheritedFieldCount + 2;
        bESState.pcStateManager.accessingField(n);
        return bESState.pluginMessageList;
    }

    private static final void pcSetpluginMessageList(BESState bESState, List list) {
        if (bESState.pcStateManager == null) {
            bESState.pluginMessageList = list;
            return;
        }
        bESState.pcStateManager.settingObjectField((PersistenceCapable)bESState, pcInheritedFieldCount + 2, bESState.pluginMessageList, (Object)list, 0);
    }

    private static final List pcGetpluginStateList(BESState bESState) {
        if (bESState.pcStateManager == null) {
            return bESState.pluginStateList;
        }
        int n = pcInheritedFieldCount + 3;
        bESState.pcStateManager.accessingField(n);
        return bESState.pluginStateList;
    }

    private static final void pcSetpluginStateList(BESState bESState, List list) {
        if (bESState.pcStateManager == null) {
            bESState.pluginStateList = list;
            return;
        }
        bESState.pcStateManager.settingObjectField((PersistenceCapable)bESState, pcInheritedFieldCount + 3, bESState.pluginStateList, (Object)list, 0);
    }

    private static final String[] pcGetremoteJobID(BESState bESState) {
        if (bESState.pcStateManager == null) {
            return bESState.remoteJobID;
        }
        int n = pcInheritedFieldCount + 4;
        bESState.pcStateManager.accessingField(n);
        return bESState.remoteJobID;
    }

    private static final void pcSetremoteJobID(BESState bESState, String[] stringArray) {
        if (bESState.pcStateManager == null) {
            bESState.remoteJobID = stringArray;
            return;
        }
        bESState.pcStateManager.settingObjectField((PersistenceCapable)bESState, pcInheritedFieldCount + 4, (Object)bESState.remoteJobID, (Object)stringArray, 0);
    }

    private static final int pcGetstate(BESState bESState) {
        if (bESState.pcStateManager == null) {
            return bESState.state;
        }
        int n = pcInheritedFieldCount + 5;
        bESState.pcStateManager.accessingField(n);
        return bESState.state;
    }

    private static final void pcSetstate(BESState bESState, int n) {
        if (bESState.pcStateManager == null) {
            bESState.state = n;
            return;
        }
        bESState.pcStateManager.settingIntField((PersistenceCapable)bESState, pcInheritedFieldCount + 5, bESState.state, n, 0);
    }
}

