/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.jobmanager.bes;

import java.util.Set;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemException;
import org.globus.myproxy.MyProxyException;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.data.filesystem.FileSystemConnector;
import uk.ac.nesc.rapid.data.filesystem.FileSystemTable;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.job.CreationFlag;
import uk.ac.nesc.rapid.job.DataStage;
import uk.ac.nesc.rapid.job.DataStageURL;
import uk.ac.nesc.rapid.job.Job;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.JobManager;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.BESPlugin;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.BESProperties;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.BESState;
import uk.ac.nesc.rapid.persistence.JobPersistence;
import uk.ac.nesc.rapid.value.Value;

public class BESJobManager
extends JobManager {
    private String fileSystemName = null;
    private BESPlugin plugin = null;

    public BESJobManager(Job job, FileSystemTable fileSystemTable, BESProperties properties) {
        super(job, fileSystemTable);
        this.fileSystemName = properties.getFileSystemName();
    }

    public String getFileSystemName() {
        return this.fileSystemName;
    }

    public void setFileSystemName(String fileSystemName) {
        this.fileSystemName = fileSystemName;
    }

    public BESPlugin getBESPlugin() {
        return this.plugin;
    }

    public void setBESPlugin(BESPlugin executionHost) {
        this.plugin = executionHost;
    }

    private void doSourceFileTransfers(AbstractFileSystem destinationFileSystem) throws FileSystemException, MyProxyException, RapidException {
        JobData jobData = this.getJobData();
        Set<String> dataStageSet = this.getJob().getDataStages();
        for (String dataStageName : dataStageSet) {
            DataStage dataStage = this.getJob().getDataStage(dataStageName);
            Value fileNameValue = dataStage.getFileName();
            if (!dataStage.existsSourceURL()) continue;
            DataStageURL dataStageURL = dataStage.getSourceURL();
            Value sourceFileSystemValue = dataStageURL.getFileSystem();
            Value sourcePathValue = dataStageURL.getPath();
            int numberOfFileTransfers = Math.max(sourceFileSystemValue.resolveSize(jobData), sourcePathValue.resolveSize(jobData));
            numberOfFileTransfers = Math.max(numberOfFileTransfers, fileNameValue.resolveSize(jobData));
            for (int fileTransfer = 0; fileTransfer < numberOfFileTransfers; ++fileTransfer) {
                String sourceFileSystemName = dataStageURL.getFileSystem().resolve(jobData, fileTransfer);
                AbstractFileSystem sourceFileSystem = this.getFileSystemTable().getFileSystem(sourceFileSystemName);
                FileObject sourceFileObject = FileSystemConnector.getInstance().connect(sourceFileSystem, jobData, fileTransfer);
                String sourcePath = dataStageURL.getPath().resolve(jobData, fileTransfer);
                sourceFileObject = sourceFileObject.resolveFile(sourcePath);
                FileObject destinationFileObject = FileSystemConnector.getInstance().connect(destinationFileSystem, jobData, fileTransfer);
                Value workingDirValue = this.getJob().getWorkingDir();
                if (workingDirValue.size() != 0) {
                    String workingDir = this.getJob().getWorkingDir().resolve(jobData, fileTransfer);
                    destinationFileObject = destinationFileObject.resolveFile(workingDir);
                }
                if (dataStage.getFileName().size() != 0) {
                    String fileName = dataStage.getFileName().resolve(jobData, fileTransfer);
                    destinationFileObject = destinationFileObject.resolveFile(fileName);
                }
                String creationFlag = dataStage.getCreationFlag().resolve(jobData, fileTransfer);
                if (!destinationFileObject.exists() || CreationFlag.OVERWRITE.toString().equals(creationFlag)) {
                    destinationFileObject.copyFrom(sourceFileObject, (FileSelector)new AllFileSelector());
                }
                destinationFileObject.close();
                sourceFileObject.close();
            }
        }
    }

    private void doTargetFileTransfers(AbstractFileSystem sourceFileSystem) throws FileSystemException, MyProxyException, RapidException {
        JobData jobData = this.getJobData();
        Set<String> dataStageSet = this.getJob().getDataStages();
        for (String dataStageName : dataStageSet) {
            DataStage dataStage = this.getJob().getDataStage(dataStageName);
            Value fileNameValue = dataStage.getFileName();
            if (!dataStage.existsTargetURL()) continue;
            DataStageURL dataStageURL = dataStage.getTargetURL();
            Value targetFileSystemValue = dataStageURL.getFileSystem();
            Value targetPathValue = dataStageURL.getPath();
            int numberOfFileTransfers = Math.max(targetFileSystemValue.resolveSize(jobData), targetPathValue.resolveSize(jobData));
            numberOfFileTransfers = Math.max(numberOfFileTransfers, fileNameValue.resolveSize(jobData));
            for (int fileTransfer = 0; fileTransfer < numberOfFileTransfers; ++fileTransfer) {
                FileObject sourceFileObject = FileSystemConnector.getInstance().connect(sourceFileSystem, jobData, fileTransfer);
                if (this.getJob().getWorkingDir().size() != 0) {
                    String workingDir = this.getJob().getWorkingDir().resolve(jobData, fileTransfer);
                    sourceFileObject = sourceFileObject.resolveFile(workingDir);
                }
                if (dataStage.getFileName().size() != 0) {
                    String fileName = dataStage.getFileName().resolve(jobData, fileTransfer);
                    sourceFileObject = sourceFileObject.resolveFile(fileName);
                }
                String destinationFileSystemName = dataStageURL.getFileSystem().resolve(jobData, fileTransfer);
                AbstractFileSystem destinationFileSystem = this.getFileSystemTable().getFileSystem(destinationFileSystemName);
                FileObject destinationFileObject = FileSystemConnector.getInstance().connect(destinationFileSystem, jobData, fileTransfer);
                String destinationPath = dataStageURL.getPath().resolve(jobData, fileTransfer);
                destinationFileObject = destinationFileObject.resolveFile(destinationPath);
                destinationFileObject.copyFrom(sourceFileObject, (FileSelector)new AllFileSelector());
                destinationFileObject.close();
                sourceFileObject.close();
            }
        }
    }

    private void doCleanUp(AbstractFileSystem fileSystem) throws FileSystemException, MyProxyException, RapidException {
        JobData jobData = this.getJobData();
        Set<String> dataStageSet = this.getJob().getDataStages();
        for (String dataStageName : dataStageSet) {
            DataStage dataStage = this.getJob().getDataStage(dataStageName);
            if (!dataStage.isDeleteOnTermination()) continue;
            int numberOfFiles = dataStage.getFileName().resolveSize(jobData);
            for (int fileIndex = 0; fileIndex < numberOfFiles; ++fileIndex) {
                FileObject fileObject = FileSystemConnector.getInstance().connect(fileSystem);
                if (this.getJob().getWorkingDir().size() != 0) {
                    String workingDir = this.getJob().getWorkingDir().resolve(jobData, fileIndex);
                    fileObject = fileObject.resolveFile(workingDir);
                }
                if (dataStage.getFileName().size() != 0) {
                    String fileName = dataStage.getFileName().resolve(jobData, fileIndex);
                    fileObject = fileObject.resolveFile(fileName);
                }
                if (!fileObject.exists()) continue;
                fileObject.delete((FileSelector)new AllFileSelector());
            }
        }
        if (this.plugin != null) {
            this.plugin.doCleanUp();
        }
    }

    public Value monitor() {
        BESState jobState = (BESState)this.getJobData().getState();
        return jobState.getMessage();
    }

    public void run() {
        this.getBESPlugin().setJobData(this.getJobData());
        if (this.getJobData().getState() == null) {
            this.getJobData().setState(new BESState());
        }
        BESState jobState = (BESState)this.getJobData().getState();
        try {
            AbstractFileSystem fileSystem = this.getFileSystemTable().getFileSystem(this.getFileSystemName());
            while (jobState.getState() < 6) {
                switch (jobState.getState()) {
                    case 0: {
                        jobState.setState(1);
                        break;
                    }
                    case 1: {
                        this.doSourceFileTransfers(fileSystem);
                        jobState.setState(2);
                        break;
                    }
                    case 2: {
                        this.plugin.doSubmit();
                        jobState.setState(3);
                        break;
                    }
                    case 3: {
                        boolean done = false;
                        jobState.setPluginActive(true);
                        while (!done) {
                            try {
                                Thread.sleep(2000L);
                                this.plugin.updateStatus();
                                done = jobState.pluginDone();
                            }
                            catch (InterruptedException ex) {
                                done = true;
                                jobState.setState(7, "Submission thread was interrupted: " + ex.getMessage());
                                jobState.setPluginActive(false);
                                return;
                            }
                        }
                        if (jobState.pluginError()) {
                            jobState.setState(7);
                            break;
                        }
                        jobState.setPluginActive(false);
                        jobState.setState(4);
                        break;
                    }
                    case 4: {
                        this.doTargetFileTransfers(fileSystem);
                        jobState.setState(5);
                        break;
                    }
                    case 5: {
                        this.doCleanUp(fileSystem);
                        jobState.setState(6);
                        break;
                    }
                    default: {
                        jobState.setState(7, "Unknown State");
                    }
                }
                if (!this.getJobData().isDoPersist()) continue;
                JobPersistence.updateJobData(this.getJobData());
            }
        }
        catch (FileSystemException ex) {
            jobState.setState(7, "ERROR in accessing filesystem. Cause: " + ex.getMessage());
        }
        catch (MyProxyException ex) {
            jobState.setState(7, "ERROR obtaining MyProxy credentials. Cause: " + ex.getMessage());
        }
        catch (RapidException ex) {
            jobState.setState(7, "General Error " + ex.getMessage());
        }
    }
}

