/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.apache.xmlbeans.XmlCursor;
import org.icenigrid.schema.jsdl.posix.y2005.m11.ArgumentType;
import org.icenigrid.schema.jsdl.posix.y2005.m11.EnvironmentType;
import org.icenigrid.schema.jsdl.posix.y2005.m11.FileNameType;
import org.icenigrid.schema.jsdl.posix.y2005.m11.POSIXApplicationDocument;
import org.icenigrid.schema.jsdl.posix.y2005.m11.POSIXApplicationType;
import org.icenigrid.schema.jsdl.y2005.m11.ApplicationType;
import org.icenigrid.schema.jsdl.y2005.m11.CreationFlagEnumeration;
import org.icenigrid.schema.jsdl.y2005.m11.DataStagingType;
import org.icenigrid.schema.jsdl.y2005.m11.JobDefinitionDocument;
import org.icenigrid.schema.jsdl.y2005.m11.JobDefinitionType;
import org.icenigrid.schema.jsdl.y2005.m11.JobDescriptionType;
import org.icenigrid.schema.jsdl.y2005.m11.SourceTargetType;
import org.icenigrid.schema.myproxy.MyProxyDocument;
import org.icenigrid.schema.myproxy.MyProxyType;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.data.filesystem.FileSystemTable;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.job.DataStage;
import uk.ac.nesc.rapid.job.DataStageURL;
import uk.ac.nesc.rapid.job.EnvironmentVariable;
import uk.ac.nesc.rapid.job.Job;
import uk.ac.nesc.rapid.value.Value;

public class JSDLGenerator {
    public static JobDefinitionDocument getJSDL(Job job, FileSystemTable fileSystemTable) throws RapidException {
        return JSDLGenerator.getJSDL(job, fileSystemTable, 1);
    }

    public static JobDefinitionDocument getJSDL(Job job, FileSystemTable fileSystemTable, int subJob) throws RapidException {
        JobDefinitionDocument document = JobDefinitionDocument.Factory.newInstance();
        JobDefinitionType jobdefinition = document.addNewJobDefinition();
        JobDescriptionType description = jobdefinition.addNewJobDescription();
        JSDLGenerator.AddFileStaging(description, job, fileSystemTable, subJob);
        ApplicationType application = description.addNewApplication();
        JSDLGenerator.AddPOSIXApplication(application, job, subJob);
        JSDLGenerator.AddMyproxy(jobdefinition, fileSystemTable);
        return document;
    }

    private static void AddPOSIXApplication(ApplicationType application, Job job, int subJob) throws RapidException {
        POSIXApplicationDocument posixdocument = POSIXApplicationDocument.Factory.newInstance();
        POSIXApplicationType posixapplication = posixdocument.addNewPOSIXApplication();
        FileNameType filename = posixapplication.addNewExecutable();
        filename.setStringValue(job.getExecutable().get(subJob));
        for (Value parameter : job.getParameterList()) {
            ArgumentType argument = posixapplication.addNewArgument();
            argument.setStringValue(parameter.get(subJob));
        }
        for (EnvironmentVariable environmentVariable : job.getEnvironmentVariableCollection()) {
            EnvironmentType environment = posixapplication.addNewEnvironment();
            environment.setName(environmentVariable.getName().get(subJob));
            environment.setStringValue(environmentVariable.getValue().get(subJob));
        }
        if (job.getStderr() != null) {
            FileNameType stderr = posixapplication.addNewError();
            stderr.setStringValue(job.getStderr().get(subJob));
        }
        if (job.getStdin() != null) {
            FileNameType stdin = posixapplication.addNewInput();
            stdin.setStringValue(job.getStdin().get(subJob));
        }
        if (job.getStdout() != null) {
            FileNameType stdout = posixapplication.addNewOutput();
            stdout.setStringValue(job.getStdout().get(subJob));
        }
        if (job.getWorkingDir() != null) {
            posixapplication.addNewWorkingDirectory().setStringValue(job.getWorkingDir().get(subJob));
        }
        XmlCursor tocursor = application.newCursor();
        tocursor.toEndToken();
        XmlCursor fromcursor = posixapplication.newCursor();
        fromcursor.toStartDoc();
        fromcursor.moveXmlContents(tocursor);
    }

    private static void AddMyproxy(JobDefinitionType jobdefinition, FileSystemTable fileSystemTable) throws RapidException {
        Iterator<String> fsIterator = fileSystemTable.getFileSystemNames().iterator();
        Object gsiFileSystem = null;
        while (fsIterator.hasNext() && gsiFileSystem == null) {
            AbstractFileSystem fileSystem = fileSystemTable.getFileSystem(fsIterator.next());
        }
        if (gsiFileSystem != null) {
            MyProxyDocument myproxydocument = MyProxyDocument.Factory.newInstance();
            MyProxyType myproxy = myproxydocument.addNewMyProxy();
            XmlCursor tocursor = jobdefinition.newCursor();
            tocursor.toEndToken();
            XmlCursor fromcursor = myproxy.newCursor();
            fromcursor.toStartDoc();
            fromcursor.moveXmlContents(tocursor);
        }
    }

    private static void AddFileStaging(JobDescriptionType description, Job job, FileSystemTable fileSystemTable, int subJob) throws RapidException {
        for (String dataStageName : job.getDataStages()) {
            AbstractFileSystem fs;
            String fsname;
            DataStageURL dsURL;
            DataStage dataStage = job.getDataStage(dataStageName);
            DataStagingType dsType = description.addNewDataStaging();
            if (dataStage.existsSourceURL()) {
                dsURL = dataStage.getSourceURL();
                SourceTargetType source = dsType.addNewSource();
                fsname = dsURL.getFileSystem().get(subJob);
                fs = fileSystemTable.getFileSystem(fsname);
                if (fs != null) {
                    try {
                        URI authURI = new URI(fs.getAuthURL());
                        String path = dsURL.getPath().get(subJob);
                        if (path != null && !path.startsWith("/")) {
                            path = "/~/" + path;
                        }
                        source.setURI(authURI.getScheme() + "://" + authURI.getAuthority() + path);
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (dataStage.existsTargetURL()) {
                dsURL = dataStage.getTargetURL();
                SourceTargetType target = dsType.addNewTarget();
                fsname = dsURL.getFileSystem().get(subJob);
                fs = fileSystemTable.getFileSystem(fsname);
                if (fs != null) {
                    try {
                        String path = dsURL.getPath().get(subJob);
                        if (path != null && !path.startsWith("/")) {
                            path = "/~/" + path;
                        }
                        URI authURI = new URI(fs.getAuthURL());
                        target.setURI(authURI.getScheme() + "://" + authURI.getAuthority() + path);
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            dsType.setDeleteOnTermination(dataStage.isDeleteOnTermination());
            String jobCF = dataStage.getCreationFlag().get(subJob);
            CreationFlagEnumeration.Enum creationFlag = CreationFlagEnumeration.Enum.forString((String)jobCF);
            dsType.setCreationFlag(creationFlag);
            dsType.setFileName(dataStage.getFileName().get(subJob));
        }
    }
}

