/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobdata;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.ElementDependent;
import org.apache.openjpa.util.IntId;
import org.apache.openjpa.util.InternalException;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.job.EnvironmentVariable;
import uk.ac.nesc.rapid.job.Job;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.JobState;
import uk.ac.nesc.rapid.value.Value;
import uk.ac.nesc.rapid.value.impl.JobIDValue;

@Entity
public class JobDataImpl
implements JobData,
PersistenceCapable {
    @Id
    @Basic
    @GeneratedValue
    private int serial = 0;
    @ElementDependent
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private JobIDValue jobID = null;
    @ElementDependent
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private Map<String, Value> variables = new HashMap<String, Value>();
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date date = new Date();
    @Transient
    private int numberOfSubJobs = 0;
    @ElementDependent
    @OneToOne(cascade={CascadeType.ALL})
    private JobState jobState = null;
    @Basic
    private String userName = null;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Luk$ac$nesc$rapid$value$impl$JobIDValue;
    static /* synthetic */ Class class$Luk$ac$nesc$rapid$jobsubmission$jobmanager$JobState;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$util$Map;
    static /* synthetic */ Class class$Luk$ac$nesc$rapid$jobdata$JobDataImpl;
    private transient Object pcDetachedState;

    public JobDataImpl(JobIDValue jobID) {
        this.jobID = jobID;
    }

    public JobDataImpl() {
    }

    public JobDataImpl(JobIDValue jobID, Job job) {
        this.jobID = jobID;
        this.initialise(job);
    }

    public int getSerial() {
        return JobDataImpl.pcGetserial(this);
    }

    public String getUserName() {
        return JobDataImpl.pcGetuserName(this);
    }

    public void setUserName(String userName) {
        JobDataImpl.pcSetuserName(this, userName);
    }

    public boolean isDoPersist() {
        return JobDataImpl.pcGetuserName(this) != null;
    }

    public int getNumberOfSubJobs() throws RapidException {
        if (this.numberOfSubJobs > 0) {
            return this.numberOfSubJobs;
        }
        throw new RapidException("Error getting number of subjobs. Either call finalise() or ensure subjobs>0");
    }

    public Value getVariable(String name) throws RapidException {
        Value value = (Value)JobDataImpl.pcGetvariables(this).get(name);
        if (value == null) {
            throw new RapidException("No Variable with name " + name);
        }
        return value;
    }

    public void setVariable(String name, Value value) {
        JobDataImpl.pcGetvariables(this).put(name, value);
    }

    public void setJobID(JobIDValue value) {
        JobDataImpl.pcSetjobID(this, value);
    }

    public JobIDValue getJobID() {
        return JobDataImpl.pcGetjobID(this);
    }

    public Date getDate() {
        return JobDataImpl.pcGetdate(this);
    }

    public void finalise(Job job) throws RapidException {
        Calendar.getInstance().setTime(JobDataImpl.pcGetdate(this));
        Vector<Value> values = new Vector<Value>();
        values.add(job.getExecutable());
        values.add(job.getStderr());
        values.add(job.getStdout());
        values.add(job.getStdin());
        values.add(job.getSubmissionServer());
        values.add(job.getWorkingDir());
        for (EnvironmentVariable env : job.getEnvironmentVariableCollection()) {
            values.add(env.getName());
            values.add(env.getValue());
        }
        for (Value parameter : job.getParameterList()) {
            values.add(parameter);
        }
        try {
            for (Value value : values) {
                int newMaximum = value.resolveSize(this);
                if (newMaximum <= this.numberOfSubJobs) continue;
                this.numberOfSubJobs = newMaximum;
            }
        }
        catch (RapidException ex) {
            throw new RapidException("Error calculating number of subjobs: " + ex.getMessage());
        }
    }

    public void initialise(Job job) {
        try {
            for (String name : job.getVariables()) {
                this.setVariable(name, job.getVariable(name).copy());
            }
        }
        catch (RapidException rapidException) {
            // empty catch block
        }
    }

    public JobState getState() {
        return JobDataImpl.pcGetjobState(this);
    }

    public void setState(JobState state) {
        JobDataImpl.pcSetjobState(this, state);
        state.setLocalJobID(JobDataImpl.pcGetjobID(this).getJobID());
    }

    public String toString() {
        String result = "\nJob DATA\n";
        result = result + "JOB ID: " + this.getJobID() + "\n";
        result = result + "Date  : " + this.getDate() + "\n";
        result = result + "Variables\n";
        for (String name : JobDataImpl.pcGetvariables(this).keySet()) {
            result = result + "  Name: " + name + "\n";
            result = result + "  Value " + JobDataImpl.pcGetvariables(this).get(name) + "\n";
        }
        result = result + "State: " + JobDataImpl.pcGetjobState(this).toString();
        return result;
    }

    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        pcFieldNames = new String[]{"date", "jobID", "jobState", "serial", "userName", "variables"};
        Class[] classArray = new Class[6];
        Class clazz = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = JobDataImpl.class$("java.util.Date"));
        classArray[0] = clazz;
        Class clazz2 = class$Luk$ac$nesc$rapid$value$impl$JobIDValue != null ? class$Luk$ac$nesc$rapid$value$impl$JobIDValue : (class$Luk$ac$nesc$rapid$value$impl$JobIDValue = JobDataImpl.class$("uk.ac.nesc.rapid.value.impl.JobIDValue"));
        classArray[1] = clazz2;
        Class clazz3 = class$Luk$ac$nesc$rapid$jobsubmission$jobmanager$JobState != null ? class$Luk$ac$nesc$rapid$jobsubmission$jobmanager$JobState : (class$Luk$ac$nesc$rapid$jobsubmission$jobmanager$JobState = JobDataImpl.class$("uk.ac.nesc.rapid.jobsubmission.jobmanager.JobState"));
        classArray[2] = clazz3;
        classArray[3] = Integer.TYPE;
        Class clazz4 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JobDataImpl.class$("java.lang.String"));
        classArray[4] = clazz4;
        Class clazz5 = class$Ljava$util$Map != null ? class$Ljava$util$Map : (class$Ljava$util$Map = JobDataImpl.class$("java.util.Map"));
        classArray[5] = clazz5;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 10, 10, 26, 26, 10};
        Class clazz6 = class$Luk$ac$nesc$rapid$jobdata$JobDataImpl != null ? class$Luk$ac$nesc$rapid$jobdata$JobDataImpl : (class$Luk$ac$nesc$rapid$jobdata$JobDataImpl = JobDataImpl.class$("uk.ac.nesc.rapid.jobdata.JobDataImpl"));
        PCRegistry.register((Class)clazz6, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JobDataImpl", (PersistenceCapable)new JobDataImpl());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.date = null;
        this.jobID = null;
        this.jobState = null;
        this.serial = 0;
        this.userName = null;
        this.variables = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JobDataImpl jobDataImpl = new JobDataImpl();
        if (bl) {
            jobDataImpl.pcClearFields();
        }
        jobDataImpl.pcStateManager = stateManager;
        jobDataImpl.pcCopyKeyFieldsFromObjectId(object);
        return jobDataImpl;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JobDataImpl jobDataImpl = new JobDataImpl();
        if (bl) {
            jobDataImpl.pcClearFields();
        }
        jobDataImpl.pcStateManager = stateManager;
        return jobDataImpl;
    }

    protected static int pcGetManagedFieldCount() {
        return 6;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.date = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.jobID = (JobIDValue)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.jobState = (JobState)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.serial = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.userName = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.variables = (Map)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.date);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.jobID);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.jobState);
                return;
            }
            case 3: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.serial);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.userName);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.variables);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JobDataImpl jobDataImpl, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.date = jobDataImpl.date;
                return;
            }
            case 1: {
                this.jobID = jobDataImpl.jobID;
                return;
            }
            case 2: {
                this.jobState = jobDataImpl.jobState;
                return;
            }
            case 3: {
                this.serial = jobDataImpl.serial;
                return;
            }
            case 4: {
                this.userName = jobDataImpl.userName;
                return;
            }
            case 5: {
                this.variables = jobDataImpl.variables;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        JobDataImpl jobDataImpl = (JobDataImpl)object;
        if (jobDataImpl.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jobDataImpl, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        IntId intId = (IntId)object;
        fieldConsumer.storeIntField(3 + pcInheritedFieldCount, intId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        IntId intId = (IntId)object;
        this.serial = intId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Luk$ac$nesc$rapid$jobdata$JobDataImpl != null ? class$Luk$ac$nesc$rapid$jobdata$JobDataImpl : (class$Luk$ac$nesc$rapid$jobdata$JobDataImpl = JobDataImpl.class$("uk.ac.nesc.rapid.jobdata.JobDataImpl"));
        return new IntId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Luk$ac$nesc$rapid$jobdata$JobDataImpl != null ? class$Luk$ac$nesc$rapid$jobdata$JobDataImpl : (class$Luk$ac$nesc$rapid$jobdata$JobDataImpl = JobDataImpl.class$("uk.ac.nesc.rapid.jobdata.JobDataImpl"));
        return new IntId(clazz, this.serial);
    }

    private static final Date pcGetdate(JobDataImpl jobDataImpl) {
        if (jobDataImpl.pcStateManager == null) {
            return jobDataImpl.date;
        }
        int n = pcInheritedFieldCount + 0;
        jobDataImpl.pcStateManager.accessingField(n);
        return jobDataImpl.date;
    }

    private static final void pcSetdate(JobDataImpl jobDataImpl, Date date) {
        if (jobDataImpl.pcStateManager == null) {
            jobDataImpl.date = date;
            return;
        }
        jobDataImpl.pcStateManager.settingObjectField((PersistenceCapable)jobDataImpl, pcInheritedFieldCount + 0, (Object)jobDataImpl.date, (Object)date, 0);
    }

    private static final JobIDValue pcGetjobID(JobDataImpl jobDataImpl) {
        if (jobDataImpl.pcStateManager == null) {
            return jobDataImpl.jobID;
        }
        int n = pcInheritedFieldCount + 1;
        jobDataImpl.pcStateManager.accessingField(n);
        return jobDataImpl.jobID;
    }

    private static final void pcSetjobID(JobDataImpl jobDataImpl, JobIDValue jobIDValue) {
        if (jobDataImpl.pcStateManager == null) {
            jobDataImpl.jobID = jobIDValue;
            return;
        }
        jobDataImpl.pcStateManager.settingObjectField((PersistenceCapable)jobDataImpl, pcInheritedFieldCount + 1, (Object)jobDataImpl.jobID, (Object)jobIDValue, 0);
    }

    private static final JobState pcGetjobState(JobDataImpl jobDataImpl) {
        if (jobDataImpl.pcStateManager == null) {
            return jobDataImpl.jobState;
        }
        int n = pcInheritedFieldCount + 2;
        jobDataImpl.pcStateManager.accessingField(n);
        return jobDataImpl.jobState;
    }

    private static final void pcSetjobState(JobDataImpl jobDataImpl, JobState jobState) {
        if (jobDataImpl.pcStateManager == null) {
            jobDataImpl.jobState = jobState;
            return;
        }
        jobDataImpl.pcStateManager.settingObjectField((PersistenceCapable)jobDataImpl, pcInheritedFieldCount + 2, (Object)jobDataImpl.jobState, (Object)jobState, 0);
    }

    private static final int pcGetserial(JobDataImpl jobDataImpl) {
        if (jobDataImpl.pcStateManager == null) {
            return jobDataImpl.serial;
        }
        int n = pcInheritedFieldCount + 3;
        jobDataImpl.pcStateManager.accessingField(n);
        return jobDataImpl.serial;
    }

    private static final void pcSetserial(JobDataImpl jobDataImpl, int n) {
        if (jobDataImpl.pcStateManager == null) {
            jobDataImpl.serial = n;
            return;
        }
        jobDataImpl.pcStateManager.settingIntField((PersistenceCapable)jobDataImpl, pcInheritedFieldCount + 3, jobDataImpl.serial, n, 0);
    }

    private static final String pcGetuserName(JobDataImpl jobDataImpl) {
        if (jobDataImpl.pcStateManager == null) {
            return jobDataImpl.userName;
        }
        int n = pcInheritedFieldCount + 4;
        jobDataImpl.pcStateManager.accessingField(n);
        return jobDataImpl.userName;
    }

    private static final void pcSetuserName(JobDataImpl jobDataImpl, String string) {
        if (jobDataImpl.pcStateManager == null) {
            jobDataImpl.userName = string;
            return;
        }
        jobDataImpl.pcStateManager.settingStringField((PersistenceCapable)jobDataImpl, pcInheritedFieldCount + 4, jobDataImpl.userName, string, 0);
    }

    private static final Map pcGetvariables(JobDataImpl jobDataImpl) {
        if (jobDataImpl.pcStateManager == null) {
            return jobDataImpl.variables;
        }
        int n = pcInheritedFieldCount + 5;
        jobDataImpl.pcStateManager.accessingField(n);
        return jobDataImpl.variables;
    }

    private static final void pcSetvariables(JobDataImpl jobDataImpl, Map map) {
        if (jobDataImpl.pcStateManager == null) {
            jobDataImpl.variables = map;
            return;
        }
        jobDataImpl.pcStateManager.settingObjectField((PersistenceCapable)jobDataImpl, pcInheritedFieldCount + 5, jobDataImpl.variables, (Object)map, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.serial != 0) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

