/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.job.impl;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.job.DataStage;
import uk.ac.nesc.rapid.job.EnvironmentVariable;
import uk.ac.nesc.rapid.job.Job;
import uk.ac.nesc.rapid.value.Value;
import uk.ac.nesc.rapid.value.impl.EmptyValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobImpl
implements Job {
    private Value executable = new EmptyValue();
    private Value stdin = new EmptyValue();
    private Value stdout = new EmptyValue();
    private Value stderr = new EmptyValue();
    private Value workingDir = new EmptyValue();
    private Value submissionServer = new EmptyValue();
    private Date jobDate = new Date();
    private Map<String, Value> variableMap = new HashMap<String, Value>();
    private Map<Integer, Value> parameterMap = new HashMap<Integer, Value>();
    private Map<Integer, EnvironmentVariable> environmentMap = new HashMap<Integer, EnvironmentVariable>();
    private Map<String, DataStage> datastageMap = new HashMap<String, DataStage>();
    private Map<String, String> fileUploadMap = new HashMap<String, String>();

    @Override
    public Value getExecutable() {
        return this.executable;
    }

    @Override
    public void setExecutable(Value executable) {
        this.executable = executable;
    }

    @Override
    public Value getStdin() {
        return this.stdin;
    }

    @Override
    public void setStdin(Value stdin) {
        this.stdin = stdin;
    }

    @Override
    public Value getStdout() {
        return this.stdout;
    }

    @Override
    public void setStdout(Value stdout) {
        this.stdout = stdout;
    }

    @Override
    public Value getStderr() {
        return this.stderr;
    }

    @Override
    public void setStderr(Value stderr) {
        this.stderr = stderr;
    }

    @Override
    public Value getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public void setWorkingDir(Value workingdir) {
        this.workingDir = workingdir;
    }

    @Override
    public Value getParameter(int index) {
        Value result = this.parameterMap.get(index);
        if (result == null) {
            return new EmptyValue();
        }
        return result;
    }

    @Override
    public List<Value> getParameterList() {
        Set<Integer> indexSet = this.parameterMap.keySet();
        Vector<Value> parameterList = new Vector<Value>();
        int numberOfKeys = indexSet.size();
        Integer currentIndex = 0;
        while (numberOfKeys != 0) {
            if (indexSet.contains(currentIndex)) {
                parameterList.add(this.parameterMap.get(currentIndex));
                --numberOfKeys;
            } else {
                parameterList.add(new EmptyValue());
            }
            Integer n = currentIndex;
            Integer n2 = currentIndex = Integer.valueOf(currentIndex + 1);
        }
        return parameterList;
    }

    @Override
    public void addParameter(Value parameter) {
        int max = 0;
        Set<Integer> indexSet = this.parameterMap.keySet();
        for (int index : indexSet) {
            if (index <= max) continue;
            max = index;
        }
        this.parameterMap.put(max + 1, parameter);
    }

    @Override
    public void addParameter(int index, Value parameter) {
        if (parameter == null) {
            return;
        }
        this.parameterMap.put(index, parameter);
    }

    @Override
    public EnvironmentVariable getEnvironmentVariable(int index) throws RapidException {
        EnvironmentVariable result = this.environmentMap.get(index);
        if (result == null) {
            throw new RapidException("Index out of range for environment variable. Index: " + index);
        }
        return result;
    }

    @Override
    public Collection<EnvironmentVariable> getEnvironmentVariableCollection() {
        return this.environmentMap.values();
    }

    @Override
    public void addEnvironmentName(int index, Value name) {
        if (name == null) {
            return;
        }
        EnvironmentVariable env = this.environmentMap.get(index);
        if (env == null) {
            env = new EnvironmentVariable();
        }
        env.setName(name);
        this.addEnvironmentVariable(index, env);
    }

    @Override
    public void addEnvironmentValue(int index, Value value) {
        if (value == null) {
            return;
        }
        EnvironmentVariable env = this.environmentMap.get(index);
        if (env == null) {
            env = new EnvironmentVariable();
        }
        env.setValue(value);
        this.addEnvironmentVariable(index, env);
    }

    @Override
    public void addEnvironmentVariable(int index, EnvironmentVariable environment) {
        this.environmentMap.put(index, environment);
    }

    @Override
    public void addDataStage(String name, DataStage datastage) {
        this.datastageMap.put(name, datastage);
    }

    @Override
    public boolean existsDataStage(String name) {
        return null != this.datastageMap.get(name);
    }

    @Override
    public DataStage getDataStage(String name) throws RapidException {
        DataStage result = this.datastageMap.get(name);
        if (result == null) {
            throw new RapidException("No DataStage found with name '" + name + "'");
        }
        return result;
    }

    @Override
    public Set<String> getDataStages() {
        return this.datastageMap.keySet();
    }

    @Override
    public Value getSubmissionServer() {
        return this.submissionServer;
    }

    @Override
    public void setSubmissionServer(Value submissionServer) {
        this.submissionServer = submissionServer;
    }

    @Override
    public Date getDate() {
        return this.jobDate;
    }

    @Override
    public void setDate(Date date) {
        this.jobDate = date;
    }

    @Override
    public void setFileUpload(String name, String fileName) {
        this.fileUploadMap.put(name, fileName);
    }

    @Override
    public String getFileUpload(String name) {
        String result = this.fileUploadMap.get(name);
        if (result == null) {
            result = "";
        }
        return result;
    }

    public String toString() {
        int i;
        String result = "JOB REPOSITORY:\n=====================\n";
        result = result + "EXEC: " + this.executable + "\n";
        result = result + "STDIN: " + this.stdin + "\n";
        result = result + "STDOUT: " + this.stdout + "\n";
        result = result + "STDERR: " + this.stderr + "\n";
        result = result + "WDIR: " + this.workingDir + "\n";
        result = result + "Submision Server " + this.getSubmissionServer() + "\n";
        result = result + "Local variables\n";
        result = result + "Parameters: ";
        if (this.parameterMap != null) {
            for (i = 0; i < this.parameterMap.size(); ++i) {
                result = result + this.parameterMap.get(i) + " : ";
            }
        } else {
            result = result + "Error in Parameter List\n";
        }
        result = result + "\n";
        result = result + "Environment Vars: ";
        for (i = 0; i < this.environmentMap.size(); ++i) {
            result = result + this.environmentMap.get(i);
        }
        result = result + "\n";
        result = result + "DataStage:\n";
        Set<String> keyset = this.datastageMap.keySet();
        for (String key : keyset) {
            DataStage ds = this.datastageMap.get(key);
            result = result + "----------------------------\n";
            result = result + "DataStage: " + key + "\n";
            result = result + ds.toString();
        }
        result = result + "----------------------------\n";
        return result;
    }

    @Override
    public Value getVariable(String name) throws RapidException {
        Value result = this.variableMap.get(name);
        if (result == null) {
            throw new RapidException("No variable with name " + name + " found while getting a variable from a job template");
        }
        return result;
    }

    @Override
    public void setVariable(String name, Value value) {
        this.variableMap.put(name, value);
    }

    @Override
    public Set<String> getVariables() {
        return this.variableMap.keySet();
    }
}

