/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.filesystem.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.data.filesystem.FileSystemTable;
import uk.ac.nesc.rapid.exception.RapidException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemTableImpl
implements FileSystemTable {
    private Map<String, AbstractFileSystem> fileSystemTable = new HashMap<String, AbstractFileSystem>();

    @Override
    public AbstractFileSystem getFileSystem(String name) throws RapidException {
        AbstractFileSystem fileSystem = this.fileSystemTable.get(name);
        if (fileSystem == null) {
            throw new RapidException("No FileSystem named " + name + " in table!");
        }
        return fileSystem;
    }

    @Override
    public void addFileSystem(AbstractFileSystem fileSystem) throws RapidException {
        if (fileSystem.getName() == null) {
            throw new RapidException("Trying to add a FileSystem with <null> name");
        }
        if (this.fileSystemTable.get(fileSystem.getName()) != null) {
            throw new RapidException("Adding duplicate filesystem name: '" + fileSystem.getName() + "'");
        }
        this.fileSystemTable.put(fileSystem.getName(), fileSystem);
    }

    @Override
    public Collection<String> getFileSystemNames() {
        return this.fileSystemTable.keySet();
    }

    @Override
    public int size() {
        return this.fileSystemTable.size();
    }
}

