/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.browser.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.globus.myproxy.MyProxyException;
import uk.ac.nesc.rapid.data.browser.FileBrowser;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.data.filesystem.FileSystemConnector;
import uk.ac.nesc.rapid.data.filesystem.FileSystemTable;
import uk.ac.nesc.rapid.exception.RapidException;
import uk.ac.nesc.rapid.jobdata.JobData;
import uk.ac.nesc.rapid.jobdata.VariableAnalysis;
import uk.ac.nesc.rapid.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBrowserImpl
implements FileBrowser {
    private List<String> directories;
    private List<String> files;
    private FileObject fileObject = null;
    private String errorMessage = null;
    private Map<String, String> previousVariableMap = new HashMap<String, String>();
    private String fileSystemName = "";
    private String currentPath = "";
    private String pathVariableName = "";

    public FileBrowserImpl() {
        this.files = new Vector<String>();
        this.directories = new Vector<String>();
    }

    public void connect(AbstractFileSystem fileSystem, JobData table) throws FileSystemException, MyProxyException, RapidException {
        this.fileObject = FileSystemConnector.getInstance().connect(fileSystem, table, 0);
        this.currentPath = this.fileObject.getName().getPath();
    }

    public void reload() throws FileSystemException {
        this.directories.clear();
        this.files.clear();
        FileObject[] children = this.fileObject.getChildren();
        if (this.fileObject.getParent() != null) {
            this.directories.add("..");
        }
        for (int i = 0; i < children.length; ++i) {
            FileType currentType = children[i].getType();
            if (currentType == FileType.FILE) {
                this.files.add(children[i].getName().getBaseName());
                continue;
            }
            if (currentType != FileType.FOLDER) continue;
            this.directories.add(children[i].getName().getBaseName());
        }
        Collections.sort(this.files);
        Collections.sort(this.directories);
    }

    public String getPath() {
        return this.currentPath;
    }

    public void changeDir(String path) throws FileSystemException, RapidException {
        FileObject newFile = this.fileObject.resolveFile(path);
        if (newFile == null) {
            throw new RapidException("Could not change Directory to " + path);
        }
        this.currentPath = newFile.getName().getPath();
        if (newFile.getType() == FileType.FOLDER) {
            this.fileObject = newFile;
            this.reload();
        }
    }

    @Override
    public void update(FileSystemTable fileSystemTable, JobData jobData) throws MyProxyException, FileSystemException, RapidException {
        try {
            String pathVariable;
            VariableAnalysis analysis = new VariableAnalysis(jobData);
            analysis.setInput(this.getFileSystemName());
            Collection<String> variableCollection = analysis.getVariableNames();
            AbstractFileSystem fileSystem = fileSystemTable.getFileSystem(analysis.getOutput(0));
            variableCollection.addAll(fileSystem.getVariables());
            boolean isChanged = this.fileObject == null;
            isChanged = isChanged || variableCollection.size() != this.previousVariableMap.size();
            Iterator<String> variableIterator = variableCollection.iterator();
            while (variableIterator.hasNext() && !isChanged) {
                String variableName = variableIterator.next();
                String previousVariable = this.previousVariableMap.get(variableName);
                Value currentVariableValue = jobData.getVariable(variableName);
                if (previousVariable == null || currentVariableValue == null) {
                    isChanged = true;
                    continue;
                }
                isChanged = isChanged || !previousVariable.equals(currentVariableValue.get());
            }
            if (isChanged) {
                this.connect(fileSystem, jobData);
                this.reload();
                this.errorMessage = null;
                this.previousVariableMap.clear();
                for (String name : variableCollection) {
                    this.previousVariableMap.put(name, jobData.getVariable(name).get());
                }
            }
            if ((pathVariable = jobData.getVariable(this.getPathVariableName()).get()) == null || !pathVariable.equals(this.getPath())) {
                this.changeDir(pathVariable);
                jobData.getVariable(this.getPathVariableName()).put(this.currentPath);
                this.errorMessage = null;
            }
        }
        catch (MyProxyException ex) {
            this.errorMessage = "Invalid username or password.";
        }
        catch (FileSystemException ex) {
            this.errorMessage = "Invalid username or password.";
        }
        catch (RapidException ex) {
            this.errorMessage = ex.getMessage();
        }
    }

    @Override
    public List<String> getFiles() {
        return this.files;
    }

    @Override
    public List<String> getDirectories() {
        return this.directories;
    }

    @Override
    public void clear() {
        this.previousVariableMap.clear();
        this.directories.clear();
        this.files.clear();
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String toString() {
        String result = "FileBrowser:\n";
        result = result + " FileSystem" + this.getFileSystemName();
        return result;
    }

    @Override
    public String getFileSystemName() {
        return this.fileSystemName;
    }

    @Override
    public void setFileSystemName(String fileSystemName) {
        this.fileSystemName = fileSystemName;
    }

    @Override
    public String getPathVariableName() {
        return this.pathVariableName;
    }

    @Override
    public void setPathVariableName(String pathVariableName) {
        this.pathVariableName = pathVariableName;
    }
}

