/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jsp;

import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.impl.ArrayValue;
import uk.ac.nesc.rapid.data.impl.RangeValue;
import uk.ac.nesc.rapid.data.impl.SingleValue;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.jsp.ValuePrinter;
import uk.ac.nesc.rapid.util.StringUtil;

public class JSPValuePrinter
implements ValuePrinter {
    private String pre = null;
    private String post = null;
    private String[] replace = null;
    private Integer index = null;
    private Job job = null;

    public JSPValuePrinter() {
    }

    public JSPValuePrinter(String pre, String post, String[] replace, Job job) {
        this.pre = pre;
        this.post = post;
        this.replace = replace;
        this.job = job;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String doReplace(String text) {
        int i = 0;
        boolean found = false;
        String result = text;
        if (this.replace != null) {
            while (i + 1 < this.replace.length && !found) {
                if (text.equals(this.replace[i])) {
                    result = this.replace[i + 1];
                    found = true;
                }
                i += 2;
            }
        }
        return result;
    }

    private String printIndex(Value value, int anIndex) {
        String result = "";
        if (this.pre != null) {
            result = result + this.pre;
        }
        String text = value.get(anIndex);
        text = this.doReplace(text);
        try {
            result = result + StringUtil.insertVariables(text, anIndex, this.job);
        }
        catch (RapidException ex) {
            result = result + "ERROR: " + ex.getMessage();
        }
        if (this.post != null) {
            result = result + this.post;
        }
        return result;
    }

    public String print(SingleValue value) {
        return this.printIndex(value, 0);
    }

    public String print(ArrayValue value) {
        if (this.index != null) {
            return this.printIndex(value, this.index);
        }
        String result = "";
        for (int i = 0; i < value.size(); ++i) {
            result = result + this.printIndex(value, i);
        }
        return result;
    }

    public String print(RangeValue value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

