/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.state;

public class BESState {
    private final State state;
    private final String message;

    public BESState() {
        this(State.START);
    }

    public BESState(State state, String message) {
        this.state = state;
        this.message = message;
    }

    public BESState(State state) {
        this.state = state;
        switch (state) {
            case START: {
                this.message = "The job is starting";
                break;
            }
            case SOURCE: {
                this.message = "Copying files into execution host";
                break;
            }
            case TARGET: {
                this.message = "Copying result files out of execution host";
                break;
            }
            case EXECUTE: {
                this.message = "Executing the job";
                break;
            }
            case FINISHED: {
                this.message = "The job has completed successfully";
                break;
            }
            case CLEANUP: {
                this.message = "Cleaning up files";
                break;
            }
            default: {
                this.message = "An error has occurred!";
            }
        }
    }

    public State getState() {
        return this.state;
    }

    public String getMessage() {
        return this.message;
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    public boolean equals(Object state) {
        if (state.getClass() != BESState.class) {
            return false;
        }
        return this.state == ((BESState)state).getState();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        START,
        SOURCE,
        TARGET,
        EXECUTE,
        CLEANUP,
        FINISHED,
        ERROR;

    }
}

