/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.jobmanager.bes;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.globus.myproxy.MyProxyException;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.filesystem.FileSystemConnector;
import uk.ac.nesc.rapid.data.filesystem.security.Authentication;
import uk.ac.nesc.rapid.data.job.EnvironmentVariable;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.BESPlugin;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.SunGridEngineProperties;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.state.BESPluginState;

public class SunGridEnginePlugin
extends BESPlugin {
    private SunGridEngineProperties properties;
    private FileObject submitFileObject = null;

    public SunGridEnginePlugin(SunGridEngineProperties properties) {
        this.properties = properties;
    }

    public String doSubmit(int subJob) throws RapidException {
        try {
            Authentication auth = this.getJob().getAuthentication(this.fileSystem.getName(), null, null);
            this.submitFileObject = FileSystemConnector.getInstance().connect(this.fileSystem, auth);
            Value workingDirValue = this.getJob().getWorkingDir();
            if (workingDirValue != null) {
                this.submitFileObject = this.submitFileObject.resolveFile(this.getJob().getWorkingDir().get(subJob));
            }
            String jobWorkingDir = this.submitFileObject.getName().getPath();
            this.submitFileObject = this.submitFileObject.resolveFile(this.properties.getSubmitFileName() + this.getJob().getJobID().get(subJob));
            this.submitFileObject.createFile();
            FileContent submitFileContent = this.submitFileObject.getContent();
            OutputStream is = submitFileContent.getOutputStream();
            is.write(this.generateSubmitFile(this.getJob(), jobWorkingDir, subJob).getBytes());
            is.close();
            String command = "export SGE_ROOT=" + this.properties.getSGERoot() + "; export ARCH=$($SGE_ROOT/util/arch); ";
            command = command + "$SGE_ROOT/bin/$ARCH/qsub " + this.submitFileObject.getName().getPath();
            String result = this.fileSystem.execute(command);
            return this.getJobID(result);
        }
        catch (IOException ex) {
            throw new RapidException("Error connecting to filesystem " + this.fileSystem.getName() + " : cause " + ex.getMessage());
        }
        catch (MyProxyException ex) {
            throw new RapidException("Unable to get MyProxy credential for filesystem " + this.fileSystem.getName() + " : cause " + ex.getMessage());
        }
    }

    private String getJobID(String SGEOutput) throws RapidException {
        String[] subStrings = SGEOutput.split(" ");
        if (subStrings != null && subStrings.length == 7) {
            try {
                Integer.parseInt(subStrings[2]);
                return subStrings[2];
            }
            catch (NumberFormatException numberFormatException) {
                throw new RapidException("Could not parse SGE job ID: Message was: " + SGEOutput);
            }
        }
        throw new RapidException("Could not parse SGE job ID: Message was: " + SGEOutput);
    }

    public BESPluginState doMonitor(String jobID) throws RapidException {
        String command = "export SGE_ROOT=" + this.properties.getSGERoot() + "; export ARCH=$($SGE_ROOT/util/arch); ";
        String result = this.fileSystem.execute(command = command + "$SGE_ROOT/bin/$ARCH/qstat -xml -j " + jobID);
        if (result == null) {
            return new BESPluginState(BESPluginState.State.ERROR, "ERROR No result retrieved by executing '" + command + "'");
        }
        if (result.contains("<unknown_jobs")) {
            return new BESPluginState(BESPluginState.State.FINISHED);
        }
        if (result.contains("<JB_ja_tasks>")) {
            return new BESPluginState(BESPluginState.State.RUNNING);
        }
        return new BESPluginState(BESPluginState.State.SUSPENDED);
    }

    private String generateSubmitFile(Job job, String workingDir, int subJob) {
        Collection<EnvironmentVariable> envCollection;
        String result = "#!/bin/sh\n";
        result = result + "#This is a submit file generated by the RAPID job submission system\n";
        for (String line : this.properties.getOptions()) {
            result = result + "#$ " + line + "\n";
        }
        if (job.getWorkingDir() != null) {
            result = result + "#$-wd " + workingDir + "\n";
        }
        if ((envCollection = job.getEnvironmentVariableCollection()).size() > 0) {
            result = result + "#$-v ";
            int index = 0;
            for (EnvironmentVariable env : envCollection) {
                result = result + env.getName().get(subJob) + "=" + env.getValue().get(subJob);
                if (++index == envCollection.size()) continue;
                result = result + ",";
            }
            result = result + "\n";
        }
        if (job.getStderr().size() > 0) {
            result = result + "#$-e = " + job.getStderr().get(subJob) + "\n";
        }
        if (job.getStdin().size() > 0) {
            result = result + "#$-i = " + job.getStdin().get(subJob) + "\n";
        }
        if (job.getStdout().size() > 0) {
            result = result + "#$-o = " + job.getStdout().get(subJob) + "\n";
        }
        result = result + job.getExecutable().get(subJob) + " ";
        for (Value arg : job.getParameterList()) {
            result = result + arg.get(subJob) + " ";
        }
        result = result + "\n";
        return result;
    }

    protected void doCleanUp() throws RapidException {
        if (this.submitFileObject != null) {
            try {
                this.submitFileObject.delete();
            }
            catch (FileSystemException ex) {
                throw new RapidException("Error cleaning files in SunGrid Engine plugin! " + ex.getMessage());
            }
        }
    }
}

