/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.jobmanager.bes;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.BESPlugin;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.ForkProperties;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.ForkThread;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.state.BESPluginState;

public class ForkPlugin
extends BESPlugin {
    ForkProperties properties;
    Map<String, ForkThread> threadMap = new HashMap<String, ForkThread>();

    public ForkPlugin(ForkProperties properties) {
        this.properties = properties;
    }

    protected BESPluginState doMonitor(String subJobID) throws RapidException {
        ForkThread forkThread = this.threadMap.get(subJobID);
        if (forkThread != null) {
            return forkThread.getState();
        }
        return new BESPluginState(BESPluginState.State.ERROR, "No subjob exists for FORK with ID " + subJobID);
    }

    public String toString() {
        return "FORK ";
    }

    public String doSubmit(int subJob) {
        ForkThread newThread = new ForkThread(this.getJob(), subJob, this.fileSystem, this.properties);
        String uuid = UUID.randomUUID().toString();
        this.threadMap.put(uuid, newThread);
        new Thread(newThread).start();
        return uuid;
    }

    protected void doCleanUp() throws RapidException {
        Set<String> uuidSet = this.threadMap.keySet();
        for (String uuid : uuidSet) {
            this.threadMap.get(uuid).doCleanUp();
        }
    }
}

