/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.jobmanager.bes;

import java.util.Set;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemException;
import org.globus.myproxy.MyProxyException;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.data.filesystem.FileSystemConnector;
import uk.ac.nesc.rapid.data.filesystem.security.Authentication;
import uk.ac.nesc.rapid.data.impl.SingleValue;
import uk.ac.nesc.rapid.data.job.CreationFlag;
import uk.ac.nesc.rapid.data.job.DataStage;
import uk.ac.nesc.rapid.data.job.DataStageURL;
import uk.ac.nesc.rapid.data.job.StageType;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.JobManager;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.BESPlugin;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.BESProperties;
import uk.ac.nesc.rapid.jobsubmission.jobmanager.bes.state.BESState;

public class BESJobManager
extends JobManager {
    private String fileSystemName = null;
    protected BESState state = new BESState(BESState.State.START);
    protected String errorMessage = null;
    private BESPlugin plugin = null;

    public BESJobManager(BESProperties properties) {
        this.fileSystemName = properties.getFileSystemName();
    }

    private void doSourceFileTransfers(AbstractFileSystem destinationFileSystem) throws FileSystemException, MyProxyException, RapidException {
        Authentication targetAuth = this.getJob().getAuthentication(destinationFileSystem.getName());
        Set<String> dataStageSet = this.getJob().getDataStages();
        for (String dataStageName : dataStageSet) {
            DataStage dataStage = this.getJob().getDataStage(dataStageName);
            Value fileNameValue = dataStage.getFileName();
            if (!dataStage.existsSourceURL()) continue;
            DataStageURL dataStageURL = dataStage.getSourceURL();
            Value sourceFileSystemValue = dataStageURL.getFileSystem();
            Value sourcePathValue = dataStageURL.getPath();
            int numberOfFileTransfers = Math.max(sourceFileSystemValue.size(), sourcePathValue.size());
            numberOfFileTransfers = Math.max(numberOfFileTransfers, fileNameValue.size());
            for (int fileTransfer = 0; fileTransfer < numberOfFileTransfers; ++fileTransfer) {
                AbstractFileSystem sourceFileSystem = this.getFileSystemTable().getFileSystem(dataStageURL.getFileSystem().get(fileTransfer));
                Authentication sourceAuth = this.getJob().getAuthentication(sourceFileSystem.getName(), dataStageName, StageType.SOURCE);
                FileObject sourceFileObject = FileSystemConnector.getInstance().connect(sourceFileSystem, sourceAuth);
                String sourcePath = dataStageURL.getPath().get(fileTransfer);
                sourceFileObject = sourceFileObject.resolveFile(sourcePath);
                FileObject destinationFileObject = FileSystemConnector.getInstance().connect(destinationFileSystem, targetAuth);
                Value workingDirValue = this.getJob().getWorkingDir();
                if (workingDirValue.size() != 0) {
                    String workingDir = this.getJob().getWorkingDir().get(fileTransfer);
                    destinationFileObject = destinationFileObject.resolveFile(workingDir);
                }
                if (dataStage.getFileName().size() != 0) {
                    String fileName = dataStage.getFileName().get(fileTransfer);
                    destinationFileObject = destinationFileObject.resolveFile(fileName);
                }
                String creationFlag = dataStage.getCreationFlag().get(fileTransfer);
                if (!destinationFileObject.exists() || CreationFlag.OVERWRITE.toString().equals(creationFlag)) {
                    destinationFileObject.copyFrom(sourceFileObject, (FileSelector)new AllFileSelector());
                }
                destinationFileObject.close();
                sourceFileObject.close();
            }
        }
    }

    private void doTargetFileTransfers(AbstractFileSystem sourceFileSystem) throws FileSystemException, MyProxyException, RapidException {
        Authentication sourceAuth = this.getJob().getAuthentication(sourceFileSystem.getName());
        Set<String> dataStageSet = this.getJob().getDataStages();
        for (String dataStageName : dataStageSet) {
            DataStage dataStage = this.getJob().getDataStage(dataStageName);
            Value fileNameValue = dataStage.getFileName();
            if (!dataStage.existsTargetURL()) continue;
            DataStageURL dataStageURL = dataStage.getTargetURL();
            Value targetFileSystemValue = dataStageURL.getFileSystem();
            Value targetPathValue = dataStageURL.getPath();
            int numberOfFileTransfers = Math.max(targetFileSystemValue.size(), targetPathValue.size());
            numberOfFileTransfers = Math.max(numberOfFileTransfers, fileNameValue.size());
            for (int fileTransfer = 0; fileTransfer < numberOfFileTransfers; ++fileTransfer) {
                FileObject sourceFileObject = FileSystemConnector.getInstance().connect(sourceFileSystem, sourceAuth);
                if (this.getJob().getWorkingDir().size() != 0) {
                    String workingDir = this.getJob().getWorkingDir().get(fileTransfer);
                    sourceFileObject = sourceFileObject.resolveFile(workingDir);
                }
                if (dataStage.getFileName().size() != 0) {
                    String fileName = dataStage.getFileName().get(fileTransfer);
                    sourceFileObject = sourceFileObject.resolveFile(fileName);
                }
                AbstractFileSystem destinationFileSystem = this.getFileSystemTable().getFileSystem(dataStageURL.getFileSystem().get(fileTransfer));
                Authentication targetAuth = this.getJob().getAuthentication(destinationFileSystem.getName(), dataStageName, StageType.TARGET);
                FileObject destinationFileObject = FileSystemConnector.getInstance().connect(destinationFileSystem, targetAuth);
                String destinationPath = dataStageURL.getPath().get(fileTransfer);
                destinationFileObject = destinationFileObject.resolveFile(destinationPath);
                destinationFileObject.copyFrom(sourceFileObject, (FileSelector)new AllFileSelector());
                destinationFileObject.close();
                sourceFileObject.close();
            }
        }
    }

    private void doCleanUp(AbstractFileSystem fileSystem) throws FileSystemException, MyProxyException, RapidException {
        Set<String> dataStageSet = this.getJob().getDataStages();
        for (String dataStageName : dataStageSet) {
            DataStage dataStage = this.getJob().getDataStage(dataStageName);
            if (!dataStage.isDeleteOnTermination()) continue;
            for (int fileIndex = 0; fileIndex < dataStage.getFileName().size(); ++fileIndex) {
                FileObject fileObject = FileSystemConnector.getInstance().connect(fileSystem);
                if (this.getJob().getWorkingDir().size() != 0) {
                    String workingDir = this.getJob().getWorkingDir().get(fileIndex);
                    fileObject = fileObject.resolveFile(workingDir);
                }
                if (dataStage.getFileName().size() != 0) {
                    String fileName = dataStage.getFileName().get(fileIndex);
                    fileObject = fileObject.resolveFile(fileName);
                }
                fileObject.delete((FileSelector)new AllFileSelector());
            }
        }
        if (this.plugin != null) {
            this.plugin.doCleanUp();
        }
    }

    public Value monitor() {
        if (this.state.getState() == BESState.State.EXECUTE) {
            return this.plugin == null ? new SingleValue("Starting job") : this.plugin.getState();
        }
        return new SingleValue(this.state.getMessage());
    }

    public String getFileSystemName() {
        return this.fileSystemName;
    }

    public void setFileSystemName(String fileSystemName) {
        this.fileSystemName = fileSystemName;
    }

    public BESPlugin getBESPlugin() {
        return this.plugin;
    }

    public void setBESPlugin(BESPlugin executionHost) {
        this.plugin = executionHost;
    }

    public void run() {
        try {
            AbstractFileSystem fileSystem = this.getFileSystemTable().getFileSystem(this.getFileSystemName());
            this.state = new BESState(BESState.State.SOURCE);
            this.doSourceFileTransfers(fileSystem);
            this.state = new BESState(BESState.State.EXECUTE);
            if (this.plugin != null) {
                this.plugin.setJob(this.getJob());
                this.plugin.doSubmit(fileSystem);
                boolean done = false;
                while (!done) {
                    try {
                        Thread.sleep(2000L);
                        this.plugin.doMonitor();
                        done = this.plugin.isCompleted();
                    }
                    catch (InterruptedException ex) {
                        done = true;
                        this.state = new BESState(BESState.State.ERROR, "Submission thread was interrupted: " + ex.getMessage());
                        return;
                    }
                }
                if (this.plugin.isError()) {
                    return;
                }
            }
            this.state = new BESState(BESState.State.TARGET);
            this.doTargetFileTransfers(fileSystem);
            this.state = new BESState(BESState.State.CLEANUP);
            this.doCleanUp(fileSystem);
            this.state = new BESState(BESState.State.FINISHED);
        }
        catch (FileSystemException ex) {
            this.state = new BESState(BESState.State.ERROR, "ERROR in accessing filesystem. Cause: " + ex.getMessage());
        }
        catch (MyProxyException ex) {
            this.state = new BESState(BESState.State.ERROR, "ERROR obtaining MyProxy credentials. Cause: " + ex.getMessage());
        }
        catch (RapidException ex) {
            this.state = new BESState(BESState.State.ERROR, ex.getMessage());
        }
    }
}

