/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.element.impl;

import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.filesystem.security.Authentication;
import uk.ac.nesc.rapid.data.filesystem.security.impl.AuthenticationImpl;
import uk.ac.nesc.rapid.data.filesystem.security.impl.UsernamePasswordAuth;
import uk.ac.nesc.rapid.data.impl.SingleValue;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.data.job.StageType;
import uk.ac.nesc.rapid.element.Element;

public class UsernameElement
extends Element {
    private String fileSystemName = null;
    private StageType dataStageType = null;
    private String dataStageName = null;

    public UsernameElement() {
        this.setReadOnly(false);
    }

    public Value get(Job job) throws RapidException {
        Authentication auth = job.getAuthentication(this.fileSystemName, this.dataStageName, this.dataStageType);
        if (auth == null || UsernamePasswordAuth.getUsername(auth) == null) {
            return new SingleValue("");
        }
        return new SingleValue(UsernamePasswordAuth.getUsername(auth));
    }

    public void put(Job job, Value value) throws RapidException {
        if (this.isReadOnly() || value.get().equals("")) {
            return;
        }
        Authentication auth = job.getAuthentication(this.fileSystemName, this.dataStageName, this.dataStageType);
        if (auth == null) {
            auth = new AuthenticationImpl();
            job.addAuthentication(this.fileSystemName, this.dataStageName, this.dataStageType, auth);
        }
        UsernamePasswordAuth.setUsername(auth, value.get());
    }

    public String getFileSystemName() {
        return this.fileSystemName;
    }

    public void setFileSystemName(String fileSystemName) {
        this.fileSystemName = fileSystemName;
    }

    public String toString() {
        String result = "";
        result = result + "Username\n";
        result = result + super.toString();
        result = result + " fileSystemName: " + this.getFileSystemName() + "\n";
        return result;
    }

    public String getDataStageType() {
        return this.dataStageType.toString();
    }

    public void setDataStageType(String type) {
        this.dataStageType = StageType.parseString(type);
    }

    public String getDataStageName() {
        return this.dataStageName;
    }

    public void setDataStageName(String dataStageName) {
        this.dataStageName = dataStageName;
    }
}

