/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.element.impl;

import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.job.DataStage;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.data.job.StageType;
import uk.ac.nesc.rapid.element.Element;

public class PathElement
extends Element {
    private StageType stageType;
    private String dataStageName = null;

    public String getDataStageName() {
        return this.dataStageName;
    }

    public Value get(Job job) throws RapidException {
        DataStage dataStage = job.getDataStage(this.getDataStageName());
        try {
            return dataStage.getURL(this.stageType).getPath();
        }
        catch (RapidException ex) {
            throw new RapidException("Symbol: " + this.getName() + " Attempt 'get' at data stage '" + this.dataStageName + "' : " + ex.getMessage());
        }
    }

    public void put(Job job, Value value) throws RapidException {
        if (this.isReadOnly()) {
            return;
        }
        DataStage dataStage = job.getDataStage(this.getDataStageName());
        try {
            dataStage.getURL(this.stageType).setPath(value);
        }
        catch (RapidException ex) {
            throw new RapidException("Symbol: " + this.getName() + " At data stage '" + this.dataStageName + "' : " + ex.getMessage());
        }
    }

    public static String getPattern() {
        return "datastage/path";
    }

    public void setStageType(StageType type) {
        this.stageType = type;
    }

    public void setStageType(String type) {
        this.setStageType(StageType.parseString(type));
    }

    public StageType getStageType() {
        return this.stageType;
    }

    public void setDataStageName(String dataStageName) {
        this.dataStageName = dataStageName;
    }

    public String toString() {
        String result = "";
        result = result + "Path\n";
        result = result + super.toString();
        result = result + " DataStage: " + this.getDataStageName() + "\n";
        result = result + " Type: " + (Object)((Object)this.stageType) + "\n";
        return result;
    }
}

