/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.element.impl;

import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.element.Element;

public class FileNameElement
extends Element {
    private String dataStageName = null;

    public String getDataStageName() {
        return this.dataStageName;
    }

    public Value get(Job job) throws RapidException {
        return job.getDataStage(this.getDataStageName()).getFileName();
    }

    public void put(Job job, Value value) throws RapidException {
        if (this.isReadOnly()) {
            return;
        }
        try {
            job.getDataStage(this.getDataStageName()).setFileName(value);
        }
        catch (RapidException ex) {
            throw new RapidException("Ar datastage '" + this.dataStageName + "' : " + ex.getMessage());
        }
    }

    public static String getPattern() {
        return "datastage/filename";
    }

    public void setDataStageName(String dataStageName) {
        this.dataStageName = dataStageName;
    }

    public String toString() {
        String result = "";
        result = result + "FileName\n";
        result = result + super.toString();
        result = result + " DataStage: " + this.getDataStageName() + "\n";
        return result;
    }
}

