/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.element.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.element.Element;
import uk.ac.nesc.rapid.element.ElementTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementTableImpl
implements ElementTable {
    Map<String, Element> elementTable = new HashMap<String, Element>();

    @Override
    public void addElement(Element symbol) throws RapidException {
        if (symbol.getName() != null) {
            if (this.elementTable.get(symbol.getName()) == null) {
                this.elementTable.put(symbol.getName(), symbol);
            } else {
                throw new RapidException("Attempt to add dupicate element: '" + symbol.getName() + "'");
            }
        }
    }

    @Override
    public Element getElement(String name) throws RapidException {
        Element result = this.elementTable.get(name);
        if (result == null) {
            throw new RapidException("Unknown element found with name " + name);
        }
        return result;
    }

    @Override
    public List<Element> getElementsByPage(String page) {
        Vector<Element> result = new Vector<Element>();
        Collection<Element> elementCollection = this.elementTable.values();
        for (Element currentElement : elementCollection) {
            if (!currentElement.getPage().equals(page) || currentElement.isReadOnly()) continue;
            result.add(currentElement);
        }
        return result;
    }

    @Override
    public boolean exists(String name, String page) {
        Element element = this.elementTable.get(name);
        return element != null && element.getPage() != null && element.getPage().equals(page);
    }

    @Override
    public int size() {
        return this.elementTable.size();
    }

    public String toString() {
        String result = "ELEMENT TABLE:\n===================\n";
        Collection<Element> list = this.elementTable.values();
        for (Element elem : list) {
            result = result + elem.toString();
            result = result + "----------------------------\n";
        }
        return result;
    }
}

