/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.impl;

import java.util.List;
import java.util.regex.PatternSyntaxException;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.impl.BaseValue;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.jsp.ValuePrinter;
import uk.ac.nesc.rapid.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleValue
extends BaseValue {
    private String value = null;
    private Double min = null;
    private Double max = null;
    private String regExp = null;

    public SingleValue(String value) {
        this.put(value);
    }

    public SingleValue() {
        this.value = "";
    }

    @Override
    public String get() {
        return this.value;
    }

    @Override
    public String get(int index) {
        return this.value;
    }

    @Override
    public void put(String value) {
        this.value = value == null ? "" : value;
    }

    @Override
    public void put(String[] values) {
        this.value = values == null ? "" : (values.length > 0 ? values[0] : "");
    }

    @Override
    public void put(List<String> values) {
        this.value = values == null ? "" : (values.size() > 0 ? values.get(0) : "");
    }

    @Override
    public int size() {
        return 1;
    }

    public String toString() {
        String result = "";
        result = result + "SingleValue\n";
        result = result + "regexp: " + this.getRegExp() + "\n";
        result = result + "error message: " + this.getErrorMessage() + "\n";
        result = result + "min " + this.getMin() + "\n";
        result = result + "max " + this.getMax() + "\n";
        result = result + "Contents: " + this.get() + "\n";
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SingleValue)) {
            return false;
        }
        SingleValue compare = (SingleValue)obj;
        if (this.get() == compare.get()) {
            return true;
        }
        if (this.get() == null || compare.get() == null) {
            return false;
        }
        return this.get().equals(compare.get());
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + (this.value != null ? this.value.hashCode() : 0);
        return hash;
    }

    @Override
    public String print(ValuePrinter printer) {
        return printer.print(this);
    }

    @Override
    public Value copy() {
        SingleValue copy = new SingleValue(this.value);
        copy.setMax(this.max);
        copy.setMin(this.min);
        copy.setRegExp(this.regExp);
        copy.setErrorMessage(this.getErrorMessage());
        return copy;
    }

    @Override
    public boolean validate() {
        if (this.value == null) {
            return true;
        }
        if (this.getRegExp() != null) {
            try {
                if (!this.value.matches(this.regExp)) {
                    return false;
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return false;
            }
        }
        if (this.getMin() != null || this.getMax() != null) {
            double doubleValue;
            try {
                doubleValue = Double.parseDouble(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            boolean result = true;
            result &= this.getMax() == null ? true : this.getMax() >= doubleValue;
            return result &= this.getMin() == null ? true : this.getMin() <= doubleValue;
        }
        return true;
    }

    public void setMin(Double min) {
        this.min = min;
    }

    public void setMax(Double max) {
        this.max = max;
    }

    public void setRegExp(String regExp) {
        this.regExp = regExp;
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    public String getRegExp() {
        return this.regExp;
    }

    @Override
    public void finalise(Job job) throws RapidException {
        this.value = StringUtil.insertVariables(this.value, 0, job);
    }
}

