/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.impl;

import java.util.List;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.impl.BaseValue;
import uk.ac.nesc.rapid.jsp.ValuePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeValue
extends BaseValue {
    private int min = 0;
    private int max = 0;

    public RangeValue(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public String get() {
        return Integer.toString(this.min);
    }

    @Override
    public String get(int index) {
        return Integer.toString(this.min + index);
    }

    public boolean exists(String value) {
        try {
            int intValue = Integer.parseInt(value);
            return intValue >= this.min && intValue <= this.max;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    @Override
    public void put(String value) {
        try {
            this.max = this.min = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            this.min = 0;
            this.max = 0;
        }
    }

    @Override
    public int size() {
        return this.max - this.min;
    }

    @Override
    public void put(String[] values) {
        if (values.length > 0) {
            this.min = Integer.parseInt(values[0]);
        }
        if (values.length > 1) {
            this.max = Integer.parseInt(values[1]);
        }
    }

    @Override
    public void put(List<String> values) {
        if (values.size() > 0) {
            this.min = Integer.parseInt(values.get(0));
        }
        if (values.size() > 1) {
            this.max = Integer.parseInt(values.get(1));
        }
    }

    @Override
    public String print(ValuePrinter printer) {
        return printer.print(this);
    }

    @Override
    public Value copy() {
        return new RangeValue(this.min, this.max);
    }

    public String toString() {
        String result = "";
        result = result + "RangeValue\n";
        result = result + "min " + this.min + "\n";
        result = result + "max " + this.max + "\n";
        return result;
    }
}

