/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.impl.BaseValue;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.jsp.ValuePrinter;
import uk.ac.nesc.rapid.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayValue
extends BaseValue {
    private List<String> valueList;
    private Double min = null;
    private Double max = null;
    private String regExp = null;

    public ArrayValue() {
        this.valueList = new Vector<String>();
    }

    public ArrayValue(String[] values) {
        this.put(values);
    }

    public ArrayValue(List<String> values) {
        this.valueList = values;
    }

    public boolean exists(String value) {
        return this.valueList.contains(value);
    }

    @Override
    public String get() {
        return this.valueList.size() > 0 ? this.valueList.get(0) : "";
    }

    @Override
    public String get(int index) {
        return this.valueList.size() > index ? this.valueList.get(index) : this.get();
    }

    @Override
    public void put(String value) {
        if (value != null) {
            this.valueList.add(value);
        }
    }

    @Override
    public void put(String[] values) {
        if (values != null) {
            this.valueList = Arrays.asList(values);
        } else {
            this.valueList.clear();
        }
    }

    @Override
    public void put(List<String> values) {
        if (values == null) {
            this.valueList.clear();
        } else {
            this.valueList = values;
        }
    }

    @Override
    public int size() {
        return this.valueList.size();
    }

    @Override
    public String print(ValuePrinter printer) {
        return printer.print(this);
    }

    @Override
    public Value copy() {
        ArrayValue copy = new ArrayValue();
        copy.put(this.valueList);
        copy.setMax(this.max);
        copy.setMin(this.min);
        copy.setRegExp(this.regExp);
        copy.setErrorMessage(this.getErrorMessage());
        return copy;
    }

    @Override
    public boolean validate() {
        for (String value : this.valueList) {
            Double doubleValue;
            if (value == null) {
                return true;
            }
            if (this.getRegExp() != null) {
                try {
                    if (!value.matches(this.regExp)) {
                        return false;
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
            }
            if (this.getMin() == null && this.getMax() == null) continue;
            try {
                doubleValue = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            boolean result = true;
            result &= this.getMax() == null ? true : this.getMax() >= doubleValue;
            if (result &= this.getMin() == null ? true : this.getMin() <= doubleValue) continue;
            return result;
        }
        return true;
    }

    public void setMin(Double min) {
        this.min = min;
    }

    public void setMax(Double max) {
        this.max = max;
    }

    public void setRegExp(String regExp) {
        this.regExp = regExp;
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    public String getRegExp() {
        return this.regExp;
    }

    @Override
    public void finalise(Job job) throws RapidException {
        Vector<String> newValueList = new Vector<String>();
        for (int subJob = 0; subJob < job.getNumberOfSubJobs(); ++subJob) {
            newValueList.add(StringUtil.insertVariables(this.get(subJob), subJob, job));
        }
        this.valueList = newValueList;
    }

    public String toString() {
        String result = "";
        result = result + "ArrayValue\n";
        result = result + "regexp: " + this.getRegExp() + "\n";
        result = result + "min " + this.getMin() + "\n";
        result = result + "max " + this.getMax() + "\n";
        result = result + "Contents: \n";
        for (String s : this.valueList) {
            result = result + s + "\n";
        }
        return result;
    }
}

