/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.filesystem.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;

public class LocalFileSystem
extends AbstractFileSystem {
    public String toString() {
        String result = "";
        result = result + "Local SERVER\n";
        result = result + "description " + this.getName() + "\n";
        result = result + "URL: " + this.getURL() + "\n";
        return result;
    }

    public String execute(String command) throws RapidException {
        InputStream stderr = null;
        InputStream stdout = null;
        try {
            URL fileURL = new URL(this.getURL());
            Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command}, null, new File(fileURL.getPath()));
            stderr = process.getErrorStream();
            stdout = process.getInputStream();
            byte[] buf = new byte[100];
            String output = "";
            int n = 0;
            while ((n = stdout.read(buf)) != -1) {
                output = output + new String(buf, 0, n);
            }
            if (process.waitFor() != 0) {
                String error = "";
                n = 0;
                while ((n = stderr.read(buf)) != -1) {
                    error = error + new String(buf, 0, n);
                }
                throw new RapidException("fail. Command failed to execute: " + error);
            }
            String string = output;
            return string;
        }
        catch (InterruptedException ex) {
            throw new RapidException("fail: Process interrupted: " + ex.getMessage());
        }
        catch (IOException ex) {
            throw new RapidException("fail: IO Error: " + ex.getMessage());
        }
        finally {
            if (stderr != null) {
                try {
                    stderr.close();
                }
                catch (IOException ex) {
                    throw new RapidException("Could not close stderr!");
                }
            }
        }
    }
}

