/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.filesystem.impl;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Hashtable;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticator;
import org.apache.commons.vfs.auth.StaticUserAuthenticator;
import org.apache.commons.vfs.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs.provider.sftp.SftpFileSystemConfigBuilder;
import org.globus.myproxy.MyProxyException;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.data.filesystem.security.Authentication;
import uk.ac.nesc.rapid.data.filesystem.security.impl.UsernamePasswordAuth;

public class FTPFileSystem
extends AbstractFileSystem {
    public String getAuthURL() throws RapidException {
        return this.getAuthURL(this.getAuthentication());
    }

    public String getAuthURL(Authentication auth) throws RapidException {
        int index = this.getURL().indexOf("://") + 3;
        String result = this.getURL().substring(0, index);
        result = result + UsernamePasswordAuth.getUsername(auth) + ":" + UsernamePasswordAuth.getPassword(auth) + "@";
        result = result + this.getURL().substring(index);
        return result;
    }

    public void addVFSOptions(FileSystemOptions opts) throws FileSystemException, MyProxyException, RapidException {
        this.addVFSOptions(opts, this.getAuthentication());
    }

    public void addVFSOptions(FileSystemOptions opts, Authentication auth) throws FileSystemException, MyProxyException, RapidException {
        if (UsernamePasswordAuth.getUsername(auth) != null || UsernamePasswordAuth.getPassword(auth) != null) {
            StaticUserAuthenticator staticAuthenticator = new StaticUserAuthenticator(null, UsernamePasswordAuth.getUsername(auth), UsernamePasswordAuth.getPassword(auth));
            DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(opts, (UserAuthenticator)staticAuthenticator);
            SftpFileSystemConfigBuilder.getInstance().setStrictHostKeyChecking(opts, "no");
            SftpFileSystemConfigBuilder.getInstance().setTimeout(opts, Integer.valueOf(3000));
            FtpFileSystemConfigBuilder.getInstance().setDataTimeout(opts, Integer.valueOf(3000));
        }
    }

    private static String readInputStream(InputStream in, Channel channel) throws IOException {
        boolean done = false;
        String result = "";
        byte[] tmp = new byte[1024];
        while (!done) {
            int i;
            while (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                result = result + new String(tmp, 0, i);
            }
            if (channel.isClosed()) {
                done = true;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ee) {}
        }
        return result;
    }

    public String execute(String command) throws RapidException {
        return this.execute(this.getAuthentication(), command);
    }

    public String execute(Authentication auth, String command) throws RapidException {
        InputStream in = null;
        InputStream err = null;
        try {
            JSch jsch = new JSch();
            String hostname = new URI(this.getURL()).getHost();
            Session session = jsch.getSession(UsernamePasswordAuth.getUsername(auth), hostname, 22);
            session.setPassword(UsernamePasswordAuth.getPassword(auth));
            Hashtable<String, String> config = new Hashtable<String, String>();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            session.connect();
            ChannelExec channel = (ChannelExec)session.openChannel("exec");
            channel.setCommand("" + command + "");
            in = channel.getInputStream();
            if (in == null) {
                throw new RapidException("Could not get input stream. Maybe hostname " + hostname + " does not exist");
            }
            err = channel.getExtInputStream();
            channel.connect();
            String result = FTPFileSystem.readInputStream(in, (Channel)channel);
            if (channel.getExitStatus() != 0) {
                String error = FTPFileSystem.readInputStream(err, (Channel)channel);
                channel.disconnect();
                session.disconnect();
                throw new RapidException("Executing command " + command + " on host " + this.getURL() + " failed.\nExit code " + channel.getExitStatus() + ". \nError: '" + error + "'");
            }
            channel.disconnect();
            session.disconnect();
            String string = result;
            return string;
        }
        catch (IOException ex) {
            throw new RapidException("IO Error while executing command " + command + " on host " + this.getURL() + ". Cause: " + ex.getMessage());
        }
        catch (JSchException ex) {
            throw new RapidException("SSH Error while executing command " + command + " on host " + this.getURL() + ". Cause: " + ex.getMessage());
        }
        catch (Exception ex) {
            throw new RapidException("Other error " + ex.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {}
        }
    }

    public void setUsername(String username) {
        UsernamePasswordAuth.setUsername(this.getAuthentication(), username);
    }

    public void setPassword(String password) {
        UsernamePasswordAuth.setPassword(this.getAuthentication(), password);
    }

    public String getUsername() throws RapidException {
        return UsernamePasswordAuth.getUsername(this.getAuthentication());
    }

    public String getPassword() throws RapidException {
        return UsernamePasswordAuth.getPassword(this.getAuthentication());
    }

    public String toString() {
        String result = "";
        result = result + "FTP SERVER\n";
        result = result + "description " + this.getName() + "\n";
        result = result + "URL: " + this.getURL() + "\n";
        try {
            result = result + "username: " + UsernamePasswordAuth.getUsername(this.getAuthentication()) + "\n";
            result = result + "password: " + UsernamePasswordAuth.getPassword(this.getAuthentication()) + "\n";
        }
        catch (RapidException ex) {
            result = result + "Error obtaining authentication: " + ex.getMessage();
        }
        return result;
    }
}

