/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.browser.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.browser.FileBrowser;
import uk.ac.nesc.rapid.data.browser.FileBrowserTable;
import uk.ac.nesc.rapid.data.browser.impl.FileBrowserKey;
import uk.ac.nesc.rapid.data.filesystem.FileSystemTable;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.data.job.StageType;

public class FileBrowserTableImpl
implements FileBrowserTable {
    Map<FileBrowserKey, FileBrowser> fileBrowserTable = new HashMap<FileBrowserKey, FileBrowser>();

    public FileBrowser getFileBrowser(String dataStageName, StageType stageType) throws RapidException {
        FileBrowser result = this.fileBrowserTable.get(new FileBrowserKey(dataStageName, stageType));
        if (result == null) {
            throw new RapidException("No File Browser for Data stage name '" + dataStageName + "' and type '" + stageType.toString() + "'");
        }
        return result;
    }

    public void addFileBrowser(FileBrowser browser) throws RapidException {
        FileBrowserKey key = new FileBrowserKey(browser.getDataStageName(), browser.getDataStageType());
        FileBrowser fileBrowser = this.fileBrowserTable.get(key);
        if (fileBrowser != null) {
            throw new RapidException("Duplicate FileBrowser for: " + fileBrowser.getDataStageName() + " ; " + fileBrowser.getDataStageType().toString());
        }
        this.fileBrowserTable.put(key, browser);
    }

    public int size() {
        return this.fileBrowserTable.size();
    }

    public void update(Job job, FileSystemTable fileSystemTable) {
        Set<FileBrowserKey> keyCollection = this.fileBrowserTable.keySet();
        for (FileBrowserKey key : keyCollection) {
            try {
                this.fileBrowserTable.get(key).update(job, fileSystemTable);
            }
            catch (Exception ex) {
                this.fileBrowserTable.get(key).clear();
            }
        }
    }
}

