/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.browser.impl;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.globus.myproxy.MyProxyException;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.Value;
import uk.ac.nesc.rapid.data.browser.FileBrowser;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.data.filesystem.FileSystemConnector;
import uk.ac.nesc.rapid.data.filesystem.FileSystemTable;
import uk.ac.nesc.rapid.data.filesystem.security.Authentication;
import uk.ac.nesc.rapid.data.job.DataStage;
import uk.ac.nesc.rapid.data.job.DataStageURL;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.data.job.StageType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBrowserImpl
implements FileBrowser {
    private List<String> directories;
    private List<String> files;
    private FileObject fileObject = null;
    private String dataStageName = null;
    private StageType dataStageType = StageType.SOURCE;
    private String currentPath = null;
    private String currentFileSystem = null;
    private Authentication currentAuthentication = null;
    private String errorMessage = null;

    public FileBrowserImpl() {
        this.files = new Vector<String>();
        this.directories = new Vector<String>();
    }

    public void connect(AbstractFileSystem fileSystem, Authentication auth) throws FileSystemException, MyProxyException, RapidException {
        this.fileObject = FileSystemConnector.getInstance().connect(fileSystem, auth);
        this.currentPath = this.fileObject.getName().getPath();
    }

    public void reload() throws FileSystemException {
        this.clear();
        FileObject[] children = this.fileObject.getChildren();
        if (this.fileObject.getParent() != null) {
            this.directories.add("..");
        }
        for (int i = 0; i < children.length; ++i) {
            FileType currentType = children[i].getType();
            if (currentType == FileType.FILE) {
                this.files.add(children[i].getName().getBaseName());
                continue;
            }
            if (currentType != FileType.FOLDER) continue;
            this.directories.add(children[i].getName().getBaseName());
        }
        Collections.sort(this.files);
        Collections.sort(this.directories);
    }

    public String getPath() {
        return this.currentPath;
    }

    public void changeDir(String path) throws FileSystemException, RapidException {
        FileObject newFile = this.fileObject.resolveFile(path);
        if (newFile == null) {
            throw new RapidException("Could not change Directory to " + path);
        }
        this.currentPath = newFile.getName().getPath();
        if (newFile.getType() == FileType.FOLDER) {
            this.fileObject = newFile;
            this.reload();
        }
    }

    @Override
    public void update(Job job, FileSystemTable fileSystemTable) throws MyProxyException, FileSystemException, RapidException {
        try {
            Authentication fsAuthentication;
            DataStage dataStage = job.getDataStage(this.getDataStageName());
            DataStageURL dataStageURL = dataStage.getURL(this.getDataStageType());
            boolean isChanged = false;
            if (!dataStageURL.getFileSystem().get().equals(this.currentFileSystem)) {
                this.currentFileSystem = dataStageURL.getFileSystem().get();
                isChanged = true;
            }
            if ((fsAuthentication = job.getAuthentication(this.currentFileSystem, this.getDataStageName(), this.getDataStageType())) != null && !fsAuthentication.equals(this.currentAuthentication)) {
                this.currentAuthentication = fsAuthentication.clone();
                isChanged = true;
            } else if (fsAuthentication == null && this.currentAuthentication != null) {
                isChanged = true;
            }
            if (isChanged) {
                AbstractFileSystem fileSystem = fileSystemTable.getFileSystem(dataStageURL.getFileSystem().get());
                this.connect(fileSystem, fsAuthentication);
                Value value = dataStageURL.getPath();
                value.put(this.getPath());
                this.reload();
                this.errorMessage = null;
            } else if (!dataStageURL.getPath().get().equals(this.getPath())) {
                this.changeDir(dataStageURL.getPath().get());
                Value value = dataStageURL.getPath();
                value.put(this.getPath());
                this.errorMessage = null;
            }
        }
        catch (MyProxyException ex) {
            this.errorMessage = "Invalid username or password.";
        }
        catch (FileSystemException ex) {
            this.errorMessage = "Invalid username or password.";
        }
        catch (RapidException ex) {
            this.errorMessage = ex.getMessage();
        }
    }

    @Override
    public List<String> getFiles() {
        return this.files;
    }

    @Override
    public List<String> getDirectories() {
        return this.directories;
    }

    @Override
    public String getDataStageName() {
        return this.dataStageName;
    }

    @Override
    public void setDataStageName(String dataStage) {
        this.dataStageName = dataStage;
    }

    @Override
    public void setDataStageType(String type) {
        this.dataStageType = StageType.parseString(type);
    }

    @Override
    public void setDataStageType(StageType type) {
        this.dataStageType = type;
    }

    @Override
    public StageType getDataStageType() {
        return this.dataStageType;
    }

    public String toString() {
        String result = "FileBrowser:\n";
        result = result + " DataStage: " + this.getDataStageName() + "\n";
        result = result + " Type: " + this.getDataStageType().toString() + "\n";
        return result;
    }

    @Override
    public void clear() {
        this.directories.clear();
        this.files.clear();
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

