<!-- RAPID 
     National e-Science centre
     Edinburgh
     
     Author Jos Koetsier
     
     This stylesheet adds unique symbols to a Rapid XML document. 
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:xhtml="http://www.w3.org/2002/06/xhtml2" 
                xmlns:rapid="http://www.nesc.ac.uk/rapid" version="1.0"
                xmlns="http://www.nesc.ac.uk/rapid"  exclude-result-prefixes="#default">
	<xsl:output indent="yes" method="xml"/>
        
        <xsl:template match="rapid:*">
		<xsl:element name="{local-name(.)}" namespace="http://www.nesc.ac.uk/rapid">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>        
        
	<xsl:template match="xhtml:*">
		<xsl:element name="{local-name(.)}" namespace="http://www.w3.org/2002/06/xhtml2">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
        
	<xsl:template match="@*">
		<xsl:attribute name="{local-name(.)}">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>
	<xsl:template match="rapid:posix/rapid:executable|
                             rapid:posix/rapid:stderr|
                             rapid:posix/rapid:stdin|
                             rapid:posix/rapid:stdout|
                             rapid:posix/rapid:parameter|
                             rapid:posix/rapid:workingdir|
                             rapid:posix/rapid:environmentvalue|            
                             rapid:posix/rapid:environmentname|            
                             rapid:datastage/rapid:path|
                             rapid:datastage/rapid:filesystem|
                             rapid:datastage/rapid:deleteontermination|
                             rapid:datastage/rapid:filename|
                             rapid:datastage/rapid:creationflag|
                             rapid:submitto">             
		<xsl:element name="{local-name(.)}" namespace="http://www.nesc.ac.uk/rapid">
			<xsl:attribute name="symbol"><xsl:copy-of select="generate-id()"/></xsl:attribute>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
