/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.xml;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import uk.ac.nesc.rapid.data.job.DataStage;
import uk.ac.nesc.rapid.data.job.DataStageURL;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.data.job.StageType;
import uk.ac.nesc.rapid.data.job.impl.DataStageImpl;
import uk.ac.nesc.rapid.data.job.impl.DataStageURLImpl;
import uk.ac.nesc.rapid.data.job.impl.JobImpl;
import uk.ac.nesc.rapid.element.impl.CreationFlagElement;
import uk.ac.nesc.rapid.element.impl.DeleteOnTerminationElement;
import uk.ac.nesc.rapid.element.impl.EnvironmentNameElement;
import uk.ac.nesc.rapid.element.impl.EnvironmentValueElement;
import uk.ac.nesc.rapid.element.impl.ExecutableElement;
import uk.ac.nesc.rapid.element.impl.FileNameElement;
import uk.ac.nesc.rapid.element.impl.FileSystemElement;
import uk.ac.nesc.rapid.element.impl.ParameterElement;
import uk.ac.nesc.rapid.element.impl.PathElement;
import uk.ac.nesc.rapid.element.impl.StderrElement;
import uk.ac.nesc.rapid.element.impl.StdinElement;
import uk.ac.nesc.rapid.element.impl.StdoutElement;
import uk.ac.nesc.rapid.element.impl.SubmitToElement;
import uk.ac.nesc.rapid.element.impl.WorkingDirElement;

public class JobReader {
    public static Job read(URL xmlFile) throws IOException, SAXException {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setNamespaceAware(true);
        JobImpl job = new JobImpl();
        digester.push((Object)job);
        digester.addFactoryCreate(FileSystemElement.getPattern(), (ObjectCreationFactory)new DataStageURLFactory(job));
        digester.addCallMethod(FileSystemElement.getPattern() + "/default", "setFileSystem", 1);
        digester.addCallParam(FileSystemElement.getPattern() + "/default", 0, "value");
        digester.addFactoryCreate(PathElement.getPattern(), (ObjectCreationFactory)new DataStageURLFactory(job));
        digester.addCallMethod(PathElement.getPattern() + "/default", "setPath", 1);
        digester.addCallParam(PathElement.getPattern() + "/default", 0, "value");
        digester.addFactoryCreate(FileNameElement.getPattern(), (ObjectCreationFactory)new DataStageFactory(job));
        digester.addCallMethod(FileNameElement.getPattern() + "/default", "setFileName", 1);
        digester.addCallParam(FileNameElement.getPattern() + "/default", 0, "value");
        digester.addFactoryCreate(DeleteOnTerminationElement.getPattern(), (ObjectCreationFactory)new DataStageFactory(job));
        digester.addCallMethod(DeleteOnTerminationElement.getPattern() + "/default", "setDeleteOnTermination", 1);
        digester.addCallParam(DeleteOnTerminationElement.getPattern() + "/default", 0, "value");
        digester.addFactoryCreate(CreationFlagElement.getPattern(), (ObjectCreationFactory)new DataStageFactory(job));
        digester.addCallMethod(CreationFlagElement.getPattern() + "/default", "setCreationFlag", 1);
        digester.addCallParam(CreationFlagElement.getPattern() + "/default", 0, "value");
        digester.addCallMethod(SubmitToElement.getPattern() + "/default", "setSubmissionServer", 1);
        digester.addCallParam(SubmitToElement.getPattern() + "/default", 0, "value");
        digester.addCallMethod(ExecutableElement.getPattern() + "/default", "setExecutable", 1);
        digester.addCallParam(ExecutableElement.getPattern() + "/default", 0, "value");
        digester.addCallMethod(StdinElement.getPattern() + "/default", "setStdin", 1);
        digester.addCallParam(StdinElement.getPattern() + "/default", 0, "value");
        digester.addCallMethod(StdoutElement.getPattern() + "/default", "setStdout", 1);
        digester.addCallParam(StdoutElement.getPattern() + "/default", 0, "value");
        digester.addCallMethod(StderrElement.getPattern() + "/default", "setStderr", 1);
        digester.addCallParam(StderrElement.getPattern() + "/default", 0, "value");
        digester.addCallMethod(WorkingDirElement.getPattern() + "/default", "setWorkingDir", 1);
        digester.addCallParam(WorkingDirElement.getPattern() + "/default", 0, "value");
        digester.addCallMethod(ParameterElement.getPattern(), "addParameter", 2, new String[]{"java.lang.Integer", "java.lang.String"});
        digester.addCallParam(ParameterElement.getPattern() + "/default", 1, "value");
        digester.addCallParam(ParameterElement.getPattern(), 0, "index");
        digester.addCallMethod(EnvironmentNameElement.getPattern(), "addEnvironmentName", 2, new String[]{"java.lang.Integer", "java.lang.String"});
        digester.addCallParam(EnvironmentNameElement.getPattern() + "/default", 1, "value");
        digester.addCallParam(EnvironmentNameElement.getPattern(), 0, "index");
        digester.addCallMethod(EnvironmentValueElement.getPattern(), "addEnvironmentValue", 2, new String[]{"java.lang.Integer", "java.lang.String"});
        digester.addCallParam(EnvironmentValueElement.getPattern() + "/default", 1, "value");
        digester.addCallParam(EnvironmentValueElement.getPattern(), 0, "index");
        digester.parse(xmlFile);
        return job;
    }

    public static class DataStageURLFactory
    implements ObjectCreationFactory {
        Job job;

        public DataStageURLFactory(Job job) {
            this.job = job;
        }

        public Object createObject(Attributes attributes) {
            DataStageURL dataStageURL;
            String dataStageName = attributes.getValue("datastage");
            String type = attributes.getValue("type");
            DataStage dataStage = this.job.getDataStage(dataStageName);
            if (dataStage == null) {
                dataStage = new DataStageImpl();
                this.job.addDataStage(dataStageName, dataStage);
            }
            if ((dataStageURL = dataStage.getURL(StageType.parseString(type))) == null) {
                dataStageURL = new DataStageURLImpl();
                dataStage.setURL(dataStageURL, StageType.parseString(type));
            }
            return dataStageURL;
        }

        public Digester getDigester() {
            return null;
        }

        public void setDigester(Digester digester) {
        }
    }

    public static class DataStageFactory
    implements ObjectCreationFactory {
        Job job;

        public DataStageFactory(Job job) {
            this.job = job;
        }

        public Object createObject(Attributes attributes) {
            String dataStageName = attributes.getValue("datastage");
            DataStage dataStage = this.job.getDataStage(dataStageName);
            if (dataStage == null) {
                dataStage = new DataStageImpl();
                this.job.addDataStage(dataStageName, dataStage);
            }
            return dataStage;
        }

        public Digester getDigester() {
            return null;
        }

        public void setDigester(Digester digester) {
        }
    }
}

