/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.apache.xmlbeans.XmlCursor;
import org.icenigrid.schema.jsdl.posix.y2005.m11.ArgumentType;
import org.icenigrid.schema.jsdl.posix.y2005.m11.EnvironmentType;
import org.icenigrid.schema.jsdl.posix.y2005.m11.FileNameType;
import org.icenigrid.schema.jsdl.posix.y2005.m11.POSIXApplicationDocument;
import org.icenigrid.schema.jsdl.posix.y2005.m11.POSIXApplicationType;
import org.icenigrid.schema.jsdl.y2005.m11.ApplicationType;
import org.icenigrid.schema.jsdl.y2005.m11.CreationFlagEnumeration;
import org.icenigrid.schema.jsdl.y2005.m11.DataStagingType;
import org.icenigrid.schema.jsdl.y2005.m11.JobDefinitionDocument;
import org.icenigrid.schema.jsdl.y2005.m11.JobDefinitionType;
import org.icenigrid.schema.jsdl.y2005.m11.JobDescriptionType;
import org.icenigrid.schema.jsdl.y2005.m11.SourceTargetType;
import org.icenigrid.schema.myproxy.MyProxyDocument;
import org.icenigrid.schema.myproxy.MyProxyType;
import uk.ac.nesc.rapid.data.RapidException;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.data.filesystem.FileSystemTable;
import uk.ac.nesc.rapid.data.filesystem.impl.GSIFTPFileSystem;
import uk.ac.nesc.rapid.data.job.CreationFlag;
import uk.ac.nesc.rapid.data.job.DataStage;
import uk.ac.nesc.rapid.data.job.DataStageURL;
import uk.ac.nesc.rapid.data.job.EnvironmentVariable;
import uk.ac.nesc.rapid.data.job.Job;

public class JSDLGenerator {
    public static JobDefinitionDocument getJSDL(Job job, FileSystemTable fileSystemTable) throws RapidException {
        JobDefinitionDocument document = JobDefinitionDocument.Factory.newInstance();
        JobDefinitionType jobdefinition = document.addNewJobDefinition();
        JobDescriptionType description = jobdefinition.addNewJobDescription();
        JSDLGenerator.AddFileStaging(description, job, fileSystemTable);
        ApplicationType application = description.addNewApplication();
        JSDLGenerator.AddPOSIXApplication(application, job, fileSystemTable);
        JSDLGenerator.AddMyproxy(jobdefinition, job, fileSystemTable);
        return document;
    }

    private static void AddPOSIXApplication(ApplicationType application, Job job, FileSystemTable fileSystemTable) throws RapidException {
        POSIXApplicationDocument posixdocument = POSIXApplicationDocument.Factory.newInstance();
        POSIXApplicationType posixapplication = posixdocument.addNewPOSIXApplication();
        FileNameType filename = posixapplication.addNewExecutable();
        filename.setStringValue(job.getExecutable());
        for (String parameter : job.getParameterList()) {
            ArgumentType argument = posixapplication.addNewArgument();
            argument.setStringValue(parameter);
        }
        for (EnvironmentVariable environmentVariable : job.getEnvironmentVariableCollection()) {
            EnvironmentType environment = posixapplication.addNewEnvironment();
            environment.setName(environmentVariable.getName());
            environment.setStringValue(environmentVariable.getValue());
        }
        if (job.getStderr() != null) {
            FileNameType stderr = posixapplication.addNewError();
            stderr.setStringValue(job.getStderr());
        }
        if (job.getStdin() != null) {
            FileNameType stdin = posixapplication.addNewInput();
            stdin.setStringValue(job.getStdin());
        }
        if (job.getStdout() != null) {
            FileNameType stdout = posixapplication.addNewOutput();
            stdout.setStringValue(job.getStdout());
        }
        if (job.getWorkingDir() != null) {
            posixapplication.addNewWorkingDirectory().setStringValue(job.getWorkingDir());
        }
        XmlCursor tocursor = application.newCursor();
        tocursor.toEndToken();
        XmlCursor fromcursor = posixapplication.newCursor();
        fromcursor.toStartDoc();
        fromcursor.moveXmlContents(tocursor);
    }

    private static void AddMyproxy(JobDefinitionType jobdefinition, Job job, FileSystemTable fileSystemTable) throws RapidException {
        Iterator<String> fsIterator = fileSystemTable.getFileSystemNames().iterator();
        GSIFTPFileSystem gsiFileSystem = null;
        while (fsIterator.hasNext() && gsiFileSystem == null) {
            AbstractFileSystem fileSystem = fileSystemTable.getFileSystem(fsIterator.next());
            if (!(fileSystem instanceof GSIFTPFileSystem)) continue;
            gsiFileSystem = (GSIFTPFileSystem)fileSystem;
        }
        if (gsiFileSystem != null) {
            MyProxyDocument myproxydocument = MyProxyDocument.Factory.newInstance();
            MyProxyType myproxy = myproxydocument.addNewMyProxy();
            myproxy.setProxyServer(gsiFileSystem.getMyProxyURL());
            myproxy.setProxyServerPort(gsiFileSystem.getMyProxyPort());
            myproxy.setProxyServerUserName(gsiFileSystem.getUsername());
            myproxy.setProxyServerLifetime(4069);
            myproxy.setProxyServerPassPhrase(gsiFileSystem.getPassword());
            XmlCursor tocursor = jobdefinition.newCursor();
            tocursor.toEndToken();
            XmlCursor fromcursor = myproxy.newCursor();
            fromcursor.toStartDoc();
            fromcursor.moveXmlContents(tocursor);
        }
    }

    private static void AddFileStaging(JobDescriptionType description, Job job, FileSystemTable fileSystemTable) throws RapidException {
        for (String dataStageName : job.getDataStages()) {
            URI authURI;
            AbstractFileSystem fs;
            String fsname;
            DataStage dataStage = job.getDataStage(dataStageName);
            DataStagingType dsType = description.addNewDataStaging();
            DataStageURL dsURL = dataStage.getSourceURL();
            if (dsURL != null) {
                SourceTargetType source = dsType.addNewSource();
                fsname = dsURL.getFileSystem();
                fs = fileSystemTable.getFileSystem(fsname);
                if (fs != null) {
                    try {
                        authURI = new URI(fs.getAuthURL());
                        source.setURI(authURI.getScheme() + "://" + authURI.getAuthority() + dsURL.getPath());
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if ((dsURL = dataStage.getTargetURL()) != null) {
                SourceTargetType target = dsType.addNewTarget();
                fsname = dsURL.getFileSystem();
                fs = fileSystemTable.getFileSystem(fsname);
                if (fs != null) {
                    try {
                        authURI = new URI(fs.getAuthURL());
                        target.setURI(authURI.getScheme() + "://" + authURI.getAuthority() + dsURL.getPath());
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            dsType.setDeleteOnTermination(dataStage.isDeleteOnTermination());
            CreationFlag jobCF = dataStage.getCreationFlagEnum();
            CreationFlagEnumeration.Enum creationFlag = CreationFlagEnumeration.OVERWRITE;
            dsType.setCreationFlag(creationFlag);
            dsType.setFileName(dataStage.getFileName());
        }
    }
}

