/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.jobsubmission.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.icenigrid.gridsam.client.common.ClientSideJobManager;
import org.icenigrid.gridsam.core.ConfigurationException;
import org.icenigrid.gridsam.core.JobInstance;
import org.icenigrid.gridsam.core.JobManagerException;
import org.icenigrid.gridsam.core.UnknownJobException;
import org.icenigrid.schema.jsdl.y2005.m11.JobDefinitionDocument;
import uk.ac.nesc.rapid.data.filesystem.FileSystemTable;
import uk.ac.nesc.rapid.data.job.Job;
import uk.ac.nesc.rapid.jobsubmission.SubmissionServer;
import uk.ac.nesc.rapid.jobsubmission.impl.JSDLGenerator;

public class GridsamSubmissionServer
implements SubmissionServer {
    private URL url = null;
    private String name = null;
    private String workingDirectory = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    public void setURL(String url) {
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void submit(Job job, FileSystemTable fileSystemTable) {
        try {
            ClientSideJobManager jobManager = new ClientSideJobManager(this.getURL().toString());
            JobDefinitionDocument jsdlDocument = JSDLGenerator.getJSDL(job, fileSystemTable);
            JobInstance jobInstance = jobManager.submitJob(jsdlDocument);
            job.setJobID(jobInstance.getID());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String monitor(Job job) {
        try {
            ClientSideJobManager jobmanager = new ClientSideJobManager(this.getURL().toString());
            JobInstance jobinstance = jobmanager.findJobInstance(job.getJobID());
            if (jobinstance == null) {
                return "Error retrieving job";
            }
            List stages = jobinstance.getJobStages();
            if (stages.isEmpty()) {
                return "Unknown";
            }
            return jobinstance.getLastKnownStage().getDescription();
        }
        catch (ConfigurationException ex) {
            return "Configuration Error: " + ex.getMessage();
        }
        catch (UnknownJobException ex) {
            return "Unknown Job: " + ex.getMessage();
        }
        catch (JobManagerException ex) {
            return "Error in Job Manager: " + ex.getMessage();
        }
    }

    public String toString() {
        return "GridSam Server\nName " + this.getName() + "\nURL: " + (this.url == null ? "NULL!" : this.url.toString()) + "\n" + "workingdirectory " + (this.workingDirectory == null ? "NULL" : this.workingDirectory) + "\n";
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }
}

