/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.job.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import uk.ac.nesc.rapid.data.job.DataStage;
import uk.ac.nesc.rapid.data.job.EnvironmentVariable;
import uk.ac.nesc.rapid.data.job.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobImpl
implements Job {
    private String jobid = "No ID";
    private String executable;
    private String stdin;
    private String stdout;
    private String stderr;
    private String workingDir;
    private String submissionServer;
    private List<String> parameterlist = new Vector<String>();
    private Map<Integer, EnvironmentVariable> environmentlist = new HashMap<Integer, EnvironmentVariable>();
    private Map<String, DataStage> datastagelist = new HashMap<String, DataStage>();

    @Override
    public String getJobID() {
        return this.jobid;
    }

    @Override
    public void setJobID(String jobid) {
        this.jobid = jobid;
    }

    @Override
    public String getExecutable() {
        return this.executable;
    }

    @Override
    public void setExecutable(String executable) {
        this.executable = executable;
    }

    @Override
    public String getStdin() {
        return this.stdin;
    }

    @Override
    public void setStdin(String stdin) {
        this.stdin = stdin;
    }

    @Override
    public String getStdout() {
        return this.stdout;
    }

    @Override
    public void setStdout(String stdout) {
        this.stdout = stdout;
    }

    @Override
    public String getStderr() {
        return this.stderr;
    }

    @Override
    public void setStderr(String stderr) {
        this.stderr = stderr;
    }

    @Override
    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public void setWorkingDir(String workingdir) {
        this.workingDir = workingdir;
    }

    @Override
    public String getParameter(int index) {
        if (index >= 0 && index < this.parameterlist.size()) {
            return this.parameterlist.get(index);
        }
        return null;
    }

    @Override
    public List<String> getParameterList() {
        return this.parameterlist;
    }

    @Override
    public void addParameter(String parameter) {
        this.parameterlist.add(parameter);
    }

    @Override
    public void addParameter(int index, String parameter) {
        if (parameter == null) {
            return;
        }
        while (index >= this.parameterlist.size()) {
            this.parameterlist.add(null);
        }
        this.parameterlist.remove(index);
        this.parameterlist.add(index, parameter);
    }

    @Override
    public EnvironmentVariable getEnvironmentVariable(int index) {
        return this.environmentlist.get(index);
    }

    @Override
    public Collection<EnvironmentVariable> getEnvironmentVariableCollection() {
        return this.environmentlist.values();
    }

    @Override
    public void addEnvironmentName(int index, String name) {
        if (name == null) {
            return;
        }
        EnvironmentVariable env = this.getEnvironmentVariable(index);
        if (env == null) {
            env = new EnvironmentVariable();
        }
        env.setName(name);
        this.addEnvironmentVariable(index, env);
    }

    @Override
    public void addEnvironmentValue(int index, String value) {
        if (value == null) {
            return;
        }
        EnvironmentVariable env = this.getEnvironmentVariable(index);
        if (env == null) {
            env = new EnvironmentVariable();
        }
        env.setValue(value);
        this.addEnvironmentVariable(index, env);
    }

    @Override
    public void addEnvironmentVariable(int index, EnvironmentVariable environment) {
        this.environmentlist.put(index, environment);
    }

    @Override
    public void addDataStage(String name, DataStage datastage) {
        this.datastagelist.put(name, datastage);
    }

    @Override
    public DataStage getDataStage(String name) {
        return this.datastagelist.get(name);
    }

    @Override
    public Set<String> getDataStages() {
        return this.datastagelist.keySet();
    }

    @Override
    public String getSubmissionServer() {
        return this.submissionServer;
    }

    @Override
    public void setSubmissionServer(String submissionServer) {
        this.submissionServer = submissionServer;
    }

    public String toString() {
        int i;
        String result = "JOB REPOSITORY:\n=====================\n";
        result = result + "ID: " + this.jobid + "\n";
        result = result + "EXEC: " + this.executable + "\n";
        result = result + "STDIN: " + this.stdin + "\n";
        result = result + "STDOUT: " + this.stdout + "\n";
        result = result + "STDERR: " + this.stderr + "\n";
        result = result + "WDIR: " + this.workingDir + "\n";
        result = result + "Submision Server " + this.getSubmissionServer() + "\n";
        result = result + "Parameters: ";
        for (i = 0; i < this.parameterlist.size(); ++i) {
            result = result + this.parameterlist.get(i) + " : ";
        }
        result = result + "\n";
        result = result + "Environment Vars: ";
        for (i = 0; i < this.environmentlist.size(); ++i) {
            result = result + this.environmentlist.get(i);
        }
        result = result + "\n";
        result = result + "DataStage:\n";
        Set<String> keyset = this.datastagelist.keySet();
        for (String key : keyset) {
            DataStage ds = this.datastagelist.get(key);
            result = result + "----------------------------\n";
            result = result + "DataStage: " + key + "\n";
            result = result + ds.toString();
        }
        result = result + "----------------------------\n";
        return result;
    }
}

