/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.filesystem.impl;

import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.globus.myproxy.MyProxy;
import org.globus.myproxy.MyProxyException;
import org.ietf.jgss.GSSCredential;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;
import uk.ac.nesc.rapid.vfs.gsiftp.GSIFTPFileSystemConfigBuilder;

public class GSIFTPFileSystem
extends AbstractFileSystem {
    private static final int LIFETIME = 99999;
    private String username = null;
    private String password = null;
    private String myProxyURL = null;
    private int myProxyPort = 0;
    private GSSCredential proxyCertificate = null;

    public void addVFSOptions(FileSystemOptions opts) throws FileSystemException, MyProxyException {
        if (this.getProxyCertificate() == null && this.getMyProxyURL() != null) {
            MyProxy myproxy = new MyProxy();
            myproxy.setHost(this.getMyProxyURL());
            myproxy.setPort(this.getMyProxyPort());
            this.setProxyCertificate(myproxy.get(this.getUsername(), this.getPassword(), 99999));
        }
        if (this.getProxyCertificate() != null) {
            GSIFTPFileSystemConfigBuilder.getInstance().setGSSCredential(opts, this.getProxyCertificate());
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getMyProxyURL() {
        return this.myProxyURL;
    }

    public void setMyProxyURL(String myProxyURL) {
        this.myProxyURL = myProxyURL;
    }

    public int getMyProxyPort() {
        return this.myProxyPort;
    }

    public void setMyProxyPort(int myProxyPort) {
        this.myProxyPort = myProxyPort;
    }

    public void setMyProxyPort(String myProxyPort) {
        this.myProxyPort = Integer.parseInt(myProxyPort);
    }

    public GSSCredential getProxyCertificate() {
        return this.proxyCertificate;
    }

    public void setProxyCertificate(GSSCredential proxyCertificate) {
        this.proxyCertificate = proxyCertificate;
    }

    public String toString() {
        String result = "";
        result = result + "GSIFTP SERVER\n";
        result = result + "description " + this.getName() + "\n";
        result = result + "URL: " + this.getURL() + "\n";
        result = result + "myproxyhost: " + this.getMyProxyURL() + "\n";
        result = result + "myproxyport: " + this.getMyProxyPort() + "\n";
        result = result + "username: " + this.getUsername() + "\n";
        result = result + "password: " + this.getPassword() + "\n";
        return result;
    }
}

