/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.data.filesystem.impl;

import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticator;
import org.apache.commons.vfs.auth.StaticUserAuthenticator;
import org.apache.commons.vfs.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs.provider.sftp.SftpFileSystemConfigBuilder;
import org.globus.myproxy.MyProxyException;
import uk.ac.nesc.rapid.data.filesystem.AbstractFileSystem;

public class FTPFileSystem
extends AbstractFileSystem {
    private String username = null;
    private String password = null;

    public String getAuthURL() {
        int index = this.getURL().indexOf("://") + 3;
        String result = this.getURL().substring(0, index);
        result = result + this.getUsername() + ":" + this.getPassword() + "@";
        result = result + this.getURL().substring(index);
        return result;
    }

    public void addVFSOptions(FileSystemOptions opts) throws FileSystemException, MyProxyException {
        if (this.getUsername() != null || this.getPassword() != null) {
            StaticUserAuthenticator auth = new StaticUserAuthenticator(null, this.getUsername(), this.getPassword());
            DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(opts, (UserAuthenticator)auth);
            SftpFileSystemConfigBuilder.getInstance().setStrictHostKeyChecking(opts, "no");
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String toString() {
        String result = "";
        result = result + "FTP SERVER\n";
        result = result + "description " + this.getName() + "\n";
        result = result + "URL: " + this.getURL() + "\n";
        result = result + "username: " + this.getUsername() + "\n";
        result = result + "password: " + this.getPassword() + "\n";
        return result;
    }
}

