/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.vfs.gsiftp;

import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemOptions;
import org.ietf.jgss.GSSCredential;
import uk.ac.nesc.rapid.vfs.gsiftp.GSIFTPFileSystem;

public class GSIFTPFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static GSIFTPFileSystemConfigBuilder singleton;

    private GSIFTPFileSystemConfigBuilder() {
    }

    public static synchronized GSIFTPFileSystemConfigBuilder getInstance() {
        if (singleton == null) {
            singleton = new GSIFTPFileSystemConfigBuilder();
        }
        return singleton;
    }

    protected Class getConfigClass() {
        return GSIFTPFileSystem.class;
    }

    public void setGSSCredential(FileSystemOptions options, GSSCredential credential) {
        this.setParam(options, "globus.GSSCredential", credential);
    }

    public GSSCredential getGSSCredential(FileSystemOptions options) {
        return (GSSCredential)this.getParam(options, "globus.GSSCredential");
    }

    public void setUserDirIsRoot(FileSystemOptions opts, boolean userDirIsRoot) {
        this.setParam(opts, "globus.userdir", userDirIsRoot ? Boolean.TRUE : Boolean.FALSE);
    }

    public Boolean getUserDirIsRoot(FileSystemOptions opts) {
        return (Boolean)this.getParam(opts, "globus.userdir");
    }
}

