/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.nesc.rapid.vfs.gsiftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.util.FileObjectUtils;
import org.apache.commons.vfs.util.MonitorInputStream;
import org.apache.commons.vfs.util.MonitorOutputStream;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.FileInfo;
import org.globus.ftp.InputStreamDataSink;
import org.globus.ftp.OutputStreamDataSource;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.ServerException;
import org.globus.ftp.vanilla.TransferState;
import uk.ac.nesc.rapid.vfs.gsiftp.ExtendedGridFTPClient;
import uk.ac.nesc.rapid.vfs.gsiftp.GSIFTPFileSystem;

public class GSIFTPFileObject
extends AbstractFileObject {
    private GSIFTPFileSystem fileSystem = null;
    private String relPath;
    private Map<String, FileInfo> children;
    private FileInfo fileInfo;
    private boolean inRefresh = false;
    private FileObject linkDestination;
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new TreeMap());

    protected GSIFTPFileObject(FileName name, GSIFTPFileSystem fileSystem, FileName rootName) throws FileSystemException {
        super(name, (AbstractFileSystem)fileSystem);
        this.fileSystem = fileSystem;
        this.relPath = UriParser.decode((String)rootName.getRelativeName(name));
        if (".".equals(this.relPath)) {
            this.relPath = null;
        }
    }

    private FileObject getLinkDestination() throws FileSystemException {
        if (this.linkDestination == null) {
            String name = this.fileInfo.getName();
            int end = name.indexOf(" -> ");
            if (end > 0) {
                name = name.substring(end + 4);
            }
            this.linkDestination = this.getFileSystem().resolveFile(name);
        }
        return this.linkDestination;
    }

    protected FileObject[] doListChildrenResolved() throws Exception {
        if (this.fileInfo.isSoftLink()) {
            return this.getLinkDestination().getChildren();
        }
        return null;
    }

    private void doGetChildren() throws IOException {
        if (this.children != null) {
            return;
        }
        ExtendedGridFTPClient client = this.fileSystem.getClient();
        try {
            client.setPassive();
            client.setLocalActive();
            String previousDir = client.getCurrentDir();
            client.changeDir(this.relPath == null ? previousDir : this.relPath);
            Vector childrenList = client.list();
            client.changeDir(previousDir);
            if (childrenList == null || childrenList.size() == 0) {
                this.children = EMPTY_MAP;
            } else {
                this.children = new TreeMap<String, FileInfo>();
                for (int i = 0; i < childrenList.size(); ++i) {
                    int end;
                    FileInfo child = (FileInfo)childrenList.get(i);
                    if (child == null || ".".equals(child.getName()) || "..".equals(child.getName())) continue;
                    String childname = child.getName();
                    if (child.isSoftLink() && (end = childname.indexOf(" -> ")) > 0) {
                        childname = childname.substring(0, end);
                    }
                    this.children.put(childname, child);
                }
            }
        }
        catch (ClientException ex) {
            throw new IOException(ex.getMessage());
        }
        catch (ServerException ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            this.fileSystem.putClient(client);
        }
    }

    protected void doSetAttribute(String attrName, Object value) {
        if (value instanceof String) {
            String mode = (String)value;
            try {
                ExtendedGridFTPClient client = this.fileSystem.getClient();
                client.setPassive();
                client.setLocalActive();
                client.chmod(this.relPath, mode);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    protected void doAttach() throws IOException {
        this.getInfo(false);
    }

    private FileInfo getChildFile(String name, boolean flush) throws IOException {
        if (flush && !this.inRefresh) {
            this.children = null;
        }
        this.doGetChildren();
        FileInfo info = this.children.get(name);
        return info;
    }

    private void getInfo(boolean flush) throws IOException {
        FileInfo newFileInfo;
        GSIFTPFileObject parent = (GSIFTPFileObject)FileObjectUtils.getAbstractFileObject((FileObject)this.getParent());
        if (parent != null) {
            newFileInfo = parent.getChildFile(UriParser.decode((String)this.getName().getBaseName()), flush);
        } else {
            newFileInfo = new FileInfo();
            newFileInfo.setName("/");
            newFileInfo.setFileType((byte)2);
        }
        this.fileInfo = newFileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws FileSystemException {
        if (!this.inRefresh) {
            try {
                this.inRefresh = true;
                super.refresh();
                try {
                    this.getInfo(true);
                }
                catch (IOException e) {
                    throw new FileSystemException((Throwable)e);
                }
            }
            finally {
                this.inRefresh = false;
            }
        }
    }

    protected void doDetach() {
        this.fileInfo = null;
        this.children = null;
    }

    protected void onChildrenChanged(FileName child, FileType newType) {
        if (this.children != null && newType.equals(FileType.IMAGINARY)) {
            try {
                this.children.remove(UriParser.decode((String)child.getBaseName()));
            }
            catch (FileSystemException e) {
                throw new RuntimeException(e.getMessage());
            }
        } else {
            this.children = null;
        }
    }

    protected void onChange() throws IOException {
        this.children = null;
        if (this.getType().equals(FileType.IMAGINARY)) {
            this.fileInfo = null;
            return;
        }
        this.getInfo(true);
    }

    protected FileType doGetType() throws Exception {
        if (this.fileInfo == null) {
            return FileType.IMAGINARY;
        }
        if (this.fileInfo.isSoftLink()) {
            return this.getLinkDestination().getType();
        }
        if (this.fileInfo.isDirectory()) {
            return FileType.FOLDER;
        }
        if (this.fileInfo.isFile()) {
            return FileType.FILE;
        }
        throw new FileSystemException("vfs.provider.ftp/get-type.error", (Object)this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject[] getChildren() throws FileSystemException {
        try {
            this.inRefresh = true;
            FileObject[] fileObjectArray = super.getChildren();
            return fileObjectArray;
        }
        finally {
            this.inRefresh = false;
        }
    }

    protected String[] doListChildren() throws Exception {
        this.doGetChildren();
        String[] childNames = new String[this.children.size()];
        int childNum = -1;
        Iterator<FileInfo> iterChildren = this.children.values().iterator();
        while (iterChildren.hasNext()) {
            ++childNum;
            FileInfo child = iterChildren.next();
            if (child.isSoftLink()) {
                String name = child.getName();
                int end = name.indexOf(" -> ");
                if (end <= 0) continue;
                childNames[childNum] = name = name.substring(0, end);
                continue;
            }
            childNames[childNum] = child.getName();
        }
        return childNames;
    }

    protected long doGetContentSize() throws Exception {
        return this.fileInfo.getSize();
    }

    protected InputStream doGetInputStream() throws Exception {
        ExtendedGridFTPClient client = this.fileSystem.getClient();
        client.setPassive();
        client.setLocalActive();
        InputStreamDataSink sink = new InputStreamDataSink();
        TransferState state = client.asynchGet(this.relPath, (DataSink)sink, null);
        return new GSIFTPInputStream(client, state, sink.getInputStream());
    }

    protected OutputStream doGetOutputStream(boolean append) throws Exception {
        ExtendedGridFTPClient client = this.fileSystem.getClient();
        client.setPassive();
        client.setLocalActive();
        OutputStreamDataSource source = new OutputStreamDataSource(1024);
        TransferState state = client.asynchPut(this.relPath, (DataSource)source, null);
        state.waitForStart();
        return new GSIFTPOutputStream(client, state, source.getOutputStream());
    }

    protected void doDelete() throws Exception {
        if (FileType.FILE.equals(this.getType())) {
            this.fileSystem.getClient().deleteFile(this.getName().getPath());
        } else {
            this.fileSystem.getClient().deleteDir(this.getName().getPath());
        }
    }

    protected void doRename(FileObject newfile) throws Exception {
        String oldPath = this.getName().getPath();
        String newPath = newfile.getName().getPath();
        this.fileSystem.getClient().rename(oldPath, newPath);
    }

    protected void doCreateFolder() throws Exception {
        ExtendedGridFTPClient client = this.fileSystem.getClient();
        client.makeDir(this.relPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFile() throws FileSystemException {
        GSIFTPFileObject gSIFTPFileObject = this;
        synchronized (gSIFTPFileObject) {
            try {
                this.getOutputStream().close();
                this.endOutput();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class GSIFTPOutputStream
    extends MonitorOutputStream {
        private final ExtendedGridFTPClient client;
        private final TransferState state;

        public GSIFTPOutputStream(ExtendedGridFTPClient client, TransferState state, OutputStream out) {
            super(out);
            this.client = client;
            this.state = state;
        }

        protected void onClose() throws IOException {
            try {
                this.state.waitForEnd();
                GSIFTPFileObject.this.fileSystem.putClient(this.client);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class GSIFTPInputStream
    extends MonitorInputStream {
        private final ExtendedGridFTPClient client;
        private final TransferState state;

        public GSIFTPInputStream(ExtendedGridFTPClient client, TransferState state, InputStream in) {
            super(in);
            this.client = client;
            this.state = state;
        }

        protected void onClose() throws IOException {
            try {
                this.in.close();
                this.state.waitForEnd();
                GSIFTPFileObject.this.fileSystem.putClient(this.client);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

