/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XmlSchemaDateFormat
extends DateFormat {
    private static Log log = LogFactory.getLog(XmlSchemaDateFormat.class);
    private static boolean doDebug = false;
    private static final DateFormat DATEFORMAT_XSD_ZULU;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parse(String src, ParsePosition parse_pos) {
        Date date;
        int index = 0;
        try {
            if (src != null) {
                if (src.charAt(0) == '+' || src.charAt(0) == '-') {
                    src = src.substring(1);
                }
                if (src.length() < 19) {
                    parse_pos.setIndex(src.length() - 1);
                    this.handleParseError(parse_pos, "TOO_FEW_CHARS");
                }
                index = 4;
                this.validateChar(src, parse_pos, 4, '-', "EXPECTED_DASH");
                index = 7;
                this.validateChar(src, parse_pos, 7, '-', "EXPECTED_DASH");
                index = 10;
                this.validateChar(src, parse_pos, 10, 'T', "EXPECTED_CAPITAL_T");
                index = 13;
                this.validateChar(src, parse_pos, 13, ':', "EXPECTED_COLON_IN_TIME");
                index = 16;
                this.validateChar(src, parse_pos, 16, ':', "EXPECTED_COLON_IN_TIME");
            }
            try {
                DateFormat dateFormat = DATEFORMAT_XSD_ZULU;
                synchronized (dateFormat) {
                    date = DATEFORMAT_XSD_ZULU.parse(src == null ? null : src.substring(0, 19) + ".000Z");
                }
            }
            catch (Exception e) {
                throw new NumberFormatException(e.toString());
            }
            index = 19;
            if (src != null) {
                if (index < src.length() && src.charAt(index) == '.') {
                    int milliseconds = 0;
                    int start = ++index;
                    while (index < src.length() && Character.isDigit(src.charAt(index))) {
                        ++index;
                    }
                    String decimal = src.substring(start, index);
                    if (decimal.length() == 3) {
                        milliseconds = Integer.parseInt(decimal);
                    } else if (decimal.length() < 3) {
                        milliseconds = Integer.parseInt((decimal + "000").substring(0, 3));
                    } else {
                        milliseconds = Integer.parseInt(decimal.substring(0, 3));
                        if (decimal.charAt(3) >= '5') {
                            ++milliseconds;
                        }
                    }
                    date.setTime(date.getTime() + (long)milliseconds);
                }
                if (index + 5 < src.length() && (src.charAt(index) == '+' || src.charAt(index) == '-')) {
                    this.validateCharIsDigit(src, parse_pos, index + 1, "EXPECTED_NUMERAL");
                    this.validateCharIsDigit(src, parse_pos, index + 2, "EXPECTED_NUMERAL");
                    this.validateChar(src, parse_pos, index + 3, ':', "EXPECTED_COLON_IN_TIMEZONE");
                    this.validateCharIsDigit(src, parse_pos, index + 4, "EXPECTED_NUMERAL");
                    this.validateCharIsDigit(src, parse_pos, index + 5, "EXPECTED_NUMERAL");
                    int hours = (src.charAt(index + 1) - 48) * 10 + src.charAt(index + 2) - 48;
                    int mins = (src.charAt(index + 4) - 48) * 10 + src.charAt(index + 5) - 48;
                    int millisecs = (hours * 60 + mins) * 60 * 1000;
                    if (src.charAt(index) == '+') {
                        millisecs = -millisecs;
                    }
                    date.setTime(date.getTime() + (long)millisecs);
                    index += 6;
                }
                if (index < src.length() && src.charAt(index) == 'Z') {
                    ++index;
                }
                if (index < src.length()) {
                    this.handleParseError(parse_pos, "TOO_MANY_CHARS");
                }
            }
        }
        catch (ParseException pe) {
            log.error((Object)pe.toString());
            index = 0;
            parse_pos.setErrorIndex(index);
            date = null;
        }
        parse_pos.setIndex(index);
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(Date date, StringBuffer append_buf, FieldPosition field_pos) {
        String str;
        DateFormat dateFormat = DATEFORMAT_XSD_ZULU;
        synchronized (dateFormat) {
            str = DATEFORMAT_XSD_ZULU.format(date);
        }
        if (append_buf == null) {
            append_buf = new StringBuffer();
        }
        append_buf.append(str);
        return append_buf;
    }

    private void validateChar(String str, ParsePosition parse_pos, int index, char expected, String error_reason) throws ParseException {
        if (str.charAt(index) != expected) {
            this.handleParseError(parse_pos, error_reason);
        }
    }

    private void validateCharIsDigit(String str, ParsePosition parse_pos, int index, String error_reason) throws ParseException {
        if (!Character.isDigit(str.charAt(index))) {
            this.handleParseError(parse_pos, error_reason);
        }
    }

    private void handleParseError(ParsePosition parse_pos, String error_reason) throws ParseException {
        throw new ParseException("INVALID_XSD_DATETIME", parse_pos.getErrorIndex());
    }

    static {
        doDebug = log.isDebugEnabled();
        DATEFORMAT_XSD_ZULU = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        DATEFORMAT_XSD_ZULU.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

