/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSBaseMessage {
    private static Log log = LogFactory.getLog((String)WSBaseMessage.class.getName());
    protected String actor = null;
    protected boolean mustunderstand = true;
    protected String user = null;
    protected String password = null;
    protected int keyIdentifierType = 2;
    protected Vector parts = null;
    protected int timeToLive = 300;
    protected boolean doDebug = false;
    protected WSSConfig wssConfig = WSSConfig.getDefaultWSConfig();

    public WSBaseMessage() {
    }

    public WSBaseMessage(String actor) {
        this(actor, true);
    }

    public WSBaseMessage(String actor, boolean mu) {
        this.setActor(actor);
        this.setMustUnderstand(mu);
    }

    public void setActor(String act) {
        this.actor = act;
    }

    public void setTimeToLive(int ttl) {
        this.timeToLive = ttl;
    }

    public void setParts(Vector parts) {
        this.parts = parts;
    }

    public void setMustUnderstand(boolean mu) {
        this.mustunderstand = mu;
    }

    public void setKeyIdentifierType(int keyIdType) {
        this.keyIdentifierType = keyIdType;
    }

    public int getKeyIdentifierType() {
        return this.keyIdentifierType;
    }

    public void setWsConfig(WSSConfig wsConfig) {
        this.wssConfig = wsConfig;
    }

    protected String setBodyID(Document doc) throws Exception {
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
        Element bodyElement = (Element)WSSecurityUtil.getDirectChild(doc.getFirstChild(), soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI());
        if (bodyElement == null) {
            throw new Exception("SOAP Body Element node not found");
        }
        return this.setWsuId(bodyElement);
    }

    protected String setWsuId(Element bodyElement) {
        String id = null;
        id = bodyElement.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (id == null || id.length() == 0) {
            id = "id-" + Integer.toString(bodyElement.hashCode());
            String prefix = WSSecurityUtil.setNamespace(bodyElement, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
            bodyElement.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", prefix + ":Id", id);
        }
        return id;
    }

    public void setUserInfo(String user, String password) {
        this.user = user;
        this.password = password;
    }

    protected Element insertSecurityHeader(Document doc) {
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
        Element securityHeader = WSSecurityUtil.getSecurityHeader(doc, this.actor, soapConstants);
        if (securityHeader == null) {
            securityHeader = WSSecurityUtil.findWsseSecurityHeaderBlock(doc, doc.getDocumentElement(), this.actor, true);
            String soapPrefix = WSSecurityUtil.getPrefixNS(soapConstants.getEnvelopeURI(), securityHeader);
            if (this.actor != null && this.actor.length() > 0) {
                securityHeader.setAttributeNS(soapConstants.getEnvelopeURI(), soapPrefix + ":" + soapConstants.getRoleAttributeQName().getLocalPart(), this.actor);
            }
            if (this.mustunderstand) {
                securityHeader.setAttributeNS(soapConstants.getEnvelopeURI(), soapPrefix + ":" + "mustUnderstand", soapConstants.getMustunderstand());
            }
        }
        return securityHeader;
    }
}

