/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.axis.security;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.axis.security.handler.WSDoAllHandler;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WSDoAllReceiver
extends WSDoAllHandler {
    protected static Log log = LogFactory.getLog((String)WSDoAllReceiver.class.getName());
    private static Log tlog = LogFactory.getLog((String)"org.apache.ws.security.TIME");

    public void invoke(MessageContext msgContext) throws AxisFault {
        boolean doDebug = log.isDebugEnabled();
        if (doDebug) {
            log.debug((Object)("WSDoAllReceiver: enter invoke() with msg type: " + msgContext.getCurrentMessage().getMessageType()));
        }
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        long t4 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        RequestData reqData = new RequestData();
        try {
            Timestamp timestamp;
            X509Certificate returnCert;
            reqData.setMsgContext(msgContext);
            Vector actions = new Vector();
            String action = null;
            action = (String)this.getOption("action");
            if (action == null) {
                action = (String)msgContext.getProperty("action");
            }
            if (action == null) {
                throw new AxisFault("WSDoAllReceiver: No action defined");
            }
            int doAction = WSSecurityUtil.decodeAction(action, actions);
            String actor = (String)this.getOption("actor");
            Message sm = msgContext.getCurrentMessage();
            Document doc = null;
            if (sm == null) {
                return;
            }
            try {
                doc = sm.getSOAPEnvelope().getAsDocument();
                if (doDebug) {
                    log.debug((Object)"Received SOAP request: ");
                    log.debug((Object)XMLUtils.PrettyDocumentToString((Document)doc));
                }
            }
            catch (Exception ex) {
                throw new AxisFault("WSDoAllReceiver: cannot convert into document", (Throwable)ex);
            }
            String msgType = sm.getMessageType();
            if (msgType != null && msgType.equals("response")) {
                SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
                if (WSSecurityUtil.findElement(doc.getDocumentElement(), "Fault", soapConstants.getEnvelopeURI()) != null) {
                    return;
                }
            }
            CallbackHandler cbHandler = null;
            if ((doAction & 5) != 0) {
                cbHandler = this.getPasswordCB(reqData);
            }
            this.doReceiverAction(doAction, reqData);
            Vector wsResult = null;
            if (tlog.isDebugEnabled()) {
                t1 = System.currentTimeMillis();
            }
            try {
                wsResult = secEngine.processSecurityHeader(doc, actor, cbHandler, reqData.getSigCrypto(), reqData.getDecCrypto());
            }
            catch (WSSecurityException ex) {
                ex.printStackTrace();
                throw new AxisFault("WSDoAllReceiver: security processing failed", (Throwable)ex);
            }
            if (tlog.isDebugEnabled()) {
                t2 = System.currentTimeMillis();
            }
            if (wsResult == null) {
                if (doAction == 0) {
                    return;
                }
                throw new AxisFault("WSDoAllReceiver: Request does not contain required Security header");
            }
            if (reqData.getWssConfig().isEnableSignatureConfirmation() && msgContext.getPastPivot()) {
                this.checkSignatureConfirmation(reqData, wsResult);
            }
            ArrayList<QName> processedHeaders = new ArrayList<QName>();
            for (SOAPHeaderElement tempHeader : sm.getSOAPEnvelope().getHeaders()) {
                if (!tempHeader.isProcessed()) continue;
                processedHeaders.add(tempHeader.getQName());
            }
            SOAPPart sPart = (SOAPPart)sm.getSOAPPart();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            org.apache.xml.security.utils.XMLUtils.outputDOM((Node)doc, (OutputStream)os, (boolean)true);
            sPart.setCurrentMessage((Object)os.toByteArray(), 4);
            if (doDebug) {
                log.debug((Object)"Processed received SOAP request");
                log.debug((Object)XMLUtils.PrettyDocumentToString((Document)doc));
            }
            if (tlog.isDebugEnabled()) {
                t3 = System.currentTimeMillis();
            }
            for (QName qname : processedHeaders) {
                Enumeration headersByName = sm.getSOAPEnvelope().getHeadersByName(qname.getNamespaceURI(), qname.getLocalPart());
                while (headersByName.hasMoreElements()) {
                    SOAPHeaderElement tempHeader = (SOAPHeaderElement)headersByName.nextElement();
                    tempHeader.setProcessed(true);
                }
            }
            SOAPHeader sHeader = null;
            try {
                sHeader = sm.getSOAPEnvelope().getHeader();
            }
            catch (Exception ex) {
                throw new AxisFault("WSDoAllReceiver: cannot get SOAP header after security processing", (Throwable)ex);
            }
            Iterator headers = sHeader.examineHeaderElements(actor);
            SOAPHeaderElement headerElement = null;
            while (headers.hasNext()) {
                SOAPHeaderElement hE = (SOAPHeaderElement)headers.next();
                if (!hE.getLocalName().equals("Security") || !hE.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) continue;
                headerElement = hE;
                break;
            }
            ((SOAPHeaderElement)headerElement).setProcessed(true);
            WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(wsResult, 2);
            if (actionResult != null && (returnCert = actionResult.getCertificate()) != null && !this.verifyTrust(returnCert, reqData)) {
                throw new AxisFault("WSDoAllReceiver: The certificate used for the signature is not trusted");
            }
            actionResult = WSSecurityUtil.fetchActionResult(wsResult, 32);
            if (actionResult != null && (timestamp = actionResult.getTimestamp()) != null && !this.verifyTimestamp(timestamp, this.decodeTimeToLive(reqData))) {
                throw new AxisFault("WSDoAllReceiver: The timestamp could not be validated");
            }
            if (!this.checkReceiverResults(wsResult, actions)) {
                throw new AxisFault("WSDoAllReceiver: security processing failed (actions mismatch)");
            }
            Vector<WSHandlerResult> results = null;
            results = (Vector<WSHandlerResult>)msgContext.getProperty("RECV_RESULTS");
            if (results == null) {
                results = new Vector<WSHandlerResult>();
                msgContext.setProperty("RECV_RESULTS", results);
            }
            WSHandlerResult rResult = new WSHandlerResult(actor, wsResult);
            results.add(0, rResult);
            if (tlog.isDebugEnabled()) {
                t4 = System.currentTimeMillis();
                tlog.debug((Object)("Receive request: total= " + (t4 - t0) + " request preparation= " + (t1 - t0) + " request processing= " + (t2 - t1) + " request to Axis= " + (t3 - t2) + " header, cert verify, timestamp= " + (t4 - t3) + "\n"));
            }
            if (doDebug) {
                log.debug((Object)"WSDoAllReceiver: exit invoke()");
            }
        }
        catch (WSSecurityException e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        finally {
            reqData.clear();
            reqData = null;
        }
    }
}

