/*
 * Decompiled with CFR 0.152.
 */
package org.gridsphere.provider.portlet.jsr;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortalContext;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.UnavailableException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gridsphere.portlet.impl.ActionRequestImpl;
import org.gridsphere.portlet.impl.ActionResponseImpl;
import org.gridsphere.portlet.impl.PortletConfigImpl;
import org.gridsphere.portlet.impl.PortletContextImpl;
import org.gridsphere.portlet.impl.PortletURLImpl;
import org.gridsphere.portlet.impl.RenderRequestImpl;
import org.gridsphere.portlet.impl.RenderResponseImpl;
import org.gridsphere.portlet.service.spi.PortletServiceFactory;
import org.gridsphere.portletcontainer.ApplicationPortlet;
import org.gridsphere.portletcontainer.PortletPreferencesManager;
import org.gridsphere.portletcontainer.PortletStatus;
import org.gridsphere.portletcontainer.PortletWebApplication;
import org.gridsphere.portletcontainer.impl.ApplicationPortletImpl;
import org.gridsphere.portletcontainer.impl.PortletWebApplicationImpl;
import org.gridsphere.portletcontainer.impl.descriptor.PortletCollection;
import org.gridsphere.portletcontainer.impl.descriptor.PortletDefinition;
import org.gridsphere.portletcontainer.impl.descriptor.PortletName;
import org.gridsphere.portletcontainer.impl.descriptor.SecurityConstraint;
import org.gridsphere.portletcontainer.impl.descriptor.UserAttribute;
import org.gridsphere.portletcontainer.impl.descriptor.UserDataConstraint;
import org.gridsphere.portletcontainer.impl.descriptor.types.TransportGuaranteeType;
import org.gridsphere.services.core.persistence.PersistenceManagerRdbms;
import org.gridsphere.services.core.persistence.PersistenceManagerService;
import org.gridsphere.services.core.portal.PortalConfigService;
import org.gridsphere.services.core.registry.PortletManagerService;
import org.gridsphere.services.core.registry.PortletRegistryService;
import org.gridsphere.services.core.security.auth.AuthModuleService;
import org.gridsphere.services.core.user.User;

public class PortletServlet
extends HttpServlet
implements Servlet,
ServletConfig,
HttpSessionAttributeListener,
HttpSessionListener,
HttpSessionActivationListener {
    private transient Log log = LogFactory.getLog(PortletServlet.class);
    private transient PortletRegistryService registryService = null;
    private transient PortalConfigService configService = null;
    private PortletWebApplicationImpl portletWebApp = null;
    private PortletContext portletContext = null;
    private Map<String, Portlet> portlets = null;
    private Map<String, String> portletclasses = null;
    private Map<String, ApplicationPortlet> portletApps = null;
    private Map<String, PortletConfig> portletConfigHash = null;
    private Map<String, String> userKeys = new HashMap<String, String>();
    private List<String> securePortlets = new ArrayList<String>();
    private transient PersistenceManagerService pms = (PersistenceManagerService)PortletServiceFactory.createPortletService(PersistenceManagerService.class, (boolean)true);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.log.info((Object)"in init of PortletServlet");
        this.portlets = new Hashtable<String, Portlet>();
        this.portletclasses = new Hashtable<String, String>();
        this.portletApps = new Hashtable<String, ApplicationPortlet>();
        this.portletConfigHash = new Hashtable<String, PortletConfig>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initJSRPortletWebapp() {
        SecurityConstraint[] secConstraints;
        this.registryService = (PortletRegistryService)PortletServiceFactory.createPortletService(PortletRegistryService.class, (boolean)true);
        this.configService = (PortalConfigService)PortletServiceFactory.createPortletService(PortalConfigService.class, (boolean)true);
        ServletContext ctx = this.getServletContext();
        this.portletWebApp = new PortletWebApplicationImpl(ctx, Thread.currentThread().getContextClassLoader());
        if (this.portletWebApp.getWebApplicationStatus().equals((Object)PortletStatus.FAILURE)) {
            return;
        }
        Collection appPortlets = this.portletWebApp.getAllApplicationPortlets();
        for (ApplicationPortlet appPortlet : appPortlets) {
            String portletClass = appPortlet.getApplicationPortletClassName();
            String portletName = appPortlet.getApplicationPortletName();
            try {
                Portlet portletInstance = (Portlet)Class.forName(portletClass).newInstance();
                this.portletApps.put(portletName, appPortlet);
                this.portlets.put(portletName, portletInstance);
                this.portletclasses.put(portletClass, portletName);
                this.log.debug((Object)("Creating new portlet instance: " + portletClass));
            }
            catch (Exception e) {
                String msg = "Unable to create jsr portlet instance: " + portletClass;
                this.log.error((Object)msg, (Throwable)e);
                appPortlet.setApplicationPortletStatus(PortletStatus.FAILURE);
                appPortlet.setApplicationPortletStatusMessage(msg);
                this.portletWebApp.setWebApplicationStatusMessage("FAILURE to instantiate one or more portlet instances");
                this.portletWebApp.setWebApplicationStatus(PortletStatus.FAILURE);
            }
            finally {
                this.registryService.addWebApplication((PortletWebApplication)this.portletWebApp);
            }
        }
        UserAttribute[] userAttrs = this.portletWebApp.getUserAttributes();
        if (userAttrs != null) {
            String key = null;
            for (int i = 0; i < userAttrs.length; ++i) {
                key = userAttrs[i].getName().getContent();
                this.userKeys.put(key, "");
            }
        }
        if ((secConstraints = this.portletWebApp.getSecurityConstraints()) != null) {
            for (int i = 0; i < secConstraints.length; ++i) {
                PortletCollection portlets = secConstraints[i].getPortletCollection();
                PortletName[] names = portlets.getPortletName();
                UserDataConstraint userConstraint = secConstraints[i].getUserDataConstraint();
                TransportGuaranteeType guaranteeType = userConstraint.getTransportGuarantee();
                if (guaranteeType.equals(TransportGuaranteeType.NONE)) {
                    names = null;
                }
                if (names == null) continue;
                for (int j = 0; j < names.length; ++j) {
                    this.securePortlets.add(names[j].getContent());
                }
            }
        }
        this.portletContext = new PortletContextImpl(ctx);
        AuthModuleService authModuleService = (AuthModuleService)PortletServiceFactory.createPortletService(AuthModuleService.class, (boolean)true);
        InputStream is = this.getServletContext().getResourceAsStream("/WEB-INF/authmodules.xml");
        if (is != null) {
            String authModulePath = this.getServletContext().getRealPath("/WEB-INF/authmodules.xml");
            authModuleService.loadAuthModules(authModulePath, Thread.currentThread().getContextClassLoader());
            this.log.info((Object)("loading authentication modules from: " + authModulePath));
        } else {
            this.log.debug((Object)"no auth module descriptor found");
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method = (String)request.getAttribute("org.gridsphere.portlet.portletLifecycleMethod");
        if (method == null) {
            response.sendRedirect("/" + this.configService.getProperty("gridsphere.deploy") + "/" + this.configService.getProperty("gridsphere.context") + "?" + "gs_PageLayout" + "=" + "ErrorLayout" + "&" + "errorPage=unauthorized.jsp");
            return;
        }
        if (method.equals("org.gridsphere.portlet.lifecycle.init")) {
            this.initJSRPortletWebapp();
            if (this.portletWebApp.getWebApplicationStatus().equals((Object)PortletStatus.FAILURE)) {
                return;
            }
            Set<String> set = this.portlets.keySet();
            Iterator<String> it = set.iterator();
            while (it.hasNext()) {
                String portletName = it.next();
                ApplicationPortletImpl appPortlet = (ApplicationPortletImpl)this.portletApps.get(portletName);
                Portlet portlet = this.portlets.get(portletName);
                this.log.debug((Object)("in PortletServlet: service(): Initializing portlet " + portletName));
                PortletDefinition portletDef = this.portletWebApp.getPortletDefinition(portletName);
                PortletConfigImpl portletConfig = new PortletConfigImpl(this.getServletConfig(), portletDef, Thread.currentThread().getContextClassLoader());
                try {
                    portlet.init((PortletConfig)portletConfig);
                    this.portletConfigHash.put(portletName, (PortletConfig)portletConfig);
                }
                catch (Exception e) {
                    appPortlet.setApplicationPortletStatus(PortletStatus.FAILURE);
                    StringWriter sw = new StringWriter();
                    PrintWriter pout = new PrintWriter(sw);
                    e.printStackTrace(pout);
                    appPortlet.setApplicationPortletStatusMessage("Unable to initialize portlet " + portletName + "\n\n" + sw.getBuffer());
                    this.log.error((Object)("in PortletServlet: service(): Unable to INIT portlet " + portletName), (Throwable)e);
                    it.remove();
                    this.portletWebApp.setWebApplicationStatus(PortletStatus.FAILURE);
                    this.portletWebApp.setWebApplicationStatusMessage("Failed to initialize one or more portlets");
                }
            }
            PortletManagerService manager = (PortletManagerService)PortletServiceFactory.createPortletService(PortletManagerService.class, (boolean)true);
            manager.addPortletWebApplication((PortletWebApplication)this.portletWebApp);
            return;
        }
        if (method.equals("org.gridsphere.portlet.lifecycle.destroy")) {
            Iterator<String> it = this.portlets.keySet().iterator();
            while (it.hasNext()) {
                String portletName = it.next();
                Portlet portlet = this.portlets.get(portletName);
                this.log.debug((Object)("in PortletServlet: service(): Destroying portlet " + portletName));
                try {
                    portlet.destroy();
                    it.remove();
                }
                catch (RuntimeException e) {
                    this.log.error((Object)"Caught exception during portlet destroy", (Throwable)e);
                }
            }
            return;
        }
        if (!method.equals("gs_login") && method.equals("gs_logout")) {
            request.getSession(true).invalidate();
        }
        String pid = (String)request.getAttribute("pid");
        String cid = (String)request.getAttribute("cid");
        if (pid == null) {
            pid = request.getParameter("pid");
            if (pid == null) {
                this.log.debug((Object)"in PortletServlet: service(): No PortletID found in request!");
                return;
            }
            request.setAttribute("pid", (Object)pid);
        }
        this.log.debug((Object)("have a portlet id " + pid + " component id= " + cid));
        String portletName = "";
        int idx = pid.indexOf("#");
        Portlet portlet = null;
        portletName = idx > 0 ? pid.substring(idx + 1) : this.portletclasses.get(pid);
        if (portletName == null) {
            this.log.debug((Object)("Check the layout descriptors to make sure the portlet identified as " + pid + " matches with the class and/or portlet name of the portlet.xml"));
            return;
        }
        portlet = this.portlets.get(portletName);
        request.setAttribute("javax.portlet.config", (Object)this.portletConfigHash.get(portletName));
        ApplicationPortlet appPortlet = this.registryService.getApplicationPortlet(pid);
        if (appPortlet == null) {
            this.log.error((Object)("Unable to get portlet from registry identified by: " + pid));
            return;
        }
        User user = (User)request.getAttribute("org.gridsphere.services.core.user.User");
        HashMap<String, String> userInfo = new HashMap<String, String>();
        String userId = null;
        if (user != null) {
            userId = user.getID();
            userInfo.putAll(this.userKeys);
            if (userInfo.containsKey("user.name")) {
                userInfo.put("user.name", user.getUserName());
            }
            if (userInfo.containsKey("user.id")) {
                userInfo.put("user.id", user.getID());
            }
            if (userInfo.containsKey("user.email")) {
                userInfo.put("user.email", user.getEmailAddress());
            }
            if (userInfo.containsKey("user.organization")) {
                userInfo.put("user.organization", user.getOrganization());
            }
            if (userInfo.containsKey("user.lastlogintime")) {
                userInfo.put("user.lastlogintime", String.valueOf(user.getLastLoginTime()));
            }
            if (userInfo.containsKey("user.name.full")) {
                userInfo.put("user.name.full", user.getFullName());
            }
            if (userInfo.containsKey("user.name.first")) {
                userInfo.put("user.name.first", user.getFirstName());
            }
            if (userInfo.containsKey("user.name.last")) {
                userInfo.put("user.name.last", user.getLastName());
            }
            if (userInfo.containsKey("user.timezone")) {
                userInfo.put("user.timezone", (String)user.getAttribute("gridsphere.user.timezone"));
            }
            if (userInfo.containsKey("user.locale")) {
                userInfo.put("user.locale", (String)user.getAttribute("gridsphere.user.locale"));
            }
            if (userInfo.containsKey("user.theme")) {
                userInfo.put("user.theme", (String)user.getAttribute("gridsphere.user.theme"));
            }
            if (userInfo.containsKey("user.login.id")) {
                userInfo.put("user.login.id", user.getUserName());
            }
            Enumeration e = user.getAttributeNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!userInfo.containsKey(key)) continue;
                userInfo.put(key, (String)user.getAttribute(key));
            }
            request.setAttribute("javax.portlet.userinfo", userInfo);
        }
        PortalContext portalContext = appPortlet.getPortalContext();
        request.setAttribute("javax.portlet.context", (Object)portalContext);
        if (portlet == null) {
            this.log.error((Object)("in PortletServlet: service(): No portlet matching " + pid + " found!"));
            return;
        }
        request.removeAttribute("javax.portlet.SSL_REQUIRED");
        if (this.securePortlets.contains(pid)) {
            request.setAttribute("javax.portlet.SSL_REQUIRED", (Object)"true");
        }
        if (method.equals("org.gridsphere.portlet.lifecycle.service")) {
            String action = (String)request.getAttribute("org.gridsphere.portlet.lifecycle.portletActionMethod");
            if (action != null) {
                this.log.debug((Object)"in PortletServlet: action is not NULL");
                if (action.equals("org.gridsphere.portlet.lifecycle.doTitle")) {
                    RenderRequestImpl renderRequest = new RenderRequestImpl(request, this.portletContext);
                    RenderResponseImpl renderResponse = new RenderResponseImpl(request, response);
                    renderRequest.setAttribute("javax.portlet.request", (Object)renderRequest);
                    renderRequest.setAttribute("javax.portlet.response", (Object)renderResponse);
                    this.log.debug((Object)("in PortletServlet: do title " + pid));
                    try {
                        this.doTitle(portlet, (RenderRequest)renderRequest, (RenderResponse)renderResponse);
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Error during doTitle:", (Throwable)e);
                        request.getSession(true).setAttribute("org.gridsphere.portlet.PortletError" + pid, (Object)new PortletException((Throwable)e));
                    }
                } else if (!action.equals("org.gridsphere.event.WindowEvent") && action.equals("org.gridsphere.portlet.lifecycle.actionPerformed")) {
                    this.log.debug((Object)("in PortletServlet: do processAction " + pid));
                    PortletPreferencesManager prefsManager = appPortlet.getPortletPreferencesManager(pid, userId, false);
                    request.setAttribute("org.gridsphere.portletcontainer.impl.PortletPreferencesManager", (Object)prefsManager);
                    this.processAction(portlet, portalContext, request, response, cid, pid);
                }
            } else {
                PortletPreferencesManager prefsManager = appPortlet.getPortletPreferencesManager(pid, userId, true);
                request.setAttribute("org.gridsphere.portletcontainer.impl.PortletPreferencesManager", (Object)prefsManager);
                this.render(portlet, request, response, pid);
            }
        } else {
            this.log.error((Object)"in PortletServlet: service(): No org.gridsphere.portlet.portletLifecycleMethod found in request!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAction(Portlet portlet, PortalContext portalContext, HttpServletRequest request, HttpServletResponse response, String cid, String pid) throws ServletException {
        block16: {
            ActionRequestImpl actionRequest = new ActionRequestImpl(request, this.portletContext);
            ActionResponseImpl actionResponse = new ActionResponseImpl(request, response);
            String webappname = this.portletWebApp.getWebApplicationName();
            PersistenceManagerRdbms pm = this.pms.getPersistenceManagerRdbms(webappname);
            try {
                if (pm != null) {
                    this.log.debug((Object)("Starting a database transaction for webapp: " + webappname));
                    pm.beginTransaction();
                }
                this.log.debug((Object)("in PortletServlet: action handling portlet " + pid));
                portlet.processAction((ActionRequest)actionRequest, (ActionResponse)actionResponse);
                Map params = actionResponse.getRenderParameters();
                request.setAttribute("rp_" + pid + "_" + cid, (Object)params);
                this.log.debug((Object)("placing render params in session : key= rp_" + pid + "_" + cid));
                this.log.info((Object)"Committing the database transaction");
                if (pm != null) {
                    pm.endTransaction();
                }
            }
            catch (Throwable ex) {
                request.setAttribute("org.gridsphere.portlet.PortletError" + pid, (Object)ex);
                if (pm == null) break block16;
                pm.endTransaction();
                try {
                    if (pm != null) {
                        pm.rollbackTransaction();
                    }
                }
                catch (Throwable rbEx) {
                    this.log.error((Object)"Could not rollback transaction after exception!", rbEx.getCause());
                }
            }
            finally {
                try {
                    this.redirect(request, response, (ActionRequest)actionRequest, (ActionResponse)actionResponse, portalContext);
                }
                catch (IOException e) {
                    this.log.error((Object)"Unable to handle redirect", (Throwable)e);
                }
            }
        }
    }

    protected void render(Portlet portlet, HttpServletRequest request, HttpServletResponse response, String pid) throws ServletException {
        RenderRequestImpl renderRequest = new RenderRequestImpl(request, this.portletContext);
        RenderResponseImpl renderResponse = new RenderResponseImpl(request, response);
        renderRequest.setAttribute("javax.portlet.request", (Object)renderRequest);
        renderRequest.setAttribute("javax.portlet.response", (Object)renderResponse);
        this.log.debug((Object)("in PortletServlet: rendering  portlet " + pid));
        if (renderRequest.getAttribute("org.gridsphere.RESPONSE_COMMITTED") == null) {
            String webappname = this.portletWebApp.getWebApplicationName();
            PersistenceManagerRdbms pm = this.pms.getPersistenceManagerRdbms(webappname);
            try {
                if (pm != null) {
                    pm.beginTransaction();
                }
                portlet.render((RenderRequest)renderRequest, (RenderResponse)renderResponse);
                if (pm != null) {
                    pm.endTransaction();
                }
            }
            catch (UnavailableException e) {
                try {
                    portlet.destroy();
                }
                catch (Exception d) {
                    this.log.error((Object)"in PortletServlet(): destroy caught exception: ", (Throwable)d);
                }
            }
            catch (Throwable ex) {
                try {
                    if (pm != null) {
                        this.log.info((Object)("Committing database transaction for webapp: " + this.portletWebApp.getWebApplicationName()));
                        pm.endTransaction();
                        pm.rollbackTransaction();
                    }
                }
                catch (Throwable rbEx) {
                    throw new ServletException("Could not rollback transaction after exception!", rbEx);
                }
                throw new ServletException(ex);
            }
        }
    }

    protected void doTitle(Portlet portlet, RenderRequest request, RenderResponse response) throws IOException, PortletException {
        Portlet por = portlet;
        if (por instanceof GenericPortlet) {
            GenericPortlet genPortlet = (GenericPortlet)portlet;
            if (genPortlet.getPortletConfig() == null) {
                throw new PortletException("Unable to get PortletConfig from Portlet");
            }
            ResourceBundle resBundle = genPortlet.getPortletConfig().getResourceBundle(request.getLocale());
            String title = resBundle.getString("javax.portlet.title");
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println(title);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        super.doGet(req, res);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        super.doPut(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        super.doPost(req, res);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        super.doTrace(req, res);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        super.doDelete(req, res);
    }

    protected void redirect(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ActionRequest actionRequest, ActionResponse actionResponse, PortalContext portalContext) throws IOException {
        if (actionResponse instanceof ActionResponseImpl) {
            ActionResponseImpl aResponse = (ActionResponseImpl)actionResponse;
            String location = aResponse.getRedirectLocation();
            if (location != null) {
                HttpServletResponse redirectResponse = servletResponse;
                while (redirectResponse instanceof HttpServletResponseWrapper) {
                    redirectResponse = (HttpServletResponse)((HttpServletResponseWrapper)redirectResponse).getResponse();
                }
                this.log.debug((Object)("redirecting to location= " + location));
                servletRequest.setAttribute("org.gridsphere.PORTAL_REDIRECT_PATH", (Object)location);
            } else {
                PortletURLImpl url = new PortletURLImpl(servletRequest, servletResponse, true);
                Map params = aResponse.getRenderParameters();
                url.setParameters(params);
                servletRequest.setAttribute("org.gridsphere.PORTAL_REDIRECT_PATH", (Object)url.toString());
            }
        }
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        this.log.debug((Object)("attributeAdded('" + event.getSession().getId() + "', '" + event.getName() + "', '" + event.getValue() + "')"));
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        this.log.debug((Object)("attributeRemoved('" + event.getSession().getId() + "', '" + event.getName() + "', '" + event.getValue() + "')"));
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        this.log.debug((Object)("attributeReplaced('" + event.getSession().getId() + "', '" + event.getName() + "', '" + event.getValue() + "')"));
    }

    public void sessionCreated(HttpSessionEvent event) {
        this.log.debug((Object)("in PS sessionCreated('" + event.getSession().getId() + "')"));
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        this.log.debug((Object)("in PS sessionDestroyed('" + event.getSession().getId() + "')"));
    }

    public void sessionDidActivate(HttpSessionEvent event) {
        this.log.debug((Object)("sessionDidActivate('" + event.getSession().getId() + "')"));
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        this.log.debug((Object)("sessionWillPassivate('" + event.getSession().getId() + "')"));
    }
}

