/*
 * Decompiled with CFR 0.152.
 */
package org.gridsphere.services.core.charts;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.gridsphere.services.core.charts.DefaultCategoryDataset;
import org.gridsphere.services.core.charts.DefaultPieDataset;
import org.gridsphere.services.core.charts.Duration;
import org.gridsphere.services.core.charts.Item;
import org.gridsphere.services.core.charts.Series;
import org.gridsphere.services.core.charts.Subtask;
import org.gridsphere.services.core.charts.Task;
import org.gridsphere.services.core.charts.TaskSeries;
import org.gridsphere.services.core.charts.TaskSeriesCollection;
import org.gridsphere.services.core.charts.TimeSeries;
import org.gridsphere.services.core.charts.TimeSeriesCollection;
import org.gridsphere.services.core.charts.TimeSeriesItem;
import org.gridsphere.services.core.charts.XYSeries;
import org.gridsphere.services.core.charts.XYSeriesCollection;
import org.gridsphere.services.core.charts.XYSeriesItem;
import org.jfree.data.SeriesException;
import org.jfree.data.time.Day;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;

public class DatasetUtilities {
    public static org.jfree.data.DefaultPieDataset readDefaultPieDataset(File file) throws IOException, MarshalException, ValidationException {
        FileReader reader = new FileReader(file);
        DefaultPieDataset dataset = (DefaultPieDataset)DefaultPieDataset.unmarshal((Reader)reader);
        reader.close();
        org.jfree.data.DefaultPieDataset outDataset = new org.jfree.data.DefaultPieDataset();
        for (int i = 0; i < dataset.getItemCount(); ++i) {
            Item item = dataset.getItem(i);
            if (item.getValue() != null) {
                outDataset.setValue((Comparable)((Object)item.getKey()), Double.parseDouble(item.getValue()));
                continue;
            }
            outDataset.setValue((Comparable)((Object)item.getKey()), null);
        }
        return outDataset;
    }

    public static void writeDefaultPieDataset(File file, org.jfree.data.DefaultPieDataset inDataset) throws IOException, MarshalException, ValidationException {
        DefaultPieDataset dataset = new DefaultPieDataset();
        List keys = inDataset.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            Number value = inDataset.getValue((Comparable)((Object)key));
            Item item = new Item();
            item.setKey(key);
            if (value != null) {
                item.setValue(value.toString());
            }
            dataset.addItem(item);
        }
        FileWriter output = new FileWriter(file);
        dataset.marshal((Writer)output);
        output.flush();
        output.close();
    }

    public static org.jfree.data.DefaultCategoryDataset readDefaultCategoryDataset(File file) throws IOException, MarshalException, ValidationException {
        FileReader reader = new FileReader(file);
        DefaultCategoryDataset dataset = (DefaultCategoryDataset)DefaultCategoryDataset.unmarshal((Reader)reader);
        reader.close();
        org.jfree.data.DefaultCategoryDataset outDataset = new org.jfree.data.DefaultCategoryDataset();
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            Series serie = dataset.getSeries(i);
            for (int j = 0; j < serie.getItemCount(); ++j) {
                Item item = serie.getItem(j);
                if (item.getValue() != null) {
                    outDataset.addValue(Double.parseDouble(item.getValue()), (Comparable)((Object)serie.getName()), (Comparable)((Object)item.getKey()));
                    continue;
                }
                outDataset.addValue(null, (Comparable)((Object)serie.getName()), (Comparable)((Object)item.getKey()));
            }
        }
        return outDataset;
    }

    public static void writeDefaultCategoryDataset(File file, org.jfree.data.DefaultCategoryDataset inDataset) throws IOException, MarshalException, ValidationException {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        List rowKeys = inDataset.getRowKeys();
        List columnKeys = inDataset.getColumnKeys();
        for (int i = 0; i < rowKeys.size(); ++i) {
            String rowKey = (String)rowKeys.get(i);
            Series series = new Series();
            series.setName(rowKey);
            for (int j = 0; j < columnKeys.size(); ++j) {
                String columnKey = (String)columnKeys.get(j);
                Number value = inDataset.getValue((Comparable)((Object)rowKey), (Comparable)((Object)columnKey));
                Item item = new Item();
                item.setKey(columnKey);
                if (value != null) {
                    item.setValue(value.toString());
                }
                series.addItem(item);
            }
            dataset.addSeries(series);
        }
        FileWriter output = new FileWriter(file);
        dataset.marshal((Writer)output);
        output.flush();
        output.close();
    }

    public static org.jfree.data.XYSeriesCollection readXYSeriesCollection(File file) throws IOException, ValidationException, MarshalException {
        FileReader reader = new FileReader(file);
        XYSeriesCollection dataset = (XYSeriesCollection)XYSeriesCollection.unmarshal((Reader)reader);
        reader.close();
        org.jfree.data.XYSeriesCollection outDataset = new org.jfree.data.XYSeriesCollection();
        if (dataset.hasIntervalWidth()) {
            outDataset.setIntervalWidth(dataset.getIntervalWidth());
        }
        if (dataset.hasIntervalPositionFactor()) {
            outDataset.setIntervalPositionFactor(dataset.getIntervalPositionFactor());
        }
        if (dataset.hasAutoWidth()) {
            outDataset.setAutoWidth(dataset.getAutoWidth());
        }
        Enumeration series = dataset.enumerateXYSeries();
        while (series.hasMoreElements()) {
            XYSeries serie = (XYSeries)series.nextElement();
            org.jfree.data.XYSeries outSeries = new org.jfree.data.XYSeries(serie.getName());
            if (serie.hasMaximumItemCount()) {
                outSeries.setMaximumItemCount(serie.getMaximumItemCount());
            }
            if (serie.getDescription() != null) {
                outSeries.setDescription(serie.getDescription());
            }
            for (int i = 0; i < serie.getXYSeriesItemCount(); ++i) {
                XYSeriesItem item = serie.getXYSeriesItem(i);
                if (item.hasYValue()) {
                    outSeries.add(item.getXValue(), item.getYValue());
                    continue;
                }
                outSeries.add(item.getXValue(), null);
            }
            outDataset.addSeries(outSeries);
        }
        return outDataset;
    }

    public static void writeXYSeriesCollection(File file, org.jfree.data.XYSeriesCollection inDataset) throws IOException, MarshalException, ValidationException {
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.setIntervalWidth(inDataset.getIntervalWidth());
        dataset.setIntervalPositionFactor(inDataset.getIntervalPositionFactor());
        dataset.setAutoWidth(inDataset.isAutoWidth());
        for (int i = 0; i < inDataset.getSeriesCount(); ++i) {
            String name = inDataset.getSeriesName(i);
            String description = inDataset.getSeries(i).getDescription();
            int maximumItemCount = inDataset.getSeries(i).getMaximumItemCount();
            XYSeries series = new XYSeries();
            if (description != null) {
                series.setDescription(description);
            }
            if (maximumItemCount != Integer.MAX_VALUE) {
                series.setMaximumItemCount(maximumItemCount);
            }
            series.setName(name);
            for (int j = 0; j < inDataset.getItemCount(i); ++j) {
                XYSeriesItem item = new XYSeriesItem();
                item.setXValue(inDataset.getXValue(i, j).doubleValue());
                if (inDataset.getYValue(i, j) != null) {
                    item.setYValue(inDataset.getYValue(i, j).doubleValue());
                }
                series.addXYSeriesItem(item);
            }
            dataset.addXYSeries(series);
        }
        FileWriter output = new FileWriter(file);
        dataset.marshal((Writer)output);
        output.flush();
        output.close();
    }

    public static org.jfree.data.time.TimeSeriesCollection readTimeSeriesCollection(File file) throws IOException, MarshalException, ValidationException, SeriesException {
        FileReader reader = new FileReader(file);
        TimeSeriesCollection dataset = (TimeSeriesCollection)TimeSeriesCollection.unmarshal((Reader)reader);
        reader.close();
        org.jfree.data.time.TimeSeriesCollection outDataset = new org.jfree.data.time.TimeSeriesCollection();
        String xPosition = dataset.getXPosition();
        if (xPosition != null) {
            outDataset.setXPosition(xPosition.equals("TimePeriodAnchor.START") ? TimePeriodAnchor.START : (xPosition.equals("TimePeriodAnchor.END") ? TimePeriodAnchor.END : TimePeriodAnchor.MIDDLE));
        }
        if (dataset.hasDomainIsPointsInTime()) {
            outDataset.setDomainIsPointsInTime(dataset.getDomainIsPointsInTime());
        }
        Enumeration series = dataset.enumerateTimeSeries();
        while (series.hasMoreElements()) {
            TimeSeries serie = (TimeSeries)series.nextElement();
            org.jfree.data.time.TimeSeries outSeries = null;
            long milliseconds = serie.getTimeSeriesItem(0).getEnd() - serie.getTimeSeriesItem(0).getStart();
            String className = "org.jfree.data.time.";
            if (milliseconds == 999L) {
                outSeries = new org.jfree.data.time.TimeSeries(serie.getName(), Second.class);
                className = className + "Second";
            } else if (milliseconds == 59999L) {
                outSeries = new org.jfree.data.time.TimeSeries(serie.getName(), Minute.class);
                className = className + "Minute";
            } else if (milliseconds == 3599999L) {
                outSeries = new org.jfree.data.time.TimeSeries(serie.getName(), Hour.class);
                className = className + "Hour";
            } else if (milliseconds == 86399999L) {
                outSeries = new org.jfree.data.time.TimeSeries(serie.getName(), Day.class);
                className = className + "Day";
            } else if (milliseconds == 604799999L) {
                outSeries = new org.jfree.data.time.TimeSeries(serie.getName(), Week.class);
                className = className + "Week";
            } else if (2332800000L < milliseconds && milliseconds < 2764800000L) {
                outSeries = new org.jfree.data.time.TimeSeries(serie.getName(), Month.class);
                className = className + "Month";
            } else if (7603200000L < milliseconds && milliseconds < 8035200000L) {
                outSeries = new org.jfree.data.time.TimeSeries(serie.getName(), Quarter.class);
                className = className + "Quarter";
            } else if (31363200000L < milliseconds && milliseconds < 31622400000L) {
                outSeries = new org.jfree.data.time.TimeSeries(serie.getName(), Year.class);
                className = className + "Year";
            } else {
                outSeries = new org.jfree.data.time.TimeSeries(serie.getName(), FixedMillisecond.class);
                className = className + "FixedMillisecond";
            }
            if (serie.hasMaximumItemCount()) {
                outSeries.setMaximumItemCount(serie.getMaximumItemCount());
            }
            if (serie.hasHistoryCount()) {
                outSeries.setHistoryCount(serie.getHistoryCount());
            }
            if (serie.getDescription() != null) {
                outSeries.setDescription(serie.getDescription());
            }
            if (serie.getDomainDescription() != null) {
                outSeries.setDomainDescription(serie.getDomainDescription());
            }
            if (serie.getRangeDescription() != null) {
                outSeries.setRangeDescription(serie.getRangeDescription());
            }
            for (int i = 0; i < serie.getTimeSeriesItemCount(); ++i) {
                TimeSeriesItem item = serie.getTimeSeriesItem(i);
                try {
                    if (item.hasValue()) {
                        outSeries.add((RegularTimePeriod)Class.forName(className).getConstructor(Date.class).newInstance(new Date(item.getStart())), item.getValue());
                        continue;
                    }
                    outSeries.add((RegularTimePeriod)Class.forName(className).getConstructor(Date.class).newInstance(new Date(item.getStart())), null);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
                catch (IllegalAccessException e) {
                    continue;
                }
                catch (InvocationTargetException e) {
                    continue;
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                catch (InstantiationException e) {
                    // empty catch block
                }
            }
            outDataset.addSeries(outSeries);
        }
        return outDataset;
    }

    public static void writeTimeSeriesCollection(File file, org.jfree.data.time.TimeSeriesCollection inDataset) throws IOException, MarshalException, ValidationException {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.setXPosition(inDataset.getXPosition().toString());
        dataset.setDomainIsPointsInTime(inDataset.getDomainIsPointsInTime());
        for (int i = 0; i < inDataset.getSeriesCount(); ++i) {
            org.jfree.data.time.TimeSeries serie = inDataset.getSeries(i);
            String name = serie.getName();
            TimeSeries series = new TimeSeries();
            series.setName(name);
            String description = serie.getDescription();
            String rangeDescription = serie.getRangeDescription();
            String domainDescription = serie.getDomainDescription();
            int maximumItemCount = serie.getMaximumItemCount();
            int historyCount = serie.getHistoryCount();
            if (description != null) {
                series.setDescription(description);
            }
            if (rangeDescription != null) {
                series.setRangeDescription(rangeDescription);
            }
            if (domainDescription != null) {
                series.setDomainDescription(domainDescription);
            }
            if (maximumItemCount != Integer.MAX_VALUE) {
                series.setMaximumItemCount(maximumItemCount);
            }
            if (historyCount != 0) {
                series.setHistoryCount(historyCount);
            }
            for (int j = 0; j < inDataset.getItemCount(i); ++j) {
                TimeSeriesDataItem inItem = serie.getDataItem(j);
                TimeSeriesItem item = new TimeSeriesItem();
                item.setStart(inItem.getPeriod().getStart().getTime());
                item.setEnd(inItem.getPeriod().getEnd().getTime());
                if (inItem.getValue() != null) {
                    item.setValue(inItem.getValue().doubleValue());
                }
                series.addTimeSeriesItem(item);
            }
            dataset.addTimeSeries(series);
        }
        FileWriter output = new FileWriter(file);
        dataset.marshal((Writer)output);
        output.flush();
        output.close();
    }

    public static org.jfree.data.gantt.TaskSeriesCollection readTaskSeriesCollection(File file) throws IOException, MarshalException, ValidationException {
        FileReader reader = new FileReader(file);
        TaskSeriesCollection dataset = (TaskSeriesCollection)TaskSeriesCollection.unmarshal((Reader)reader);
        reader.close();
        org.jfree.data.gantt.TaskSeriesCollection outDataset = new org.jfree.data.gantt.TaskSeriesCollection();
        Enumeration series = dataset.enumerateTaskSeries();
        while (series.hasMoreElements()) {
            TaskSeries serie = (TaskSeries)series.nextElement();
            org.jfree.data.gantt.TaskSeries outSeries = new org.jfree.data.gantt.TaskSeries(serie.getName());
            for (int j = 0; j < serie.getTaskCount(); ++j) {
                Task task = serie.getTask(j);
                org.jfree.data.gantt.Task outTask = new org.jfree.data.gantt.Task(task.getDescription(), new Date(task.getDuration().getStart()), new Date(task.getDuration().getEnd()));
                if (task.hasPercentComplete()) {
                    outTask.setPercentComplete(task.getPercentComplete());
                }
                for (int k = 0; k < task.getSubtaskCount(); ++k) {
                    Subtask subtask = task.getSubtask(k);
                    org.jfree.data.gantt.Task outSubtask = new org.jfree.data.gantt.Task(task.getDescription(), new Date(subtask.getDuration().getStart()), new Date(subtask.getDuration().getEnd()));
                    if (subtask.hasPercentComplete()) {
                        outSubtask.setPercentComplete(subtask.getPercentComplete());
                    }
                    outTask.addSubtask(outSubtask);
                }
                outSeries.add(outTask);
            }
            outDataset.add(outSeries);
        }
        return outDataset;
    }

    public static void writeTaskSeriesCollection(File file, org.jfree.data.gantt.TaskSeriesCollection inDataset) throws IOException, MarshalException, ValidationException {
        TaskSeriesCollection dataset = new TaskSeriesCollection();
        for (int i = 0; i < inDataset.getRowCount(); ++i) {
            String serieName = inDataset.getSeriesName(i);
            TaskSeries series = new TaskSeries();
            series.setName(serieName);
            for (int j = 0; j < inDataset.getColumnCount(); ++j) {
                Task task = new Task();
                task.setDescription((String)((Object)inDataset.getColumnKey(j)));
                for (int k = 0; k < inDataset.getSubIntervalCount(i, j); ++k) {
                    Subtask subtask = new Subtask();
                    subtask.setDescription((String)((Object)inDataset.getColumnKey(j)));
                    if (inDataset.getPercentComplete(i, j, k) != null) {
                        subtask.setPercentComplete(inDataset.getPercentComplete(i, j, k).doubleValue());
                    }
                    Duration duration = new Duration();
                    duration.setStart(inDataset.getStartValue(i, j, k).longValue());
                    duration.setEnd(inDataset.getEndValue(i, j, k).longValue());
                    subtask.setDuration(duration);
                    task.addSubtask(subtask);
                }
                if (inDataset.getPercentComplete(i, j) != null) {
                    task.setPercentComplete(inDataset.getPercentComplete(i, j).doubleValue());
                }
                Duration duration = new Duration();
                duration.setStart(inDataset.getStartValue(i, j).longValue());
                duration.setEnd(inDataset.getEndValue(i, j).longValue());
                task.setDuration(duration);
                series.addTask(task);
            }
            dataset.addTaskSeries(series);
        }
        FileWriter output = new FileWriter(file);
        dataset.marshal((Writer)output);
        output.flush();
        output.close();
    }
}

