/*
 * Decompiled with CFR 0.152.
 */
package org.globus.cog.abstraction.impl.file.gridftp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.globus.cog.abstraction.impl.common.task.InvalidSecurityContextException;
import org.globus.cog.abstraction.impl.file.DirectoryNotFoundException;
import org.globus.cog.abstraction.impl.file.GeneralException;
import org.globus.cog.abstraction.impl.file.GridFileImpl;
import org.globus.cog.abstraction.impl.file.IllegalHostException;
import org.globus.cog.abstraction.impl.file.UnixPermissionsImpl;
import org.globus.cog.abstraction.interfaces.GridFile;
import org.globus.cog.abstraction.interfaces.Permissions;
import org.globus.cog.abstraction.interfaces.SecurityContext;
import org.globus.cog.abstraction.interfaces.ServiceContact;
import org.globus.ftp.MlsxEntry;

public class FileResourceImpl
extends org.globus.cog.abstraction.impl.file.gridftp.old.FileResourceImpl {
    private boolean old;

    public FileResourceImpl() throws Exception {
    }

    public FileResourceImpl(String name, ServiceContact serviceContact, SecurityContext securityContext) {
        super(name, serviceContact, securityContext);
    }

    public void start() throws IllegalHostException, InvalidSecurityContextException, GeneralException {
        super.start();
        try {
            this.getGridFTPClient().quote("HELP MLSD");
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("Unknown command MLSD") != -1) {
                this.old = true;
            }
            throw new GeneralException("Unexpected exception caught while querying server capabilities", (Throwable)e);
        }
    }

    public Collection list() throws GeneralException {
        if (this.old) {
            return super.list();
        }
        try {
            this.getGridFTPClient().setPassiveMode(true);
            Vector v = this.getGridFTPClient().mlsd();
            ArrayList<GridFile> list = new ArrayList<GridFile>();
            Iterator i = v.iterator();
            while (i.hasNext()) {
                list.add(this.convertEntry((MlsxEntry)i.next()));
            }
            return list;
        }
        catch (Exception e) {
            throw new GeneralException("Could not get list of files from server", (Throwable)e);
        }
    }

    private GridFile convertEntry(MlsxEntry entry) {
        GridFileImpl gfi = new GridFileImpl();
        gfi.setName(entry.getFileName());
        String perm = entry.get("unix.mode");
        if (perm != null) {
            gfi.setUserPermissions((Permissions)new UnixPermissionsImpl(perm.charAt(1)));
            gfi.setGroupPermissions((Permissions)new UnixPermissionsImpl(perm.charAt(2)));
            gfi.setAllPermissions((Permissions)new UnixPermissionsImpl(perm.charAt(3)));
        }
        gfi.setLastModified(entry.get("modify"));
        gfi.setSize(Long.parseLong(entry.get("size")));
        String type = entry.get("type");
        if ("dir".equals(type)) {
            gfi.setFileType((byte)2);
        } else if ("file".equals(type)) {
            gfi.setFileType((byte)1);
        } else if ("pdir".equals(type)) {
            gfi.setFileType((byte)2);
        } else if ("pdir".equals(type)) {
            gfi.setFileType((byte)2);
        } else {
            gfi.setFileType((byte)0);
        }
        return gfi;
    }

    public Collection list(String directory) throws DirectoryNotFoundException, GeneralException {
        if (this.old) {
            return super.list(directory);
        }
        try {
            this.getGridFTPClient().setPassiveMode(true);
            Vector v = this.getGridFTPClient().mlsd(directory);
            ArrayList<GridFile> list = new ArrayList<GridFile>();
            Iterator i = v.iterator();
            while (i.hasNext()) {
                list.add(this.convertEntry((MlsxEntry)i.next()));
            }
            return list;
        }
        catch (Exception e) {
            throw new GeneralException("Could not get list of files in " + directory + "from server", (Throwable)e);
        }
    }

    public boolean isDirectory(String dirName) throws GeneralException {
        if (this.old) {
            return super.isDirectory(dirName);
        }
        try {
            this.getGridFTPClient().setPassiveMode(false);
            MlsxEntry me = this.getGridFTPClient().mlst(dirName);
            return me.get("type").endsWith("dir");
        }
        catch (Exception e) {
            throw new GeneralException(e.getMessage(), (Throwable)e);
        }
    }
}

