/*
 * Decompiled with CFR 0.152.
 */
package org.globus.cog.abstraction.impl.file.ftp;

import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.globus.cog.abstraction.impl.common.AbstractionFactory;
import org.globus.cog.abstraction.impl.common.IdentityImpl;
import org.globus.cog.abstraction.impl.common.task.IllegalSpecException;
import org.globus.cog.abstraction.impl.common.task.InvalidSecurityContextException;
import org.globus.cog.abstraction.impl.common.task.ServiceContactImpl;
import org.globus.cog.abstraction.impl.common.task.TaskSubmissionException;
import org.globus.cog.abstraction.impl.file.DirectoryNotFoundException;
import org.globus.cog.abstraction.impl.file.FileNotFoundException;
import org.globus.cog.abstraction.impl.file.GeneralException;
import org.globus.cog.abstraction.impl.file.GridFileImpl;
import org.globus.cog.abstraction.impl.file.IllegalHostException;
import org.globus.cog.abstraction.interfaces.ExecutableObject;
import org.globus.cog.abstraction.interfaces.FileResource;
import org.globus.cog.abstraction.interfaces.GridFile;
import org.globus.cog.abstraction.interfaces.Identity;
import org.globus.cog.abstraction.interfaces.Permissions;
import org.globus.cog.abstraction.interfaces.SecurityContext;
import org.globus.cog.abstraction.interfaces.ServiceContact;
import org.globus.ftp.FTPClient;
import org.globus.ftp.FileInfo;
import org.globus.ftp.exception.ServerException;

public class FileResourceImpl
implements FileResource {
    private ServiceContact serviceContact;
    private final String protocol = "ftp";
    private SecurityContext securityContext;
    private FTPClient ftpClient;
    private String name = null;
    private Identity identity = new IdentityImpl();
    private final int type = 1;
    private Hashtable attributes = null;
    static Logger logger = Logger.getLogger((String)(class$org$globus$cog$abstraction$interfaces$FileResource == null ? (class$org$globus$cog$abstraction$interfaces$FileResource = FileResourceImpl.class$("org.globus.cog.abstraction.interfaces.FileResource")) : class$org$globus$cog$abstraction$interfaces$FileResource).getName());
    private boolean started;
    static /* synthetic */ Class class$org$globus$cog$abstraction$interfaces$FileResource;

    public FileResourceImpl() throws Exception {
        this.attributes = new Hashtable();
        this.serviceContact = new ServiceContactImpl();
        this.securityContext = AbstractionFactory.newSecurityContext((String)"FTP");
    }

    public FileResourceImpl(String name, ServiceContact serviceContact, SecurityContext securityContext) {
        this.name = name;
        this.serviceContact = serviceContact;
        this.securityContext = securityContext;
        this.attributes = new Hashtable();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setServiceContact(ServiceContact serviceContact) {
        this.serviceContact = serviceContact;
    }

    public ServiceContact getServiceContact() {
        return this.serviceContact;
    }

    public void setIdentity(Identity identity) {
        this.identity = identity;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public int getType() {
        return this.type;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void start() throws IllegalHostException, InvalidSecurityContextException, GeneralException {
        try {
            String host = this.serviceContact.getHost();
            int port = this.serviceContact.getPort();
            if (port == -1) {
                port = 21;
            }
            this.ftpClient = new FTPClient(host, port);
            PasswordAuthentication credentials = (PasswordAuthentication)this.securityContext.getCredentials();
            String username = credentials.getUserName();
            String password = String.valueOf(credentials.getPassword());
            this.ftpClient.authorize(username, password);
            this.ftpClient.setType(1);
            this.started = true;
        }
        catch (ServerException se) {
            throw new IllegalHostException("Error while communicating with the FTP server", (Throwable)se);
        }
        catch (Exception e) {
            throw new GeneralException("Cannot connect to the FTP server", (Throwable)e);
        }
    }

    public void stop() throws GeneralException {
        try {
            this.ftpClient.close();
            this.started = false;
        }
        catch (Exception e) {
            throw new GeneralException("Error while stopping the FTP server", (Throwable)e);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setCurrentDirectory(String directory) throws DirectoryNotFoundException, GeneralException {
        try {
            this.ftpClient.changeDir(directory);
        }
        catch (IOException ie) {
            throw new DirectoryNotFoundException(directory + " is not a valid directory", (Throwable)ie);
        }
        catch (Exception e) {
            throw new GeneralException("Cannot set the current directory", (Throwable)e);
        }
    }

    public String getCurrentDirectory() throws GeneralException {
        try {
            return this.ftpClient.getCurrentDir();
        }
        catch (Exception e) {
            throw new GeneralException("Cannot get the current directory", (Throwable)e);
        }
    }

    public Collection list() throws GeneralException {
        Vector<GridFile> gridFileList = new Vector<GridFile>();
        try {
            this.ftpClient.setPassive();
            this.ftpClient.setLocalActive();
            this.ftpClient.setType(2);
            Enumeration list = this.ftpClient.list().elements();
            this.ftpClient.setType(1);
            while (list.hasMoreElements()) {
                gridFileList.add(this.createGridFile(list.nextElement()));
            }
            return gridFileList;
        }
        catch (Exception e) {
            throw new GeneralException("Cannot list the elements of the current directory", (Throwable)e);
        }
    }

    public Collection list(String directory) throws DirectoryNotFoundException, GeneralException {
        String currentDirectory = this.getCurrentDirectory();
        this.setCurrentDirectory(directory);
        Collection list = null;
        try {
            this.ftpClient.setType(2);
            list = this.list();
            this.ftpClient.setType(1);
        }
        catch (Exception e) {
            throw new GeneralException("Error in list directory", (Throwable)e);
        }
        this.setCurrentDirectory(currentDirectory);
        return list;
    }

    public void createDirectory(String directory) throws GeneralException {
        try {
            this.ftpClient.makeDir(directory);
        }
        catch (Exception e) {
            throw new GeneralException("Cannot create the directory", (Throwable)e);
        }
    }

    public void deleteDirectory(String directory, boolean force) throws DirectoryNotFoundException, GeneralException {
        GridFile gridFile = null;
        if (!this.isDirectory(directory)) {
            throw new DirectoryNotFoundException(directory + " is not a valid directory");
        }
        try {
            if (force) {
                Iterator iterator = this.list(directory).iterator();
                while (iterator.hasNext()) {
                    gridFile = (GridFile)iterator.next();
                    if (gridFile.isFile()) {
                        this.ftpClient.deleteFile(directory + "/" + gridFile.getName());
                        continue;
                    }
                    this.deleteDirectory(directory + "/" + gridFile.getName(), force);
                }
            }
            if (!this.list(directory).iterator().hasNext()) {
                this.ftpClient.deleteDir(directory);
            }
        }
        catch (Exception e) {
            throw new GeneralException("Cannot delete the given directory", (Throwable)e);
        }
    }

    public void deleteFile(String file) throws FileNotFoundException, GeneralException {
        try {
            this.ftpClient.deleteFile(file);
        }
        catch (IOException ie) {
            throw new FileNotFoundException(file + " is not a valid file", (Throwable)ie);
        }
        catch (Exception e) {
            throw new GeneralException("Cannot delete the given file", (Throwable)e);
        }
    }

    public void getFile(String remoteFilename, String localFileName) throws FileNotFoundException, GeneralException {
        String currentDirectory = this.getCurrentDirectory();
        File localFile = new File(localFileName);
        try {
            this.ftpClient.setPassive();
            this.ftpClient.setLocalActive();
            this.ftpClient.get(remoteFilename, localFile);
        }
        catch (Exception e) {
            try {
                this.start();
                this.setCurrentDirectory(currentDirectory);
            }
            catch (Exception ge) {
                throw new GeneralException("get Failed. Connection closed", (Throwable)ge);
            }
            throw new GeneralException("Cannot retrieve the given file", (Throwable)e);
        }
    }

    public void putFile(String localFileName, String remoteFileName) throws FileNotFoundException, GeneralException {
        String currentDirectory = this.getCurrentDirectory();
        File localFile = new File(localFileName);
        try {
            this.ftpClient.setPassive();
            this.ftpClient.setLocalActive();
            this.ftpClient.put(localFile, remoteFileName, false);
        }
        catch (Exception e) {
            try {
                this.start();
                this.setCurrentDirectory(currentDirectory);
            }
            catch (Exception ge) {
                throw new GeneralException("put Failed. Connection closed", (Throwable)ge);
            }
            throw new GeneralException("Cannot transfer the given file", (Throwable)e);
        }
    }

    public void getDirectory(String remoteDirName, String localDirName) throws DirectoryNotFoundException, GeneralException {
        File localDir = new File(localDirName);
        GridFile gridFile = null;
        if (!localDir.exists()) {
            localDir.mkdir();
        }
        if (!this.isDirectory(remoteDirName)) {
            throw new DirectoryNotFoundException("Remote directory not found");
        }
        Iterator iterator = this.list(remoteDirName).iterator();
        while (iterator.hasNext()) {
            gridFile = (GridFile)iterator.next();
            try {
                if (gridFile.isFile()) {
                    this.getFile(remoteDirName + "/" + gridFile.getName(), localDirName + File.separator + gridFile.getName());
                    continue;
                }
                this.getDirectory(remoteDirName + "/" + gridFile.getName(), localDirName + File.separator + gridFile.getName());
            }
            catch (Exception ie) {
                throw new GeneralException("Cannot transfer directory", (Throwable)ie);
            }
        }
    }

    public void putDirectory(String localDirName, String remoteDirName) throws DirectoryNotFoundException, GeneralException {
        File localDir = new File(localDirName);
        if (!localDir.exists()) {
            throw new DirectoryNotFoundException("Local directory not found");
        }
        if (localDir.isFile()) {
            throw new DirectoryNotFoundException(localDirName + "  is a file");
        }
        try {
            if (!this.exists(remoteDirName)) {
                this.createDirectory(remoteDirName);
            }
        }
        catch (FileNotFoundException fe) {
            throw new DirectoryNotFoundException("Cannot create the remote directory: " + remoteDirName);
        }
        if (!this.isDirectory(remoteDirName)) {
            throw new DirectoryNotFoundException(remoteDirName + " is a file");
        }
        String[] files = localDir.list();
        for (int index = 0; index < files.length; ++index) {
            File localFile = new File(localDirName + File.separator + files[index]);
            try {
                if (!localFile.isDirectory()) {
                    this.putFile(localDirName + File.separator + files[index], remoteDirName + "/" + files[index]);
                    continue;
                }
                this.putDirectory(localDirName + File.separator + files[index], remoteDirName + "/" + files[index]);
                continue;
            }
            catch (Exception e) {
                throw new GeneralException("Cannot transfer the directory", (Throwable)e);
            }
        }
    }

    public void getMultipleFiles(String[] remoteFileNames, String[] localFileNames) throws FileNotFoundException, GeneralException {
        if (localFileNames.length != remoteFileNames.length) {
            throw new GeneralException("Number of source and destination file names has to be the same");
        }
        for (int index = 0; index < remoteFileNames.length; ++index) {
            try {
                if (!this.exists(remoteFileNames[index])) continue;
                if (!this.isDirectory(remoteFileNames[index])) {
                    this.getFile(remoteFileNames[index], localFileNames[index]);
                    continue;
                }
                this.getDirectory(remoteFileNames[index], localFileNames[index]);
                continue;
            }
            catch (Exception e) {
                throw new GeneralException("Cannot perform mGet", (Throwable)e);
            }
        }
    }

    public void getMultipleFiles(String[] remoteFileNames, String localDirName) throws FileNotFoundException, DirectoryNotFoundException, GeneralException {
        for (int index = 0; index < remoteFileNames.length; ++index) {
            try {
                String remoteFileName = remoteFileNames[index].substring(remoteFileNames[index].lastIndexOf("/") + 1);
                if (!this.exists(remoteFileNames[index])) continue;
                if (!this.isDirectory(remoteFileNames[index])) {
                    this.getFile(remoteFileNames[index], localDirName + File.separator + remoteFileName);
                    continue;
                }
                this.getDirectory(remoteFileNames[index], localDirName + File.separator + remoteFileName);
                continue;
            }
            catch (Exception e) {
                throw new GeneralException("Cannot perform mGet", (Throwable)e);
            }
        }
    }

    public void putMultipleFiles(String[] localFileNames, String[] remoteFileNames) throws FileNotFoundException, GeneralException {
        if (localFileNames.length != remoteFileNames.length) {
            throw new GeneralException("Number of source and destination file names has to be the same");
        }
        for (int index = 0; index < localFileNames.length; ++index) {
            File localFile = new File(localFileNames[index]);
            try {
                if (!localFile.isDirectory()) {
                    this.putFile(localFileNames[index], remoteFileNames[index]);
                    continue;
                }
                this.putDirectory(localFileNames[index], remoteFileNames[index]);
                continue;
            }
            catch (Exception e) {
                throw new GeneralException("Cannot perform mput", (Throwable)e);
            }
        }
    }

    public void putMultipleFiles(String[] localFileNames, String remoteDirName) throws FileNotFoundException, DirectoryNotFoundException, GeneralException {
        for (int index = 0; index < localFileNames.length; ++index) {
            File localFile = new File(localFileNames[index]);
            try {
                if (!localFile.isDirectory()) {
                    this.putFile(localFileNames[index], remoteDirName + "/" + localFile.getName());
                    continue;
                }
                this.putDirectory(localFileNames[index], remoteDirName + "/" + localFile.getName());
                continue;
            }
            catch (Exception e) {
                throw new GeneralException("Cannot perform mput", (Throwable)e);
            }
        }
    }

    public void rename(String remoteFileName1, String remoteFileName2) throws FileNotFoundException, GeneralException {
        try {
            this.ftpClient.rename(remoteFileName1, remoteFileName2);
        }
        catch (IOException ie) {
            throw new FileNotFoundException("File not found or cannot be renamed", (Throwable)ie);
        }
        catch (Exception e) {
            throw new GeneralException("Rename for ftp failed", (Throwable)e);
        }
    }

    public void changeMode(String filename, int mode) throws FileNotFoundException, GeneralException {
        String cmd = "chmod " + mode + " " + filename;
        try {
            this.ftpClient.site(cmd);
        }
        catch (IOException ie) {
            throw new FileNotFoundException("File " + filename + " is not a valid file", (Throwable)ie);
        }
        catch (Exception e) {
            throw new GeneralException("Cannot change the file permissions", (Throwable)e);
        }
    }

    public GridFile getGridFile(String fileName) throws FileNotFoundException, GeneralException {
        try {
            String directory = null;
            int endIndex = fileName.lastIndexOf("/");
            if (endIndex < 0) {
                directory = this.getCurrentDirectory();
            } else {
                directory = fileName.substring(0, endIndex);
                fileName = fileName.substring(endIndex + 1, fileName.length());
            }
            Collection gridFiles = this.list(directory);
            Iterator iterator = gridFiles.iterator();
            while (iterator.hasNext()) {
                GridFile gridFile = (GridFile)iterator.next();
                if (!gridFile.getName().equals(fileName)) continue;
                return gridFile;
            }
        }
        catch (Exception e) {
            throw new GeneralException("Error in getGridFile ", (Throwable)e);
        }
        return null;
    }

    public void changeMode(GridFile newGridFile) throws FileNotFoundException, GeneralException {
        String newPermissions = newGridFile.getUserPermissions().toString() + newGridFile.getGroupPermissions().toString() + newGridFile.getAllPermissions().toString();
        logger.error((Object)newGridFile.getAbsolutePathName());
        this.changeMode(newGridFile.getAbsolutePathName(), Integer.parseInt(newPermissions));
    }

    public boolean exists(String filename) throws FileNotFoundException, GeneralException {
        try {
            return this.ftpClient.exists(filename);
        }
        catch (IOException ie) {
            throw new FileNotFoundException("File " + filename + " is not a valid file", (Throwable)ie);
        }
        catch (Exception e) {
            throw new GeneralException("Cannot determine the existence of the file", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectory(String dirName) throws GeneralException {
        boolean isDir = true;
        String currentDirectory = this.getCurrentDirectory();
        try {
            this.setCurrentDirectory(dirName);
        }
        catch (Exception e) {
            isDir = false;
        }
        finally {
            try {
                this.setCurrentDirectory(currentDirectory);
            }
            catch (Exception e) {}
        }
        return isDir;
    }

    public void submit(ExecutableObject commandWorkflow) throws IllegalSpecException, TaskSubmissionException {
        throw new TaskSubmissionException("Cannot perform submit. Operation not implemented for ftp");
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Enumeration getAllAttributes() {
        return this.attributes.elements();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    private GridFile createGridFile(Object obj) throws GeneralException {
        GridFileImpl gridFile = new GridFileImpl();
        FileInfo fileInfo = (FileInfo)obj;
        String directory = this.getCurrentDirectory();
        if (directory.endsWith("/")) {
            gridFile.setAbsolutePathName(directory + fileInfo.getName());
        } else {
            gridFile.setAbsolutePathName(directory + "/" + fileInfo.getName());
        }
        gridFile.setLastModified(fileInfo.getDate());
        if (fileInfo.isFile()) {
            gridFile.setFileType((byte)1);
        }
        if (fileInfo.isDirectory()) {
            gridFile.setFileType((byte)2);
        }
        if (fileInfo.isDevice()) {
            gridFile.setFileType((byte)4);
        }
        if (fileInfo.isSoftLink()) {
            gridFile.setFileType((byte)3);
        }
        gridFile.setMode(fileInfo.getModeAsString());
        gridFile.setName(fileInfo.getName());
        gridFile.setSize(fileInfo.getSize());
        Permissions userPermissions = gridFile.getUserPermissions();
        Permissions groupPermissions = gridFile.getGroupPermissions();
        Permissions allPermissions = gridFile.getAllPermissions();
        userPermissions.setRead(fileInfo.userCanRead());
        userPermissions.setWrite(fileInfo.userCanWrite());
        userPermissions.setExecute(fileInfo.userCanExecute());
        groupPermissions.setRead(fileInfo.groupCanRead());
        groupPermissions.setWrite(fileInfo.groupCanWrite());
        groupPermissions.setExecute(fileInfo.groupCanExecute());
        allPermissions.setRead(fileInfo.allCanRead());
        allPermissions.setWrite(fileInfo.allCanWrite());
        allPermissions.setExecute(fileInfo.allCanExecute());
        gridFile.setUserPermissions(userPermissions);
        gridFile.setGroupPermissions(groupPermissions);
        gridFile.setAllPermissions(allPermissions);
        return gridFile;
    }

    private void removeLocalDirectory(String tempDirName) {
        File tempFile = new File(tempDirName);
        String[] fileNames = tempFile.list();
        if (fileNames != null) {
            for (int i = 0; i < fileNames.length; ++i) {
                File newFile = new File(tempDirName + File.separator + fileNames[i]);
                if (newFile.isFile()) {
                    newFile.delete();
                    continue;
                }
                this.removeLocalDirectory(newFile.getAbsolutePath());
            }
        }
        tempFile.delete();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

