/*
 * Decompiled with CFR 0.152.
 */
package org.globus.cog.abstraction.impl.execution.gt2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import org.globus.cog.abstraction.impl.common.StatusEvent;
import org.globus.cog.abstraction.impl.common.task.ActiveTaskException;
import org.globus.cog.abstraction.impl.common.task.IllegalSpecException;
import org.globus.cog.abstraction.impl.common.task.InvalidSecurityContextException;
import org.globus.cog.abstraction.impl.common.task.InvalidServiceContactException;
import org.globus.cog.abstraction.impl.common.task.TaskSubmissionException;
import org.globus.cog.abstraction.impl.execution.gt2.DelegatedTaskHandlerFactory;
import org.globus.cog.abstraction.interfaces.DelegatedTaskHandler;
import org.globus.cog.abstraction.interfaces.Status;
import org.globus.cog.abstraction.interfaces.StatusListener;
import org.globus.cog.abstraction.interfaces.Task;
import org.globus.cog.abstraction.interfaces.TaskHandler;

public class TaskHandlerImpl
implements TaskHandler,
StatusListener {
    private Vector submittedList = new Vector();
    private Vector activeList = new Vector();
    private Vector suspendedList = new Vector();
    private Vector resumedList = new Vector();
    private Vector failedList = new Vector();
    private Vector canceledList = new Vector();
    private Vector completedList = new Vector();
    private Hashtable handleMap = new Hashtable();
    private int type = 2;

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void submit(Task task) throws IllegalSpecException, InvalidSecurityContextException, InvalidServiceContactException, TaskSubmissionException {
        if (task.getStatus().getStatusCode() != 0) {
            throw new TaskSubmissionException("TaskHandler can only handle unsubmitted tasks");
        }
        if (task.getType() != 1) {
            throw new TaskSubmissionException("GT2 execution task handler can only handle job submission tasks");
        }
        int type = task.getType();
        DelegatedTaskHandler dth = DelegatedTaskHandlerFactory.newTaskHandler(type);
        task.addStatusListener((StatusListener)this);
        this.handleMap.put(task, dth);
        dth.submit(task);
    }

    public void suspend(Task task) throws InvalidSecurityContextException, TaskSubmissionException {
        DelegatedTaskHandler dth = (DelegatedTaskHandler)this.handleMap.get(task);
        if (dth != null) {
            dth.suspend();
        }
    }

    public void resume(Task task) throws InvalidSecurityContextException, TaskSubmissionException {
        DelegatedTaskHandler dth = (DelegatedTaskHandler)this.handleMap.get(task);
        if (dth != null) {
            dth.resume();
        }
    }

    public void cancel(Task task) throws InvalidSecurityContextException, TaskSubmissionException {
        DelegatedTaskHandler dth = (DelegatedTaskHandler)this.handleMap.get(task);
        if (dth != null) {
            dth.cancel();
        } else {
            task.setStatus(6);
        }
    }

    public void remove(Task task) throws ActiveTaskException {
        if (!this.handleMap.containsKey(task)) {
            return;
        }
        int status = task.getStatus().getStatusCode();
        if (status == 2) {
            throw new ActiveTaskException("Cannot remove an active or suspended Task");
        }
        this.failedList.remove(task);
        this.canceledList.remove(task);
        this.completedList.remove(task);
        this.suspendedList.remove(task);
        this.submittedList.remove(task);
        this.handleMap.remove(task);
        this.activeList.remove(task);
    }

    public Collection getAllTasks() {
        try {
            return new ArrayList(this.handleMap.keySet());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Collection getActiveTasks() {
        return new ArrayList(this.activeList);
    }

    public Collection getFailedTasks() {
        return new ArrayList(this.failedList);
    }

    public Collection getCompletedTasks() {
        return new ArrayList(this.completedList);
    }

    public Collection getSuspendedTasks() {
        return new ArrayList(this.suspendedList);
    }

    public Collection getResumedTasks() {
        return new ArrayList(this.resumedList);
    }

    public Collection getCanceledTasks() {
        return new ArrayList(this.canceledList);
    }

    public void statusChanged(StatusEvent event) {
        Task task = (Task)event.getSource();
        Status status = event.getStatus();
        int prevStatus = status.getPrevStatusCode();
        int curStatus = status.getStatusCode();
        switch (prevStatus) {
            case 1: {
                this.submittedList.remove(task);
                break;
            }
            case 2: {
                this.activeList.remove(task);
                break;
            }
            case 3: {
                this.suspendedList.remove(task);
                break;
            }
            case 4: {
                this.resumedList.remove(task);
                break;
            }
            case 5: {
                this.failedList.remove(task);
                break;
            }
            case 6: {
                this.canceledList.remove(task);
                break;
            }
            case 7: {
                this.completedList.remove(task);
                break;
            }
        }
        if (task != null) {
            switch (curStatus) {
                case 1: {
                    this.submittedList.add(task);
                    break;
                }
                case 2: {
                    this.activeList.add(task);
                    break;
                }
                case 3: {
                    this.suspendedList.add(task);
                    break;
                }
                case 4: {
                    this.resumedList.add(task);
                    break;
                }
                case 5: {
                    this.failedList.add(task);
                    this.handleMap.remove(task);
                    break;
                }
                case 6: {
                    this.canceledList.add(task);
                    this.handleMap.remove(task);
                    break;
                }
                case 7: {
                    this.completedList.add(task);
                    this.handleMap.remove(task);
                    break;
                }
            }
        }
    }
}

