/*
 * Decompiled with CFR 0.152.
 */
package org.globus.cog.abstraction.impl.execution.gt2;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.globus.cog.abstraction.impl.common.StatusImpl;
import org.globus.cog.abstraction.impl.common.task.IllegalSpecException;
import org.globus.cog.abstraction.impl.common.task.InvalidSecurityContextException;
import org.globus.cog.abstraction.impl.common.task.InvalidServiceContactException;
import org.globus.cog.abstraction.impl.common.task.TaskSubmissionException;
import org.globus.cog.abstraction.impl.execution.gt2.GassServerFactory;
import org.globus.cog.abstraction.impl.execution.gt2.GlobusSecurityContextImpl;
import org.globus.cog.abstraction.impl.execution.gt2.MultiJobListener;
import org.globus.cog.abstraction.interfaces.DelegatedTaskHandler;
import org.globus.cog.abstraction.interfaces.JobSpecification;
import org.globus.cog.abstraction.interfaces.ServiceContact;
import org.globus.cog.abstraction.interfaces.Status;
import org.globus.cog.abstraction.interfaces.Task;
import org.globus.gram.GramException;
import org.globus.gram.GramJob;
import org.globus.gram.GramJobListener;
import org.globus.io.gass.server.GassServer;
import org.globus.io.gass.server.JobOutputListener;
import org.globus.io.gass.server.JobOutputStream;
import org.globus.rsl.NameOpValue;
import org.globus.rsl.RSLParser;
import org.globus.rsl.RslNode;
import org.globus.rsl.Value;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class JobSubmissionTaskHandler
implements DelegatedTaskHandler,
GramJobListener,
JobOutputListener {
    static Logger logger = Logger.getLogger((String)(class$org$globus$cog$abstraction$impl$execution$gt2$JobSubmissionTaskHandler == null ? (class$org$globus$cog$abstraction$impl$execution$gt2$JobSubmissionTaskHandler = JobSubmissionTaskHandler.class$("org.globus.cog.abstraction.impl.execution.gt2.JobSubmissionTaskHandler")) : class$org$globus$cog$abstraction$impl$execution$gt2$JobSubmissionTaskHandler).getName());
    private Task task = null;
    private GramJob gramJob;
    private Vector jobList = null;
    private boolean startGassServer = false;
    private GassServer gassServer = null;
    private JobOutputStream stdoutStream;
    private JobOutputStream stderrStream;
    static /* synthetic */ Class class$org$globus$cog$abstraction$impl$execution$gt2$JobSubmissionTaskHandler;

    public void submit(Task task) throws IllegalSpecException, InvalidSecurityContextException, InvalidServiceContactException, TaskSubmissionException {
        JobSpecification spec;
        if (this.task != null) {
            throw new TaskSubmissionException("JobSubmissionTaskHandler cannot handle two active jobs simultaneously");
        }
        this.task = task;
        try {
            spec = (JobSpecification)this.task.getSpecification();
        }
        catch (Exception e) {
            throw new IllegalSpecException("Exception while retreiving Job Specification", (Throwable)e);
        }
        String rsl = this.prepareSpecification(spec);
        RslNode rslTree = null;
        try {
            rslTree = RSLParser.parse((String)rsl);
        }
        catch (Throwable e) {
            throw new IllegalSpecException("Cannot parse the given RSL", e);
        }
        logger.debug((Object)("RSL: " + rsl));
        if (rslTree.getOperator() == 3) {
            this.task.setAttribute("jobCount", (Object)"multiple");
            this.submitMultipleJobs(rslTree, spec);
        } else {
            this.task.setAttribute("jobCount", (Object)"single");
            this.submitSingleJob(rsl, spec);
        }
    }

    private void submitSingleJob(String rsl, JobSpecification spec) throws IllegalSpecException, InvalidSecurityContextException, InvalidServiceContactException, TaskSubmissionException {
        this.gramJob = new GramJob(rsl);
        GlobusSecurityContextImpl securityContext = this.getSecurityContext();
        try {
            this.gramJob.setCredentials((GSSCredential)securityContext.getCredentials());
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidSecurityContextException("Cannot set the SecurityContext twice", (Throwable)iae);
        }
        if (!spec.isBatchJob()) {
            this.gramJob.addListener((GramJobListener)this);
        }
        ServiceContact serviceContact = this.task.getService(0).getServiceContact();
        String server = serviceContact.getContact();
        String jobmanager = (String)this.task.getService(0).getAttribute("jobmanager");
        if (jobmanager != null) {
            server = this.handleJobManager(server, jobmanager);
        }
        logger.debug((Object)("Execution server: " + server));
        boolean limitedDeleg = securityContext.getDelegation() == 2;
        try {
            if (this.task.getStatus().getStatusCode() == 0) {
                this.gramJob.request(server, spec.isBatchJob(), limitedDeleg);
                logger.debug((Object)("Submitted job with Globus ID: " + this.gramJob.getIDAsString()));
                this.task.setStatus(1);
                if (spec.isBatchJob()) {
                    this.task.setStatus(7);
                }
            }
        }
        catch (GramException ge) {
            StatusImpl newStatus = new StatusImpl();
            Status oldStatus = this.task.getStatus();
            newStatus.setPrevStatusCode(oldStatus.getStatusCode());
            newStatus.setStatusCode(5);
            newStatus.setException((Exception)((Object)ge));
            this.task.setStatus((Status)newStatus);
            this.cleanup();
            throw new TaskSubmissionException("Cannot submit job", (Throwable)ge);
        }
        catch (GSSException gsse) {
            StatusImpl newStatus = new StatusImpl();
            Status oldStatus = this.task.getStatus();
            newStatus.setPrevStatusCode(oldStatus.getStatusCode());
            newStatus.setStatusCode(5);
            newStatus.setException((Exception)gsse);
            this.task.setStatus((Status)newStatus);
            this.cleanup();
            throw new InvalidSecurityContextException("Invalid GSSCredentials", (Throwable)gsse);
        }
    }

    private void submitMultipleJobs(RslNode rslTree, JobSpecification spec) throws IllegalSpecException, InvalidSecurityContextException, InvalidServiceContactException, TaskSubmissionException {
        MultiJobListener listener = new MultiJobListener(this.task);
        this.jobList = new Vector();
        List jobs = rslTree.getSpecifications();
        Iterator iter = jobs.iterator();
        while (iter.hasNext()) {
            RslNode node = (RslNode)iter.next();
            String rsl = node.toRSL(true);
            NameOpValue nv = node.getParam("resourceManagerContact");
            if (nv == null) {
                throw new IllegalSpecException("Error: No resource manager contact for job.");
            }
            Object obj = nv.getFirstValue();
            if (obj instanceof Value) {
                String rmc = ((Value)obj).getValue();
                this.multiRunSub(rsl, rmc, listener);
            }
            this.task.setStatus(1);
        }
    }

    private void multiRunSub(String rsl, String rmc, MultiJobListener listener) throws InvalidSecurityContextException, TaskSubmissionException {
        GramJob job = new GramJob(rsl);
        job.addListener((GramJobListener)listener);
        GlobusSecurityContextImpl securityContext = this.getSecurityContext();
        try {
            job.setCredentials((GSSCredential)securityContext.getCredentials());
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidSecurityContextException("Cannot set the SecurityContext twice", (Throwable)iae);
        }
        boolean limitedDeleg = securityContext.getDelegation() == 2;
        try {
            job.request(rmc, false, limitedDeleg);
            logger.debug((Object)("Submitted job with Globus ID: " + job.getIDAsString()));
        }
        catch (GramException ge) {
            StatusImpl newStatus = new StatusImpl();
            Status oldStatus = this.task.getStatus();
            newStatus.setPrevStatusCode(oldStatus.getStatusCode());
            newStatus.setStatusCode(5);
            newStatus.setException((Exception)((Object)ge));
            this.task.setStatus((Status)newStatus);
            listener.failed(true);
            throw new TaskSubmissionException("Cannot submit job", (Throwable)ge);
        }
        catch (GSSException gsse) {
            StatusImpl newStatus = new StatusImpl();
            Status oldStatus = this.task.getStatus();
            newStatus.setPrevStatusCode(oldStatus.getStatusCode());
            newStatus.setStatusCode(5);
            newStatus.setException((Exception)gsse);
            this.task.setStatus((Status)newStatus);
            listener.failed(true);
            throw new InvalidSecurityContextException("Invalid GSSCredentials", (Throwable)gsse);
        }
        listener.runningJob();
    }

    public void suspend() throws InvalidSecurityContextException, TaskSubmissionException {
    }

    public void resume() throws InvalidSecurityContextException, TaskSubmissionException {
    }

    public void cancel() throws InvalidSecurityContextException, TaskSubmissionException {
        try {
            if (this.task.getStatus().getStatusCode() == 0) {
                this.task.setStatus(6);
                return;
            }
            String jobCount = (String)this.task.getAttribute("jobCount");
            if (jobCount.equalsIgnoreCase("multiple")) {
                Iterator iterator = this.jobList.iterator();
                while (iterator.hasNext()) {
                    GramJob job = (GramJob)iterator.next();
                    job.cancel();
                }
            } else {
                this.gramJob.cancel();
            }
            this.task.setStatus(6);
        }
        catch (GramException ge) {
            this.cleanup();
            throw new TaskSubmissionException("Cannot cancel job", (Throwable)ge);
        }
        catch (GSSException gsse) {
            this.cleanup();
            throw new InvalidSecurityContextException("Invalid GSSCredentials", (Throwable)gsse);
        }
    }

    private String prepareSpecification(JobSpecification spec) throws IllegalSpecException, TaskSubmissionException {
        if (spec.getSpecification() != null) {
            return spec.getSpecification();
        }
        StringBuffer buf = new StringBuffer("&");
        boolean batchJob = spec.isBatchJob();
        boolean redirected = spec.isRedirected();
        boolean localExecutable = spec.isLocalExecutable();
        boolean localInput = spec.isLocalInput();
        if (batchJob && redirected) {
            throw new IllegalSpecException("Cannot redirect the output/error of a batch job");
        }
        if (redirected || localExecutable || localInput) {
            this.startGassServer = true;
            String gassURL = this.startGassServer();
            this.appendRSL(buf, "rsl_substitution", "(GLOBUSRUN_GASS_URL " + gassURL + ")");
        }
        if (this.startGassServer && localExecutable) {
            this.appendRSL(buf, "executable", "$(GLOBUSRUN_GASS_URL)" + spec.getExecutable());
        } else {
            this.appendRSL(buf, "executable", spec.getExecutable());
        }
        this.appendRSL(buf, "arguments", spec.getArgumentsAsString());
        this.appendRSL(buf, "directory", spec.getDirectory());
        Collection environment = spec.getEnvironment();
        if (environment.size() > 0) {
            String env = "";
            Iterator iterator = environment.iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                String value = spec.getEnvironmentVariable(name);
                env = env + "(" + name + " " + value + ")";
            }
            this.appendRSL(buf, "environment", env);
        }
        if (this.startGassServer && localInput) {
            this.appendRSL(buf, "stdin", "$(GLOBUSRUN_GASS_URL)" + spec.getStdInput());
        } else {
            this.appendRSL(buf, "stdin", spec.getStdInput());
        }
        if (this.startGassServer && redirected) {
            if (spec.getStdOutput() == null || spec.getStdOutput().equals("")) {
                this.appendRSL(buf, "stdout", "$(GLOBUSRUN_GASS_URL)/dev/stdout-" + this.task.getIdentity().toString());
            } else {
                this.appendRSL(buf, "stdout", "$(GLOBUSRUN_GASS_URL)/" + spec.getStdOutput());
            }
        } else {
            this.appendRSL(buf, "stdout", spec.getStdOutput());
        }
        if (this.startGassServer && redirected) {
            if (spec.getStdError() == null || spec.getStdError().equals("")) {
                this.appendRSL(buf, "stderr", "$(GLOBUSRUN_GASS_URL)/dev/stderr-" + this.task.getIdentity().toString());
            } else {
                this.appendRSL(buf, "stderr", "$(GLOBUSRUN_GASS_URL)/" + spec.getStdError());
            }
        } else {
            this.appendRSL(buf, "stderr", spec.getStdError());
        }
        Enumeration en = spec.getAllAttributes();
        while (en.hasMoreElements()) {
            try {
                String key = (String)en.nextElement();
                this.appendRSL(buf, key, (String)spec.getAttribute(key));
            }
            catch (Exception e) {
                throw new IllegalSpecException("Cannot parse the user defined attributes");
            }
        }
        return buf.toString();
    }

    private void appendRSL(StringBuffer rsl, String attribute, String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        rsl.append("(");
        rsl.append(attribute);
        rsl.append("=");
        rsl.append(value);
        rsl.append(")");
    }

    private String startGassServer() throws TaskSubmissionException {
        GlobusSecurityContextImpl securityContext = (GlobusSecurityContextImpl)this.task.getService(0).getSecurityContext();
        String gassURL = null;
        if (this.gassServer == null) {
            try {
                this.gassServer = GassServerFactory.getGassServer((GSSCredential)securityContext.getCredentials());
            }
            catch (Exception e) {
                throw new TaskSubmissionException("Problems while creating a Gass Server", (Throwable)e);
            }
        }
        this.gassServer.registerDefaultDeactivator();
        gassURL = this.gassServer.getURL();
        this.stdoutStream = new JobOutputStream((JobOutputListener)this);
        this.stderrStream = new JobOutputStream((JobOutputListener)this);
        this.gassServer.registerJobOutputStream("err-" + this.task.getIdentity().toString(), (OutputStream)this.stderrStream);
        this.gassServer.registerJobOutputStream("out-" + this.task.getIdentity().toString(), (OutputStream)this.stdoutStream);
        logger.debug((Object)"Started the GASS server");
        return gassURL;
    }

    public void statusChanged(GramJob job) {
        int status = job.getStatus();
        switch (status) {
            case 2: {
                this.task.setStatus(2);
                break;
            }
            case 4: {
                StatusImpl newStatus = new StatusImpl();
                Status oldStatus = this.task.getStatus();
                newStatus.setPrevStatusCode(oldStatus.getStatusCode());
                newStatus.setStatusCode(5);
                int errorCode = job.getError();
                Exception e = new Exception("Error code: " + errorCode);
                newStatus.setException(e);
                this.task.setStatus((Status)newStatus);
                break;
            }
            case 8: {
                this.task.setStatus(7);
                break;
            }
            case 16: {
                this.task.setStatus(3);
                break;
            }
            case 32: {
                this.task.setStatus(0);
                break;
            }
        }
        if (status == 4 || status == 8) {
            this.cleanup();
        }
    }

    private void cleanup() {
        this.gramJob.removeListener((GramJobListener)this);
    }

    public void outputChanged(String s) {
        String output = this.task.getStdOutput();
        output = output == null ? s : output + s;
        this.task.setStdOutput(output);
    }

    public void outputClosed() {
    }

    private GlobusSecurityContextImpl getSecurityContext() {
        GlobusSecurityContextImpl securityContext = (GlobusSecurityContextImpl)this.task.getService(0).getSecurityContext();
        if (securityContext == null) {
            securityContext = new GlobusSecurityContextImpl();
        }
        return securityContext;
    }

    private String handleJobManager(String server, String jobmanager) throws InvalidServiceContactException {
        if (jobmanager.equalsIgnoreCase("FORK") || jobmanager.equalsIgnoreCase("jobmanager-FORK")) {
            logger.debug((Object)("Using the FORK jobmanager: " + server + "/jobmanager-fork"));
            return server + "/jobmanager-fork";
        }
        if (jobmanager.equalsIgnoreCase("PBS") || jobmanager.equalsIgnoreCase("jobmanager-PBS")) {
            logger.debug((Object)("Using the PBS jobmanager: " + server + "/jobmanager-pbs"));
            return server + "/jobmanager-pbs";
        }
        throw new InvalidServiceContactException(jobmanager + " job manager is not supported by the GT2 provider");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

