/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.ptls;

import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.cert.X509Name;
import COM.claymoresystems.sslg.CertVerifyPolicyInt;
import COM.claymoresystems.sslg.DistinguishedName;
import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.ChainedGeneralSecurityException;
import org.globus.gsi.ptls.PureTLSContext;
import org.globus.util.I18n;

public class PureTLSUtil {
    private static I18n i18n = I18n.getI18n("org.globus.gsi.ptls.errors", (class$org$globus$gsi$ptls$PureTLSUtil == null ? (class$org$globus$gsi$ptls$PureTLSUtil = PureTLSUtil.class$("org.globus.gsi.ptls.PureTLSUtil")) : class$org$globus$gsi$ptls$PureTLSUtil).getClassLoader());
    private static Log logger = LogFactory.getLog((String)(class$org$globus$gsi$ptls$PureTLSUtil == null ? (class$org$globus$gsi$ptls$PureTLSUtil = PureTLSUtil.class$("org.globus.gsi.ptls.PureTLSUtil")) : class$org$globus$gsi$ptls$PureTLSUtil).getName());
    static /* synthetic */ Class class$org$globus$gsi$ptls$PureTLSUtil;

    public static X509Certificate convertCert(X509Cert cert) throws GeneralSecurityException {
        CertificateFactory f = CertificateFactory.getInstance("X.509", "BC");
        ByteArrayInputStream in = new ByteArrayInputStream(cert.getDER());
        return (X509Certificate)f.generateCertificate(in);
    }

    public static X509Name getX509Name(String globusID) throws Exception {
        Vector<Vector> dn = new Vector<Vector>();
        int off = 0;
        int start = 0;
        boolean done = false;
        while (!done) {
            Vector rdn;
            block4: {
                block5: {
                    int pos3;
                    int pos1 = globusID.indexOf(61, off);
                    if (pos1 == -1) {
                        throw new Exception(i18n.getMessage("malformedName", new String[]{"=", globusID}));
                    }
                    rdn = null;
                    start = pos1 + 1;
                    while (true) {
                        int pos2;
                        if ((pos2 = globusID.indexOf(61, pos1 + 1)) == -1) {
                            rdn = PureTLSUtil.parseRDN(globusID.substring(off));
                            done = true;
                            break block4;
                        }
                        pos3 = globusID.lastIndexOf(47, pos2);
                        if (pos3 == -1) break block5;
                        if (pos3 > pos1) break;
                        pos1 = pos2;
                    }
                    rdn = PureTLSUtil.parseRDN(globusID.substring(off, pos3));
                    off = pos3;
                    break block4;
                }
                throw new Exception(i18n.getMessage("malformedName", new String[]{"/", globusID}));
            }
            if (rdn == null) continue;
            dn.addElement(rdn);
        }
        return new X509Name(dn);
    }

    private static Vector parseRDN(String token) throws Exception {
        if (token.charAt(0) != '/') {
            throw new Exception(i18n.getMessage("invalidToken00", token));
        }
        Vector<String[]> rdn = null;
        int pos = token.indexOf(43);
        if (pos == -1) {
            rdn = new Vector<String[]>(1);
            rdn.addElement(PureTLSUtil.getAVA(token.substring(1)));
        } else {
            rdn = new Vector(2);
            rdn.addElement(PureTLSUtil.getAVA(token.substring(1, pos)));
            rdn.addElement(PureTLSUtil.getAVA(token.substring(pos + 1)));
        }
        return rdn;
    }

    private static String[] getAVA(String rdn) throws Exception {
        int pos = rdn.indexOf(61);
        if (pos == -1) {
            throw new Exception(i18n.getMessage("rdnMissing", rdn));
        }
        String[] ava = new String[]{rdn.substring(0, pos).trim().toUpperCase(), rdn.substring(pos + 1).trim()};
        return ava;
    }

    public static X509Name getBase(DistinguishedName name) {
        Vector rdn;
        String[] ava;
        X509Name nm = PureTLSUtil.dupName(name);
        Vector dn = nm.getName();
        int len = dn.size();
        for (int i = len - 1; i >= 0 && (ava = (String[])(rdn = (Vector)dn.elementAt(i)).elementAt(0))[0].equalsIgnoreCase("CN") && (ava[1].equalsIgnoreCase("proxy") || ava[1].equalsIgnoreCase("limited proxy")); --i) {
            dn.removeElementAt(i);
        }
        return new X509Name(dn);
    }

    public static int checkProxyName(X509Cert cert) {
        int rs = -1;
        X509Name subject = PureTLSUtil.dupName(cert.getSubjectName());
        Vector subjectDN = subject.getName();
        Vector lastAva = (Vector)subjectDN.elementAt(subjectDN.size() - 1);
        String[] ava = (String[])lastAva.elementAt(0);
        if (ava[0].equalsIgnoreCase("CN")) {
            if (ava[1].equalsIgnoreCase("proxy")) {
                rs = 10;
            } else if (ava[1].equalsIgnoreCase("limited proxy")) {
                rs = 11;
            }
            if (rs != -1) {
                Vector nameDN = PureTLSUtil.dupName(cert.getIssuerName()).getName();
                nameDN.addElement(lastAva);
                X509Name newName = new X509Name(nameDN);
                return Arrays.equals(subject.getNameDER(), newName.getNameDER()) ? rs : -1;
            }
        }
        return rs;
    }

    public static X509Name dupName(DistinguishedName name) {
        return new X509Name(name.getName());
    }

    public static Vector certificateChainToVector(X509Certificate[] certs) throws GeneralSecurityException {
        if (certs == null) {
            return null;
        }
        Vector<X509Cert> v = new Vector<X509Cert>(certs.length);
        try {
            for (int i = certs.length - 1; i >= 0; --i) {
                v.addElement(new X509Cert(certs[i].getEncoded()));
            }
        }
        catch (Exception e) {
            throw new ChainedGeneralSecurityException(i18n.getMessage("conversionFail"), e);
        }
        return v;
    }

    public static X509Certificate[] certificateChainToArray(Vector chain) throws GeneralSecurityException {
        int size = chain.size();
        X509Certificate[] certs = new X509Certificate[size];
        for (int i = 0; i < size; ++i) {
            certs[i] = PureTLSUtil.convertCert((X509Cert)chain.elementAt(size - 1 - i));
        }
        return certs;
    }

    public static CertVerifyPolicyInt getDefaultCertVerifyPolicy() {
        CertVerifyPolicyInt certPolicy = new CertVerifyPolicyInt();
        certPolicy.checkDates(false);
        certPolicy.requireBasicConstraints(false);
        certPolicy.requireBasicConstraintsCritical(false);
        certPolicy.requireKeyUsage(false);
        return certPolicy;
    }

    public static String getGlobusId(byte[] cert) throws Exception {
        X509Cert crt = new X509Cert(cert);
        X509Name subject = PureTLSUtil.getBase(crt.getSubjectName());
        return PureTLSUtil.toGlobusID((DistinguishedName)subject);
    }

    public static String toGlobusID(DistinguishedName subject) {
        Vector dn = subject.getName();
        int len = dn.size();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            Vector rdn = (Vector)dn.elementAt(i);
            String[] ava = (String[])rdn.elementAt(0);
            buf.append('/').append(ava[0]).append('=').append(ava[1]);
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PureTLSContext.init();
    }
}

