/*
 * Decompiled with CFR 0.152.
 */
package org.globus.util;

import java.util.Enumeration;

public class QuotedStringTokenizer
implements Enumeration {
    private int limit;
    private int start;
    private String str;

    public QuotedStringTokenizer(String str) {
        this.str = str;
        this.start = 0;
        this.limit = str.length();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public String nextToken() {
        while (this.start < this.limit && this.str.charAt(this.start) <= ' ') {
            ++this.start;
        }
        if (this.start == this.limit) {
            return null;
        }
        StringBuffer buf = new StringBuffer(this.limit - this.start);
        char quote = this.str.charAt(this.start);
        if (quote == '\"' || quote == '\'') {
            ++this.start;
            for (int i = this.start; i < this.limit; ++i) {
                char ch = this.str.charAt(i);
                ++this.start;
                if (ch == quote) break;
                if (ch == '\\') {
                    buf.append(this.str.charAt(++i));
                    ++this.start;
                    continue;
                }
                buf.append(ch);
            }
            return buf.toString();
        }
        for (int i = this.start; i < this.limit; ++i) {
            char ch = this.str.charAt(i);
            ++this.start;
            if (ch == ' ') break;
            buf.append(ch);
        }
        return buf.toString();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreTokens() {
        while (this.start < this.limit && this.str.charAt(this.start) <= ' ') {
            ++this.start;
        }
        return this.start != this.limit;
    }

    public int countTokens() {
        int localStart = this.start;
        int i = 0;
        while (this.nextToken() != null) {
            ++i;
        }
        this.start = localStart;
        return i;
    }
}

